rule win_unidentified_020_cia_vault7_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.unidentified_020_cia_vault7."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.unidentified_020_cia_vault7"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 50 8d45f0 64a300000000 8965e8 8b7d08 c745fc00000000 8b07 }
            // n = 7, score = 200
            //   50                   | push                eax
            //   8d45f0               | lea                 eax, [ebp - 0x10]
            //   64a300000000         | mov                 dword ptr fs:[0], eax
            //   8965e8               | mov                 dword ptr [ebp - 0x18], esp
            //   8b7d08               | mov                 edi, dword ptr [ebp + 8]
            //   c745fc00000000       | mov                 dword ptr [ebp - 4], 0
            //   8b07                 | mov                 eax, dword ptr [edi]

        $sequence_1 = { a1???????? 33c4 89842428080000 8b4508 53 }
            // n = 5, score = 200
            //   a1????????           |                     
            //   33c4                 | xor                 eax, esp
            //   89842428080000       | mov                 dword ptr [esp + 0x828], eax
            //   8b4508               | mov                 eax, dword ptr [ebp + 8]
            //   53                   | push                ebx

        $sequence_2 = { 52 8d85c6f7ffff 50 e8???????? 8bbdb8f7ffff }
            // n = 5, score = 200
            //   52                   | push                edx
            //   8d85c6f7ffff         | lea                 eax, [ebp - 0x83a]
            //   50                   | push                eax
            //   e8????????           |                     
            //   8bbdb8f7ffff         | mov                 edi, dword ptr [ebp - 0x848]

        $sequence_3 = { 33c0 8d8decfdffff 51 8d95c8fdffff 52 8985ccfdffff }
            // n = 6, score = 200
            //   33c0                 | xor                 eax, eax
            //   8d8decfdffff         | lea                 ecx, [ebp - 0x214]
            //   51                   | push                ecx
            //   8d95c8fdffff         | lea                 edx, [ebp - 0x238]
            //   52                   | push                edx
            //   8985ccfdffff         | mov                 dword ptr [ebp - 0x234], eax

        $sequence_4 = { 50 ff15???????? 85c0 7516 56 8945f8 }
            // n = 6, score = 200
            //   50                   | push                eax
            //   ff15????????         |                     
            //   85c0                 | test                eax, eax
            //   7516                 | jne                 0x18
            //   56                   | push                esi
            //   8945f8               | mov                 dword ptr [ebp - 8], eax

        $sequence_5 = { 68???????? 57 ff15???????? 8bd8 3bdf 742e 53 }
            // n = 7, score = 200
            //   68????????           |                     
            //   57                   | push                edi
            //   ff15????????         |                     
            //   8bd8                 | mov                 ebx, eax
            //   3bdf                 | cmp                 ebx, edi
            //   742e                 | je                  0x30
            //   53                   | push                ebx

        $sequence_6 = { 8907 897704 8b8dbcf7ffff 890f 50 }
            // n = 5, score = 200
            //   8907                 | mov                 dword ptr [edi], eax
            //   897704               | mov                 dword ptr [edi + 4], esi
            //   8b8dbcf7ffff         | mov                 ecx, dword ptr [ebp - 0x844]
            //   890f                 | mov                 dword ptr [edi], ecx
            //   50                   | push                eax

        $sequence_7 = { 837e1400 750f 6a7f ff15???????? 33c0 5e 8be5 }
            // n = 7, score = 200
            //   837e1400             | cmp                 dword ptr [esi + 0x14], 0
            //   750f                 | jne                 0x11
            //   6a7f                 | push                0x7f
            //   ff15????????         |                     
            //   33c0                 | xor                 eax, eax
            //   5e                   | pop                 esi
            //   8be5                 | mov                 esp, ebp

        $sequence_8 = { 68???????? 33f6 68???????? 56 8975fc c745f801000000 ff15???????? }
            // n = 7, score = 200
            //   68????????           |                     
            //   33f6                 | xor                 esi, esi
            //   68????????           |                     
            //   56                   | push                esi
            //   8975fc               | mov                 dword ptr [ebp - 4], esi
            //   c745f801000000       | mov                 dword ptr [ebp - 8], 1
            //   ff15????????         |                     

        $sequence_9 = { 6aff 51 8b4d0c 6804010000 51 e8???????? 83c410 }
            // n = 7, score = 200
            //   6aff                 | push                -1
            //   51                   | push                ecx
            //   8b4d0c               | mov                 ecx, dword ptr [ebp + 0xc]
            //   6804010000           | push                0x104
            //   51                   | push                ecx
            //   e8????????           |                     
            //   83c410               | add                 esp, 0x10

    condition:
        7 of them and filesize < 253952
}