rule win_unidentified_023_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.unidentified_023."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.unidentified_023"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { b8cccccccc f3ab a1???????? 8945e4 8b0d???????? }
            // n = 5, score = 200
            //   b8cccccccc           | mov                 eax, 0xcccccccc
            //   f3ab                 | rep stosd           dword ptr es:[edi], eax
            //   a1????????           |                     
            //   8945e4               | mov                 dword ptr [ebp - 0x1c], eax
            //   8b0d????????         |                     

        $sequence_1 = { 894df4 8a15???????? 8855f8 837d0c01 7514 8bf4 }
            // n = 6, score = 200
            //   894df4               | mov                 dword ptr [ebp - 0xc], ecx
            //   8a15????????         |                     
            //   8855f8               | mov                 byte ptr [ebp - 8], dl
            //   837d0c01             | cmp                 dword ptr [ebp + 0xc], 1
            //   7514                 | jne                 0x16
            //   8bf4                 | mov                 esi, esp

        $sequence_2 = { 8855f8 837d0c01 7514 8bf4 68???????? ff15???????? }
            // n = 6, score = 200
            //   8855f8               | mov                 byte ptr [ebp - 8], dl
            //   837d0c01             | cmp                 dword ptr [ebp + 0xc], 1
            //   7514                 | jne                 0x16
            //   8bf4                 | mov                 esi, esp
            //   68????????           |                     
            //   ff15????????         |                     

        $sequence_3 = { 8a15???????? 8855f8 837d0c01 7514 8bf4 }
            // n = 5, score = 200
            //   8a15????????         |                     
            //   8855f8               | mov                 byte ptr [ebp - 8], dl
            //   837d0c01             | cmp                 dword ptr [ebp + 0xc], 1
            //   7514                 | jne                 0x16
            //   8bf4                 | mov                 esi, esp

        $sequence_4 = { 8855f8 837d0c01 7514 8bf4 68???????? ff15???????? 3bf4 }
            // n = 7, score = 200
            //   8855f8               | mov                 byte ptr [ebp - 8], dl
            //   837d0c01             | cmp                 dword ptr [ebp + 0xc], 1
            //   7514                 | jne                 0x16
            //   8bf4                 | mov                 esi, esp
            //   68????????           |                     
            //   ff15????????         |                     
            //   3bf4                 | cmp                 esi, esp

        $sequence_5 = { 0909 0909 0407 0807 8d4900 4f }
            // n = 6, score = 200
            //   0909                 | or                  dword ptr [ecx], ecx
            //   0909                 | or                  dword ptr [ecx], ecx
            //   0407                 | add                 al, 7
            //   0807                 | or                  byte ptr [edi], al
            //   8d4900               | lea                 ecx, [ecx]
            //   4f                   | dec                 edi

        $sequence_6 = { 68???????? ff15???????? 3bf4 e8???????? b801000000 52 8bcd }
            // n = 7, score = 200
            //   68????????           |                     
            //   ff15????????         |                     
            //   3bf4                 | cmp                 esi, esp
            //   e8????????           |                     
            //   b801000000           | mov                 eax, 1
            //   52                   | push                edx
            //   8bcd                 | mov                 ecx, ebp

        $sequence_7 = { b938000000 b8cccccccc f3ab a1???????? 8945e4 8b0d???????? }
            // n = 6, score = 200
            //   b938000000           | mov                 ecx, 0x38
            //   b8cccccccc           | mov                 eax, 0xcccccccc
            //   f3ab                 | rep stosd           dword ptr es:[edi], eax
            //   a1????????           |                     
            //   8945e4               | mov                 dword ptr [ebp - 0x1c], eax
            //   8b0d????????         |                     

        $sequence_8 = { 0909 0909 0909 0407 0807 8d4900 4f }
            // n = 7, score = 200
            //   0909                 | or                  dword ptr [ecx], ecx
            //   0909                 | or                  dword ptr [ecx], ecx
            //   0909                 | or                  dword ptr [ecx], ecx
            //   0407                 | add                 al, 7
            //   0807                 | or                  byte ptr [edi], al
            //   8d4900               | lea                 ecx, [ecx]
            //   4f                   | dec                 edi

        $sequence_9 = { 8945f0 8b0d???????? 894df4 8a15???????? 8855f8 837d0c01 }
            // n = 6, score = 200
            //   8945f0               | mov                 dword ptr [ebp - 0x10], eax
            //   8b0d????????         |                     
            //   894df4               | mov                 dword ptr [ebp - 0xc], ecx
            //   8a15????????         |                     
            //   8855f8               | mov                 byte ptr [ebp - 8], dl
            //   837d0c01             | cmp                 dword ptr [ebp + 0xc], 1

    condition:
        7 of them and filesize < 1433600
}