rule win_unidentified_031_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.unidentified_031."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.unidentified_031"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 50 e8???????? 897de8 89bd40ffffff e9???????? 817d8004000400 754f }
            // n = 7, score = 100
            //   50                   | push                eax
            //   e8????????           |                     
            //   897de8               | mov                 dword ptr [ebp - 0x18], edi
            //   89bd40ffffff         | mov                 dword ptr [ebp - 0xc0], edi
            //   e9????????           |                     
            //   817d8004000400       | cmp                 dword ptr [ebp - 0x80], 0x40004
            //   754f                 | jne                 0x51

        $sequence_1 = { 3935???????? 7510 68???????? 68???????? ff15???????? 8b35???????? 8d9544ffffff }
            // n = 7, score = 100
            //   3935????????         |                     
            //   7510                 | jne                 0x12
            //   68????????           |                     
            //   68????????           |                     
            //   ff15????????         |                     
            //   8b35????????         |                     
            //   8d9544ffffff         | lea                 edx, [ebp - 0xbc]

        $sequence_2 = { 83bd78ffffff03 0f82e5feffff 33c0 8b4dfc 5f 5e 5b }
            // n = 7, score = 100
            //   83bd78ffffff03       | cmp                 dword ptr [ebp - 0x88], 3
            //   0f82e5feffff         | jb                  0xfffffeeb
            //   33c0                 | xor                 eax, eax
            //   8b4dfc               | mov                 ecx, dword ptr [ebp - 4]
            //   5f                   | pop                 edi
            //   5e                   | pop                 esi
            //   5b                   | pop                 ebx

        $sequence_3 = { 51 52 6a12 ff15???????? 83c44c 8d4da0 ff15???????? }
            // n = 7, score = 100
            //   51                   | push                ecx
            //   52                   | push                edx
            //   6a12                 | push                0x12
            //   ff15????????         |                     
            //   83c44c               | add                 esp, 0x4c
            //   8d4da0               | lea                 ecx, [ebp - 0x60]
            //   ff15????????         |                     

        $sequence_4 = { 898bb8200000 898bbc200000 57 8d83b81e0000 50 ffd6 6810140001 }
            // n = 7, score = 100
            //   898bb8200000         | mov                 dword ptr [ebx + 0x20b8], ecx
            //   898bbc200000         | mov                 dword ptr [ebx + 0x20bc], ecx
            //   57                   | push                edi
            //   8d83b81e0000         | lea                 eax, [ebx + 0x1eb8]
            //   50                   | push                eax
            //   ffd6                 | call                esi
            //   6810140001           | push                0x1001410

        $sequence_5 = { 3d05000780 0f858c000000 837d2001 0f85e3000000 8d4de4 e8???????? 85c0 }
            // n = 7, score = 100
            //   3d05000780           | cmp                 eax, 0x80070005
            //   0f858c000000         | jne                 0x92
            //   837d2001             | cmp                 dword ptr [ebp + 0x20], 1
            //   0f85e3000000         | jne                 0xe9
            //   8d4de4               | lea                 ecx, [ebp - 0x1c]
            //   e8????????           |                     
            //   85c0                 | test                eax, eax

        $sequence_6 = { e8???????? 8bf8 897dd4 85ff 747f 6a00 53 }
            // n = 7, score = 100
            //   e8????????           |                     
            //   8bf8                 | mov                 edi, eax
            //   897dd4               | mov                 dword ptr [ebp - 0x2c], edi
            //   85ff                 | test                edi, edi
            //   747f                 | je                  0x81
            //   6a00                 | push                0
            //   53                   | push                ebx

        $sequence_7 = { 64a100000000 50 64892500000000 81ec04030000 53 56 57 }
            // n = 7, score = 100
            //   64a100000000         | mov                 eax, dword ptr fs:[0]
            //   50                   | push                eax
            //   64892500000000       | mov                 dword ptr fs:[0], esp
            //   81ec04030000         | sub                 esp, 0x304
            //   53                   | push                ebx
            //   56                   | push                esi
            //   57                   | push                edi

        $sequence_8 = { eb03 33f6 46 ff75c0 ff15???????? 59 8bc6 }
            // n = 7, score = 100
            //   eb03                 | jmp                 5
            //   33f6                 | xor                 esi, esi
            //   46                   | inc                 esi
            //   ff75c0               | push                dword ptr [ebp - 0x40]
            //   ff15????????         |                     
            //   59                   | pop                 ecx
            //   8bc6                 | mov                 eax, esi

        $sequence_9 = { 33c0 e9???????? 53 56 ff7508 8d85ecfdffff 50 }
            // n = 7, score = 100
            //   33c0                 | xor                 eax, eax
            //   e9????????           |                     
            //   53                   | push                ebx
            //   56                   | push                esi
            //   ff7508               | push                dword ptr [ebp + 8]
            //   8d85ecfdffff         | lea                 eax, [ebp - 0x214]
            //   50                   | push                eax

    condition:
        7 of them and filesize < 1998848
}