rule win_unidentified_037_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.unidentified_037."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.unidentified_037"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { fec8 8801 eb09 51 e8???????? 83c404 899ef4000000 }
            // n = 7, score = 100
            //   fec8                 | dec                 al
            //   8801                 | mov                 byte ptr [ecx], al
            //   eb09                 | jmp                 0xb
            //   51                   | push                ecx
            //   e8????????           |                     
            //   83c404               | add                 esp, 4
            //   899ef4000000         | mov                 dword ptr [esi + 0xf4], ebx

        $sequence_1 = { eb63 a802 7462 68???????? eb58 663d0900 7524 }
            // n = 7, score = 100
            //   eb63                 | jmp                 0x65
            //   a802                 | test                al, 2
            //   7462                 | je                  0x64
            //   68????????           |                     
            //   eb58                 | jmp                 0x5a
            //   663d0900             | cmp                 ax, 9
            //   7524                 | jne                 0x26

        $sequence_2 = { b9ff010000 33c0 8dbc242e080000 f3ab 66ab 8d44242c 50 }
            // n = 7, score = 100
            //   b9ff010000           | mov                 ecx, 0x1ff
            //   33c0                 | xor                 eax, eax
            //   8dbc242e080000       | lea                 edi, [esp + 0x82e]
            //   f3ab                 | rep stosd           dword ptr es:[edi], eax
            //   66ab                 | stosw               word ptr es:[edi], ax
            //   8d44242c             | lea                 eax, [esp + 0x2c]
            //   50                   | push                eax

        $sequence_3 = { 8b35???????? 3bf5 0f8439010000 8b0d???????? b8c12787cb 2bce f7e9 }
            // n = 7, score = 100
            //   8b35????????         |                     
            //   3bf5                 | cmp                 esi, ebp
            //   0f8439010000         | je                  0x13f
            //   8b0d????????         |                     
            //   b8c12787cb           | mov                 eax, 0xcb8727c1
            //   2bce                 | sub                 ecx, esi
            //   f7e9                 | imul                ecx

        $sequence_4 = { e8???????? 68???????? 68???????? 6802000080 e8???????? e8???????? a1???????? }
            // n = 7, score = 100
            //   e8????????           |                     
            //   68????????           |                     
            //   68????????           |                     
            //   6802000080           | push                0x80000002
            //   e8????????           |                     
            //   e8????????           |                     
            //   a1????????           |                     

        $sequence_5 = { 51 52 e8???????? 8d85cce0ffff 56 50 }
            // n = 6, score = 100
            //   51                   | push                ecx
            //   52                   | push                edx
            //   e8????????           |                     
            //   8d85cce0ffff         | lea                 eax, [ebp - 0x1f34]
            //   56                   | push                esi
            //   50                   | push                eax

        $sequence_6 = { 885e40 895c2418 884e44 895e48 895e4c 895e50 }
            // n = 6, score = 100
            //   885e40               | mov                 byte ptr [esi + 0x40], bl
            //   895c2418             | mov                 dword ptr [esp + 0x18], ebx
            //   884e44               | mov                 byte ptr [esi + 0x44], cl
            //   895e48               | mov                 dword ptr [esi + 0x48], ebx
            //   895e4c               | mov                 dword ptr [esi + 0x4c], ebx
            //   895e50               | mov                 dword ptr [esi + 0x50], ebx

        $sequence_7 = { 897dcc 3bfe c645fc04 742f 68???????? 897704 c7470801000000 }
            // n = 7, score = 100
            //   897dcc               | mov                 dword ptr [ebp - 0x34], edi
            //   3bfe                 | cmp                 edi, esi
            //   c645fc04             | mov                 byte ptr [ebp - 4], 4
            //   742f                 | je                  0x31
            //   68????????           |                     
            //   897704               | mov                 dword ptr [edi + 4], esi
            //   c7470801000000       | mov                 dword ptr [edi + 8], 1

        $sequence_8 = { 51 ff15???????? 8d94241c020000 6a00 }
            // n = 4, score = 100
            //   51                   | push                ecx
            //   ff15????????         |                     
            //   8d94241c020000       | lea                 edx, [esp + 0x21c]
            //   6a00                 | push                0

        $sequence_9 = { ff15???????? 56 bf01000000 ff15???????? 56 ff15???????? 8bc7 }
            // n = 7, score = 100
            //   ff15????????         |                     
            //   56                   | push                esi
            //   bf01000000           | mov                 edi, 1
            //   ff15????????         |                     
            //   56                   | push                esi
            //   ff15????????         |                     
            //   8bc7                 | mov                 eax, edi

    condition:
        7 of them and filesize < 167936
}