rule win_unidentified_041_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.unidentified_041."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.unidentified_041"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 8913 8b4dfc 8bc3 5f 5e 33cd 5b }
            // n = 7, score = 200
            //   8913                 | mov                 dword ptr [ebx], edx
            //   8b4dfc               | mov                 ecx, dword ptr [ebp - 4]
            //   8bc3                 | mov                 eax, ebx
            //   5f                   | pop                 edi
            //   5e                   | pop                 esi
            //   33cd                 | xor                 ecx, ebp
            //   5b                   | pop                 ebx

        $sequence_1 = { 668945be 59 668b440dbc 6603440ddc 6689440dbe 83c102 83f91e }
            // n = 7, score = 200
            //   668945be             | mov                 word ptr [ebp - 0x42], ax
            //   59                   | pop                 ecx
            //   668b440dbc           | mov                 ax, word ptr [ebp + ecx - 0x44]
            //   6603440ddc           | add                 ax, word ptr [ebp + ecx - 0x24]
            //   6689440dbe           | mov                 word ptr [ebp + ecx - 0x42], ax
            //   83c102               | add                 ecx, 2
            //   83f91e               | cmp                 ecx, 0x1e

        $sequence_2 = { ff7508 57 53 ff15???????? 83f8ff 74c4 eb03 }
            // n = 7, score = 200
            //   ff7508               | push                dword ptr [ebp + 8]
            //   57                   | push                edi
            //   53                   | push                ebx
            //   ff15????????         |                     
            //   83f8ff               | cmp                 eax, -1
            //   74c4                 | je                  0xffffffc6
            //   eb03                 | jmp                 5

        $sequence_3 = { 5d c20800 8325????????00 c3 55 8bec 8b4508 }
            // n = 7, score = 200
            //   5d                   | pop                 ebp
            //   c20800               | ret                 8
            //   8325????????00       |                     
            //   c3                   | ret                 
            //   55                   | push                ebp
            //   8bec                 | mov                 ebp, esp
            //   8b4508               | mov                 eax, dword ptr [ebp + 8]

        $sequence_4 = { 85ff 7428 3bf9 741c 8b75f8 8bd9 6a00 }
            // n = 7, score = 200
            //   85ff                 | test                edi, edi
            //   7428                 | je                  0x2a
            //   3bf9                 | cmp                 edi, ecx
            //   741c                 | je                  0x1e
            //   8b75f8               | mov                 esi, dword ptr [ebp - 8]
            //   8bd9                 | mov                 ebx, ecx
            //   6a00                 | push                0

        $sequence_5 = { 8d4dc4 c645fc00 e8???????? 8b4dec 6a18 58 03c8 }
            // n = 7, score = 200
            //   8d4dc4               | lea                 ecx, [ebp - 0x3c]
            //   c645fc00             | mov                 byte ptr [ebp - 4], 0
            //   e8????????           |                     
            //   8b4dec               | mov                 ecx, dword ptr [ebp - 0x14]
            //   6a18                 | push                0x18
            //   58                   | pop                 eax
            //   03c8                 | add                 ecx, eax

        $sequence_6 = { ff7508 68???????? 6a40 50 e8???????? 83c414 8d8578ffffff }
            // n = 7, score = 200
            //   ff7508               | push                dword ptr [ebp + 8]
            //   68????????           |                     
            //   6a40                 | push                0x40
            //   50                   | push                eax
            //   e8????????           |                     
            //   83c414               | add                 esp, 0x14
            //   8d8578ffffff         | lea                 eax, [ebp - 0x88]

        $sequence_7 = { 57 33db 53 ff15???????? 85c0 7552 ff15???????? }
            // n = 7, score = 200
            //   57                   | push                edi
            //   33db                 | xor                 ebx, ebx
            //   53                   | push                ebx
            //   ff15????????         |                     
            //   85c0                 | test                eax, eax
            //   7552                 | jne                 0x54
            //   ff15????????         |                     

        $sequence_8 = { 72ee 81fbffffff7f 76e6 57 53 8d4dc0 e8???????? }
            // n = 7, score = 200
            //   72ee                 | jb                  0xfffffff0
            //   81fbffffff7f         | cmp                 ebx, 0x7fffffff
            //   76e6                 | jbe                 0xffffffe8
            //   57                   | push                edi
            //   53                   | push                ebx
            //   8d4dc0               | lea                 ecx, [ebp - 0x40]
            //   e8????????           |                     

        $sequence_9 = { 5d c20400 6a1c b8???????? e8???????? 8bf1 33db }
            // n = 7, score = 200
            //   5d                   | pop                 ebp
            //   c20400               | ret                 4
            //   6a1c                 | push                0x1c
            //   b8????????           |                     
            //   e8????????           |                     
            //   8bf1                 | mov                 esi, ecx
            //   33db                 | xor                 ebx, ebx

    condition:
        7 of them and filesize < 1097728
}