rule win_unidentified_042_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.unidentified_042."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.unidentified_042"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 56 8bf0 8b4508 8b00 57 8bf9 c70600000000 }
            // n = 7, score = 100
            //   56                   | push                esi
            //   8bf0                 | mov                 esi, eax
            //   8b4508               | mov                 eax, dword ptr [ebp + 8]
            //   8b00                 | mov                 eax, dword ptr [eax]
            //   57                   | push                edi
            //   8bf9                 | mov                 edi, ecx
            //   c70600000000         | mov                 dword ptr [esi], 0

        $sequence_1 = { 53 8bd8 56 b800200000 33f6 66858350020000 7410 }
            // n = 7, score = 100
            //   53                   | push                ebx
            //   8bd8                 | mov                 ebx, eax
            //   56                   | push                esi
            //   b800200000           | mov                 eax, 0x2000
            //   33f6                 | xor                 esi, esi
            //   66858350020000       | test                word ptr [ebx + 0x250], ax
            //   7410                 | je                  0x12

        $sequence_2 = { 8a1430 40 8855ff 33d2 8d7801 33c9 8955f4 }
            // n = 7, score = 100
            //   8a1430               | mov                 dl, byte ptr [eax + esi]
            //   40                   | inc                 eax
            //   8855ff               | mov                 byte ptr [ebp - 1], dl
            //   33d2                 | xor                 edx, edx
            //   8d7801               | lea                 edi, [eax + 1]
            //   33c9                 | xor                 ecx, ecx
            //   8955f4               | mov                 dword ptr [ebp - 0xc], edx

        $sequence_3 = { 66858f50020000 0f8532ffffff c60616 8a977e010000 885601 8a877f010000 884602 }
            // n = 7, score = 100
            //   66858f50020000       | test                word ptr [edi + 0x250], cx
            //   0f8532ffffff         | jne                 0xffffff38
            //   c60616               | mov                 byte ptr [esi], 0x16
            //   8a977e010000         | mov                 dl, byte ptr [edi + 0x17e]
            //   885601               | mov                 byte ptr [esi + 1], dl
            //   8a877f010000         | mov                 al, byte ptr [edi + 0x17f]
            //   884602               | mov                 byte ptr [esi + 2], al

        $sequence_4 = { 53 56 8bf0 a1???????? 33db 57 895df8 }
            // n = 7, score = 100
            //   53                   | push                ebx
            //   56                   | push                esi
            //   8bf0                 | mov                 esi, eax
            //   a1????????           |                     
            //   33db                 | xor                 ebx, ebx
            //   57                   | push                edi
            //   895df8               | mov                 dword ptr [ebp - 8], ebx

        $sequence_5 = { 895df4 8d75e8 e8???????? 8bc7 5f 5e }
            // n = 6, score = 100
            //   895df4               | mov                 dword ptr [ebp - 0xc], ebx
            //   8d75e8               | lea                 esi, [ebp - 0x18]
            //   e8????????           |                     
            //   8bc7                 | mov                 eax, edi
            //   5f                   | pop                 edi
            //   5e                   | pop                 esi

        $sequence_6 = { 57 ffd6 a3???????? 85c0 0f8489020000 8d95d7fcffff 52 }
            // n = 7, score = 100
            //   57                   | push                edi
            //   ffd6                 | call                esi
            //   a3????????           |                     
            //   85c0                 | test                eax, eax
            //   0f8489020000         | je                  0x28f
            //   8d95d7fcffff         | lea                 edx, [ebp - 0x329]
            //   52                   | push                edx

        $sequence_7 = { c78518f9ffff356c656e c7851cf9ffff636a5a44 c78520f9ffff49577a32 c78524f9ffff59725a56 c78528f9ffff4362620d c7852cf9ffff0a626671 c78530f9ffff73752f38 }
            // n = 7, score = 100
            //   c78518f9ffff356c656e     | mov    dword ptr [ebp - 0x6e8], 0x6e656c35
            //   c7851cf9ffff636a5a44     | mov    dword ptr [ebp - 0x6e4], 0x445a6a63
            //   c78520f9ffff49577a32     | mov    dword ptr [ebp - 0x6e0], 0x327a5749
            //   c78524f9ffff59725a56     | mov    dword ptr [ebp - 0x6dc], 0x565a7259
            //   c78528f9ffff4362620d     | mov    dword ptr [ebp - 0x6d8], 0xd626243
            //   c7852cf9ffff0a626671     | mov    dword ptr [ebp - 0x6d4], 0x7166620a
            //   c78530f9ffff73752f38     | mov    dword ptr [ebp - 0x6d0], 0x382f7573

        $sequence_8 = { 0175f0 c1cf02 89b5ccfeffff 89bdd4feffff 8bfa }
            // n = 5, score = 100
            //   0175f0               | add                 dword ptr [ebp - 0x10], esi
            //   c1cf02               | ror                 edi, 2
            //   89b5ccfeffff         | mov                 dword ptr [ebp - 0x134], esi
            //   89bdd4feffff         | mov                 dword ptr [ebp - 0x12c], edi
            //   8bfa                 | mov                 edi, edx

        $sequence_9 = { 88480a 66859350020000 7548 8b7b18 8d700b 6a41 8bce }
            // n = 7, score = 100
            //   88480a               | mov                 byte ptr [eax + 0xa], cl
            //   66859350020000       | test                word ptr [ebx + 0x250], dx
            //   7548                 | jne                 0x4a
            //   8b7b18               | mov                 edi, dword ptr [ebx + 0x18]
            //   8d700b               | lea                 esi, [eax + 0xb]
            //   6a41                 | push                0x41
            //   8bce                 | mov                 ecx, esi

    condition:
        7 of them and filesize < 516096
}