rule win_unidentified_044_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.unidentified_044."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.unidentified_044"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { ffd6 a1???????? 85c0 75e2 5e c3 a1???????? }
            // n = 7, score = 100
            //   ffd6                 | call                esi
            //   a1????????           |                     
            //   85c0                 | test                eax, eax
            //   75e2                 | jne                 0xffffffe4
            //   5e                   | pop                 esi
            //   c3                   | ret                 
            //   a1????????           |                     

        $sequence_1 = { 660bfb 66897c0102 8b4c2410 49 894c2410 85c9 }
            // n = 6, score = 100
            //   660bfb               | or                  di, bx
            //   66897c0102           | mov                 word ptr [ecx + eax + 2], di
            //   8b4c2410             | mov                 ecx, dword ptr [esp + 0x10]
            //   49                   | dec                 ecx
            //   894c2410             | mov                 dword ptr [esp + 0x10], ecx
            //   85c9                 | test                ecx, ecx

        $sequence_2 = { 8d8570feffff 50 6802020000 891d???????? }
            // n = 4, score = 100
            //   8d8570feffff         | lea                 eax, [ebp - 0x190]
            //   50                   | push                eax
            //   6802020000           | push                0x202
            //   891d????????         |                     

        $sequence_3 = { 83f801 0f85fd000000 8b542418 8d4c2424 }
            // n = 4, score = 100
            //   83f801               | cmp                 eax, 1
            //   0f85fd000000         | jne                 0x103
            //   8b542418             | mov                 edx, dword ptr [esp + 0x18]
            //   8d4c2424             | lea                 ecx, [esp + 0x24]

        $sequence_4 = { 803d????????00 5f 740d 8b0d???????? 51 }
            // n = 5, score = 100
            //   803d????????00       |                     
            //   5f                   | pop                 edi
            //   740d                 | je                  0xf
            //   8b0d????????         |                     
            //   51                   | push                ecx

        $sequence_5 = { 8b442414 52 50 55 83c8ff }
            // n = 5, score = 100
            //   8b442414             | mov                 eax, dword ptr [esp + 0x14]
            //   52                   | push                edx
            //   50                   | push                eax
            //   55                   | push                ebp
            //   83c8ff               | or                  eax, 0xffffffff

        $sequence_6 = { a3???????? 7e0d 6a00 68???????? ff15???????? }
            // n = 5, score = 100
            //   a3????????           |                     
            //   7e0d                 | jle                 0xf
            //   6a00                 | push                0
            //   68????????           |                     
            //   ff15????????         |                     

        $sequence_7 = { 50 ffd7 85c0 7544 8b2d???????? 8b1d???????? 90 }
            // n = 7, score = 100
            //   50                   | push                eax
            //   ffd7                 | call                edi
            //   85c0                 | test                eax, eax
            //   7544                 | jne                 0x46
            //   8b2d????????         |                     
            //   8b1d????????         |                     
            //   90                   | nop                 

        $sequence_8 = { 66c1c208 50 6689542426 ff15???????? 8bf8 83ffff }
            // n = 6, score = 100
            //   66c1c208             | rol                 dx, 8
            //   50                   | push                eax
            //   6689542426           | mov                 word ptr [esp + 0x26], dx
            //   ff15????????         |                     
            //   8bf8                 | mov                 edi, eax
            //   83ffff               | cmp                 edi, -1

        $sequence_9 = { 55 e8???????? 83c40c 84c0 74a0 8a442413 }
            // n = 6, score = 100
            //   55                   | push                ebp
            //   e8????????           |                     
            //   83c40c               | add                 esp, 0xc
            //   84c0                 | test                al, al
            //   74a0                 | je                  0xffffffa2
            //   8a442413             | mov                 al, byte ptr [esp + 0x13]

    condition:
        7 of them and filesize < 90112
}