rule win_unidentified_047_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2020-10-14"
        version = "1"
        description = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.5.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.unidentified_047"
        malpedia_rule_date = "20201014"
        malpedia_hash = "a7e3bd57eaf12bf3ea29a863c041091ba3af9ac9"
        malpedia_version = "20201014"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 40 0086b3450089 c3 b8???????? 8b5304 }
            // n = 5, score = 100
            //   40                   | inc                 eax
            //   0086b3450089         | add                 byte ptr [esi - 0x76ffba4d], al
            //   c3                   | ret                 
            //   b8????????           |                     
            //   8b5304               | mov                 edx, dword ptr [ebx + 4]

        $sequence_1 = { ff570c 8b4b30 8b55b0 e8???????? }
            // n = 4, score = 100
            //   ff570c               | call                dword ptr [edi + 0xc]
            //   8b4b30               | mov                 ecx, dword ptr [ebx + 0x30]
            //   8b55b0               | mov                 edx, dword ptr [ebp - 0x50]
            //   e8????????           |                     

        $sequence_2 = { b8???????? e8???????? 8d4dc8 8b15???????? 8bc3 e8???????? }
            // n = 6, score = 100
            //   b8????????           |                     
            //   e8????????           |                     
            //   8d4dc8               | lea                 ecx, [ebp - 0x38]
            //   8b15????????         |                     
            //   8bc3                 | mov                 eax, ebx
            //   e8????????           |                     

        $sequence_3 = { 68???????? e8???????? a3???????? c705????????10664200 c705????????28674200 c705????????98664200 }
            // n = 6, score = 100
            //   68????????           |                     
            //   e8????????           |                     
            //   a3????????           |                     
            //   c705????????10664200     |     
            //   c705????????28674200     |     
            //   c705????????98664200     |     

        $sequence_4 = { e8???????? 8bc3 8b10 ff5204 8b45fc }
            // n = 5, score = 100
            //   e8????????           |                     
            //   8bc3                 | mov                 eax, ebx
            //   8b10                 | mov                 edx, dword ptr [eax]
            //   ff5204               | call                dword ptr [edx + 4]
            //   8b45fc               | mov                 eax, dword ptr [ebp - 4]

        $sequence_5 = { e8???????? 6a00 6a08 8b45e8 8b55ec }
            // n = 5, score = 100
            //   e8????????           |                     
            //   6a00                 | push                0
            //   6a08                 | push                8
            //   8b45e8               | mov                 eax, dword ptr [ebp - 0x18]
            //   8b55ec               | mov                 edx, dword ptr [ebp - 0x14]

        $sequence_6 = { 891424 8b2d???????? 8b0424 89442404 8bc6 b920000000 33d2 }
            // n = 7, score = 100
            //   891424               | mov                 dword ptr [esp], edx
            //   8b2d????????         |                     
            //   8b0424               | mov                 eax, dword ptr [esp]
            //   89442404             | mov                 dword ptr [esp + 4], eax
            //   8bc6                 | mov                 eax, esi
            //   b920000000           | mov                 ecx, 0x20
            //   33d2                 | xor                 edx, edx

        $sequence_7 = { 50 0fb745f0 8b0485d8064600 e8???????? }
            // n = 4, score = 100
            //   50                   | push                eax
            //   0fb745f0             | movzx               eax, word ptr [ebp - 0x10]
            //   8b0485d8064600       | mov                 eax, dword ptr [eax*4 + 0x4606d8]
            //   e8????????           |                     

        $sequence_8 = { 1353fc 33d2 8b5d0c 8943f8 8953fc 8bc1 33d2 }
            // n = 7, score = 100
            //   1353fc               | adc                 edx, dword ptr [ebx - 4]
            //   33d2                 | xor                 edx, edx
            //   8b5d0c               | mov                 ebx, dword ptr [ebp + 0xc]
            //   8943f8               | mov                 dword ptr [ebx - 8], eax
            //   8953fc               | mov                 dword ptr [ebx - 4], edx
            //   8bc1                 | mov                 eax, ecx
            //   33d2                 | xor                 edx, edx

        $sequence_9 = { 8b55b4 8bc6 8b18 ff5310 8b4dd8 }
            // n = 5, score = 100
            //   8b55b4               | mov                 edx, dword ptr [ebp - 0x4c]
            //   8bc6                 | mov                 eax, esi
            //   8b18                 | mov                 ebx, dword ptr [eax]
            //   ff5310               | call                dword ptr [ebx + 0x10]
            //   8b4dd8               | mov                 ecx, dword ptr [ebp - 0x28]

    condition:
        7 of them and filesize < 950272
}