rule win_unidentified_068_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.unidentified_068."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.unidentified_068"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 8d3403 8bd6 c1fa06 8bce 83e13f 6bc930 8b049518c94500 }
            // n = 7, score = 100
            //   8d3403               | lea                 esi, [ebx + eax]
            //   8bd6                 | mov                 edx, esi
            //   c1fa06               | sar                 edx, 6
            //   8bce                 | mov                 ecx, esi
            //   83e13f               | and                 ecx, 0x3f
            //   6bc930               | imul                ecx, ecx, 0x30
            //   8b049518c94500       | mov                 eax, dword ptr [edx*4 + 0x45c918]

        $sequence_1 = { 51 ff5008 ffb56cffffff e8???????? 59 8d8d2cffffff e8???????? }
            // n = 7, score = 100
            //   51                   | push                ecx
            //   ff5008               | call                dword ptr [eax + 8]
            //   ffb56cffffff         | push                dword ptr [ebp - 0x94]
            //   e8????????           |                     
            //   59                   | pop                 ecx
            //   8d8d2cffffff         | lea                 ecx, [ebp - 0xd4]
            //   e8????????           |                     

        $sequence_2 = { 894dfc 57 8bd1 33ff 53 8d8dfcfeffff e8???????? }
            // n = 7, score = 100
            //   894dfc               | mov                 dword ptr [ebp - 4], ecx
            //   57                   | push                edi
            //   8bd1                 | mov                 edx, ecx
            //   33ff                 | xor                 edi, edi
            //   53                   | push                ebx
            //   8d8dfcfeffff         | lea                 ecx, [ebp - 0x104]
            //   e8????????           |                     

        $sequence_3 = { 897de8 8945d8 8b458c 2b8564ffffff 8945dc 6a08 e8???????? }
            // n = 7, score = 100
            //   897de8               | mov                 dword ptr [ebp - 0x18], edi
            //   8945d8               | mov                 dword ptr [ebp - 0x28], eax
            //   8b458c               | mov                 eax, dword ptr [ebp - 0x74]
            //   2b8564ffffff         | sub                 eax, dword ptr [ebp - 0x9c]
            //   8945dc               | mov                 dword ptr [ebp - 0x24], eax
            //   6a08                 | push                8
            //   e8????????           |                     

        $sequence_4 = { 85c9 7904 33c0 5d c3 ff7510 }
            // n = 6, score = 100
            //   85c9                 | test                ecx, ecx
            //   7904                 | jns                 6
            //   33c0                 | xor                 eax, eax
            //   5d                   | pop                 ebp
            //   c3                   | ret                 
            //   ff7510               | push                dword ptr [ebp + 0x10]

        $sequence_5 = { 0fafc1 3bf0 7314 8bf8 b800080000 2bc1 c1e805 }
            // n = 7, score = 100
            //   0fafc1               | imul                eax, ecx
            //   3bf0                 | cmp                 esi, eax
            //   7314                 | jae                 0x16
            //   8bf8                 | mov                 edi, eax
            //   b800080000           | mov                 eax, 0x800
            //   2bc1                 | sub                 eax, ecx
            //   c1e805               | shr                 eax, 5

        $sequence_6 = { 83bf304b000002 744d 8b4d1c 85c9 7422 8b473c 2b4744 }
            // n = 7, score = 100
            //   83bf304b000002       | cmp                 dword ptr [edi + 0x4b30], 2
            //   744d                 | je                  0x4f
            //   8b4d1c               | mov                 ecx, dword ptr [ebp + 0x1c]
            //   85c9                 | test                ecx, ecx
            //   7422                 | je                  0x24
            //   8b473c               | mov                 eax, dword ptr [edi + 0x3c]
            //   2b4744               | sub                 eax, dword ptr [edi + 0x44]

        $sequence_7 = { e8???????? 6a10 83faff 8d4f28 58 0f45c2 }
            // n = 6, score = 100
            //   e8????????           |                     
            //   6a10                 | push                0x10
            //   83faff               | cmp                 edx, -1
            //   8d4f28               | lea                 ecx, [edi + 0x28]
            //   58                   | pop                 eax
            //   0f45c2               | cmovne              eax, edx

        $sequence_8 = { b800080000 2bc2 c1e805 03c2 66894312 6a02 eb14 }
            // n = 7, score = 100
            //   b800080000           | mov                 eax, 0x800
            //   2bc2                 | sub                 eax, edx
            //   c1e805               | shr                 eax, 5
            //   03c2                 | add                 eax, edx
            //   66894312             | mov                 word ptr [ebx + 0x12], ax
            //   6a02                 | push                2
            //   eb14                 | jmp                 0x16

        $sequence_9 = { 6a2a 8d4dcc e8???????? 57 ff75cc 8d4dec e8???????? }
            // n = 7, score = 100
            //   6a2a                 | push                0x2a
            //   8d4dcc               | lea                 ecx, [ebp - 0x34]
            //   e8????????           |                     
            //   57                   | push                edi
            //   ff75cc               | push                dword ptr [ebp - 0x34]
            //   8d4dec               | lea                 ecx, [ebp - 0x14]
            //   e8????????           |                     

    condition:
        7 of them and filesize < 862208
}