rule win_unidentified_074_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.unidentified_074."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.unidentified_074"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 8b4d0c 3bf1 752a 8b4614 83f808 7204 }
            // n = 6, score = 200
            //   8b4d0c               | mov                 ecx, dword ptr [ebp + 0xc]
            //   3bf1                 | cmp                 esi, ecx
            //   752a                 | jne                 0x2c
            //   8b4614               | mov                 eax, dword ptr [esi + 0x14]
            //   83f808               | cmp                 eax, 8
            //   7204                 | jb                  6

        $sequence_1 = { 83f808 720d 40 50 ffb528e7ffff e8???????? }
            // n = 6, score = 200
            //   83f808               | cmp                 eax, 8
            //   720d                 | jb                  0xf
            //   40                   | inc                 eax
            //   50                   | push                eax
            //   ffb528e7ffff         | push                dword ptr [ebp - 0x18d8]
            //   e8????????           |                     

        $sequence_2 = { 8d8528e7ffff 50 8d8570e7ffff 50 8d85f8e6ffff 50 }
            // n = 6, score = 200
            //   8d8528e7ffff         | lea                 eax, [ebp - 0x18d8]
            //   50                   | push                eax
            //   8d8570e7ffff         | lea                 eax, [ebp - 0x1890]
            //   50                   | push                eax
            //   8d85f8e6ffff         | lea                 eax, [ebp - 0x1908]
            //   50                   | push                eax

        $sequence_3 = { 75f3 8bcf e8???????? 3bd0 }
            // n = 4, score = 200
            //   75f3                 | jne                 0xfffffff5
            //   8bcf                 | mov                 ecx, edi
            //   e8????????           |                     
            //   3bd0                 | cmp                 edx, eax

        $sequence_4 = { 8855ee 660f1f440000 0fb64435ec 50 51 }
            // n = 5, score = 200
            //   8855ee               | mov                 byte ptr [ebp - 0x12], dl
            //   660f1f440000         | nop                 word ptr [eax + eax]
            //   0fb64435ec           | movzx               eax, byte ptr [ebp + esi - 0x14]
            //   50                   | push                eax
            //   51                   | push                ecx

        $sequence_5 = { 33d2 8b4f10 33f6 c740140f000000 83781410 894ddc 8955e0 }
            // n = 7, score = 200
            //   33d2                 | xor                 edx, edx
            //   8b4f10               | mov                 ecx, dword ptr [edi + 0x10]
            //   33f6                 | xor                 esi, esi
            //   c740140f000000       | mov                 dword ptr [eax + 0x14], 0xf
            //   83781410             | cmp                 dword ptr [eax + 0x14], 0x10
            //   894ddc               | mov                 dword ptr [ebp - 0x24], ecx
            //   8955e0               | mov                 dword ptr [ebp - 0x20], edx

        $sequence_6 = { 6800040000 8985f8f7ffff 8901 8d85fcfbffff }
            // n = 4, score = 200
            //   6800040000           | push                0x400
            //   8985f8f7ffff         | mov                 dword ptr [ebp - 0x808], eax
            //   8901                 | mov                 dword ptr [ecx], eax
            //   8d85fcfbffff         | lea                 eax, [ebp - 0x404]

        $sequence_7 = { 8b85e0f7ffff 85c0 7407 50 ff15???????? 85ff }
            // n = 6, score = 200
            //   8b85e0f7ffff         | mov                 eax, dword ptr [ebp - 0x820]
            //   85c0                 | test                eax, eax
            //   7407                 | je                  9
            //   50                   | push                eax
            //   ff15????????         |                     
            //   85ff                 | test                edi, edi

        $sequence_8 = { 8d4618 7202 8b00 837e1410 7202 8b36 6a00 }
            // n = 7, score = 200
            //   8d4618               | lea                 eax, [esi + 0x18]
            //   7202                 | jb                  4
            //   8b00                 | mov                 eax, dword ptr [eax]
            //   837e1410             | cmp                 dword ptr [esi + 0x14], 0x10
            //   7202                 | jb                  4
            //   8b36                 | mov                 esi, dword ptr [esi]
            //   6a00                 | push                0

        $sequence_9 = { 8b853ce7ffff 83f808 720d 40 50 ffb528e7ffff }
            // n = 6, score = 200
            //   8b853ce7ffff         | mov                 eax, dword ptr [ebp - 0x18c4]
            //   83f808               | cmp                 eax, 8
            //   720d                 | jb                  0xf
            //   40                   | inc                 eax
            //   50                   | push                eax
            //   ffb528e7ffff         | push                dword ptr [ebp - 0x18d8]

    condition:
        7 of them and filesize < 335872
}