rule win_unidentified_076_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.unidentified_076."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.unidentified_076"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 0f95c3 488b6c2438 488b742440 488b7c2448 8bc3 488b5c2430 4883c420 }
            // n = 7, score = 100
            //   0f95c3               | mov                 ecx, ebx
            //   488b6c2438           | xor                 edx, edx
            //   488b742440           | xor                 ecx, ecx
            //   488b7c2448           | call                dword ptr [eax + 0x1c0]
            //   8bc3                 | dec                 esp
            //   488b5c2430           | mov                 edx, dword ptr [edi + 0xc8]
            //   4883c420             | inc                 ecx

        $sequence_1 = { 85c0 7f2d 488b86c8000000 33db ff9050010000 41b8fe010000 488bce }
            // n = 7, score = 100
            //   85c0                 | mov                 ecx, dword ptr [edx]
            //   7f2d                 | dec                 eax
            //   488b86c8000000       | mov                 eax, dword ptr [edx + 8]
            //   33db                 | dec                 eax
            //   ff9050010000         | mov                 dword ptr [ecx + 8], eax
            //   41b8fe010000         | mov                 eax, dword ptr [ebx + 0x4c]
            //   488bce               | mov                 ecx, 0x1b58

        $sequence_2 = { 4155 4156 4881ec20010000 488b81c8000000 488bd9 488bf2 488d4c2440 }
            // n = 7, score = 100
            //   4155                 | sub                 eax, edi
            //   4156                 | dec                 eax
            //   4881ec20010000       | mov                 dword ptr [ebp + 0x390], eax
            //   488b81c8000000       | dec                 eax
            //   488bd9               | lea                 eax, [0x4eef]
            //   488bf2               | dec                 eax
            //   488d4c2440           | sub                 eax, edi

        $sequence_3 = { 498bcc ff9020070000 488b8e50020000 488b96c8000000 4963c6 4869d814030000 }
            // n = 6, score = 100
            //   498bcc               | dec                 eax
            //   ff9020070000         | mov                 eax, dword ptr [ebx + 0xc8]
            //   488b8e50020000       | dec                 eax
            //   488b96c8000000       | mov                 edx, dword ptr [ebx + 0x260]
            //   4963c6               | dec                 eax
            //   4869d814030000       | lea                 ecx, [ebx + 0x65c]

        $sequence_4 = { 03d0 41ffc9 75f0 443bda 0f8524010000 44895f30 896f34 }
            // n = 7, score = 100
            //   03d0                 | dec                 eax
            //   41ffc9               | mov                 ecx, esi
            //   75f0                 | inc                 esp
            //   443bda               | mov                 dword ptr [ebp + 0x84], ebp
            //   0f8524010000         | inc                 ecx
            //   44895f30             | mov                 ebx, esp
            //   896f34               | mov                 byte ptr [ebp + 0x8c], al

        $sequence_5 = { 41b900008000 ba0e660000 4c89742420 ff9080050000 85c0 7522 488b87c8000000 }
            // n = 7, score = 100
            //   41b900008000         | mov                 eax, dword ptr [edi + 0x90]
            //   ba0e660000           | dec                 ecx
            //   4c89742420           | mov                 dword ptr [esp], ebx
            //   ff9080050000         | dec                 ecx
            //   85c0                 | lea                 edx, [esi + 0x40]
            //   7522                 | dec                 ecx
            //   488b87c8000000       | mov                 dword ptr [esp + 8], eax

        $sequence_6 = { ffc1 448bf2 483bc8 0f86b2000000 bf08000000 eb03 4803ff }
            // n = 7, score = 100
            //   ffc1                 | mov                 byte ptr [edx + edi + 3], 0x6c
            //   448bf2               | dec                 ecx
            //   483bc8               | cmp                 edx, edx
            //   0f86b2000000         | jge                 0x506
            //   bf08000000           | je                  0x76f
            //   eb03                 | dec                 eax
            //   4803ff               | cmp                 dword ptr [esp + 0x38], ecx

        $sequence_7 = { 488b81c8000000 498bc8 ff9080000000 33c9 33d2 4c63c0 85c0 }
            // n = 7, score = 100
            //   488b81c8000000       | mov                 dword ptr [esp + 0x20], ebp
            //   498bc8               | dec                 eax
            //   ff9080000000         | lea                 eax, [0xffffe7d9]
            //   33c9                 | dec                 eax
            //   33d2                 | mov                 ecx, esi
            //   4c63c0               | inc                 esp
            //   85c0                 | lea                 eax, [edx + 0x7c]

        $sequence_8 = { 488bcb 448d4202 e8???????? 488b93c8000000 488d4df0 ff92f0070000 83a3c802000000 }
            // n = 7, score = 100
            //   488bcb               | lea                 ecx, [edx + 0x48]
            //   448d4202             | call                dword ptr [eax + 0x740]
            //   e8????????           |                     
            //   488b93c8000000       | dec                 eax
            //   488d4df0             | mov                 eax, dword ptr [ebx + 0x200]
            //   ff92f0070000         | dec                 esp
            //   83a3c802000000       | mov                 edx, dword ptr [ebx + 0xc8]

        $sequence_9 = { 0fb74603 440fb6c0 c1e808 41c1e008 440bc0 41833e00 44894530 }
            // n = 7, score = 100
            //   0fb74603             | dec                 eax
            //   440fb6c0             | test                eax, eax
            //   c1e808               | inc                 esp
            //   41c1e008             | mov                 ecx, esi
            //   440bc0               | inc                 esp
            //   41833e00             | mov                 eax, ebp
            //   44894530             | xor                 ecx, ecx

    condition:
        7 of them and filesize < 114688
}