rule win_unidentified_080_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.unidentified_080."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.unidentified_080"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 85f6 7431 8d460d 50 e8???????? 83c404 85c0 }
            // n = 7, score = 100
            //   85f6                 | test                esi, esi
            //   7431                 | je                  0x33
            //   8d460d               | lea                 eax, [esi + 0xd]
            //   50                   | push                eax
            //   e8????????           |                     
            //   83c404               | add                 esp, 4
            //   85c0                 | test                eax, eax

        $sequence_1 = { ff15???????? 68e8030000 ff15???????? 8b85e0fdffff 40 8985e0fdffff 83f80a }
            // n = 7, score = 100
            //   ff15????????         |                     
            //   68e8030000           | push                0x3e8
            //   ff15????????         |                     
            //   8b85e0fdffff         | mov                 eax, dword ptr [ebp - 0x220]
            //   40                   | inc                 eax
            //   8985e0fdffff         | mov                 dword ptr [ebp - 0x220], eax
            //   83f80a               | cmp                 eax, 0xa

        $sequence_2 = { 8b5004 8bce c745ec88310210 ffd2 33c0 }
            // n = 5, score = 100
            //   8b5004               | mov                 edx, dword ptr [eax + 4]
            //   8bce                 | mov                 ecx, esi
            //   c745ec88310210       | mov                 dword ptr [ebp - 0x14], 0x10023188
            //   ffd2                 | call                edx
            //   33c0                 | xor                 eax, eax

        $sequence_3 = { 899d8cfdffff 898504fdffff 899d88fdffff 899d90fdffff 899d94fdffff }
            // n = 5, score = 100
            //   899d8cfdffff         | mov                 dword ptr [ebp - 0x274], ebx
            //   898504fdffff         | mov                 dword ptr [ebp - 0x2fc], eax
            //   899d88fdffff         | mov                 dword ptr [ebp - 0x278], ebx
            //   899d90fdffff         | mov                 dword ptr [ebp - 0x270], ebx
            //   899d94fdffff         | mov                 dword ptr [ebp - 0x26c], ebx

        $sequence_4 = { 57 56 6a01 50 ff15???????? 85c0 }
            // n = 6, score = 100
            //   57                   | push                edi
            //   56                   | push                esi
            //   6a01                 | push                1
            //   50                   | push                eax
            //   ff15????????         |                     
            //   85c0                 | test                eax, eax

        $sequence_5 = { 741d 8b5508 8bf3 e8???????? 83c404 5f c7830050000000000000 }
            // n = 7, score = 100
            //   741d                 | je                  0x1f
            //   8b5508               | mov                 edx, dword ptr [ebp + 8]
            //   8bf3                 | mov                 esi, ebx
            //   e8????????           |                     
            //   83c404               | add                 esp, 4
            //   5f                   | pop                 edi
            //   c7830050000000000000     | mov    dword ptr [ebx + 0x5000], 0

        $sequence_6 = { 767d 03c7 3b44243c 763f 8b44243c 0500400000 50 }
            // n = 7, score = 100
            //   767d                 | jbe                 0x7f
            //   03c7                 | add                 eax, edi
            //   3b44243c             | cmp                 eax, dword ptr [esp + 0x3c]
            //   763f                 | jbe                 0x41
            //   8b44243c             | mov                 eax, dword ptr [esp + 0x3c]
            //   0500400000           | add                 eax, 0x4000
            //   50                   | push                eax

        $sequence_7 = { 894c2414 8b4760 8b5f6c 8b742414 }
            // n = 4, score = 100
            //   894c2414             | mov                 dword ptr [esp + 0x14], ecx
            //   8b4760               | mov                 eax, dword ptr [edi + 0x60]
            //   8b5f6c               | mov                 ebx, dword ptr [edi + 0x6c]
            //   8b742414             | mov                 esi, dword ptr [esp + 0x14]

        $sequence_8 = { 40 3bc7 72f6 eb2b 8d5001 8bcf 2bca }
            // n = 7, score = 100
            //   40                   | inc                 eax
            //   3bc7                 | cmp                 eax, edi
            //   72f6                 | jb                  0xfffffff8
            //   eb2b                 | jmp                 0x2d
            //   8d5001               | lea                 edx, [eax + 1]
            //   8bcf                 | mov                 ecx, edi
            //   2bca                 | sub                 ecx, edx

        $sequence_9 = { 8b5c2414 83c3f4 81fb???????? 7414 53 ff15???????? 85c0 }
            // n = 7, score = 100
            //   8b5c2414             | mov                 ebx, dword ptr [esp + 0x14]
            //   83c3f4               | add                 ebx, -0xc
            //   81fb????????         |                     
            //   7414                 | je                  0x16
            //   53                   | push                ebx
            //   ff15????????         |                     
            //   85c0                 | test                eax, eax

    condition:
        7 of them and filesize < 392192
}