rule win_unidentified_096_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.unidentified_096."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.unidentified_096"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { a2???????? 81e1ffff0000 5f 83c1f8 5e }
            // n = 5, score = 100
            //   a2????????           |                     
            //   81e1ffff0000         | and                 ecx, 0xffff
            //   5f                   | pop                 edi
            //   83c1f8               | add                 ecx, -8
            //   5e                   | pop                 esi

        $sequence_1 = { 52 e8???????? 83c418 c3 8b0d???????? 51 68???????? }
            // n = 7, score = 100
            //   52                   | push                edx
            //   e8????????           |                     
            //   83c418               | add                 esp, 0x18
            //   c3                   | ret                 
            //   8b0d????????         |                     
            //   51                   | push                ecx
            //   68????????           |                     

        $sequence_2 = { 55 6800000080 55 6800000080 }
            // n = 4, score = 100
            //   55                   | push                ebp
            //   6800000080           | push                0x80000000
            //   55                   | push                ebp
            //   6800000080           | push                0x80000000

        $sequence_3 = { 68ff000000 52 ff15???????? 5f 5e 33c0 }
            // n = 6, score = 100
            //   68ff000000           | push                0xff
            //   52                   | push                edx
            //   ff15????????         |                     
            //   5f                   | pop                 edi
            //   5e                   | pop                 esi
            //   33c0                 | xor                 eax, eax

        $sequence_4 = { 85c0 7505 5e 83c40c c3 6a0c }
            // n = 6, score = 100
            //   85c0                 | test                eax, eax
            //   7505                 | jne                 7
            //   5e                   | pop                 esi
            //   83c40c               | add                 esp, 0xc
            //   c3                   | ret                 
            //   6a0c                 | push                0xc

        $sequence_5 = { 83c03d eb3f 85ff 8ac1 7d04 }
            // n = 5, score = 100
            //   83c03d               | add                 eax, 0x3d
            //   eb3f                 | jmp                 0x41
            //   85ff                 | test                edi, edi
            //   8ac1                 | mov                 al, cl
            //   7d04                 | jge                 6

        $sequence_6 = { 85ff 7523 8b4c2420 8b54241c 8b442414 51 52 }
            // n = 7, score = 100
            //   85ff                 | test                edi, edi
            //   7523                 | jne                 0x25
            //   8b4c2420             | mov                 ecx, dword ptr [esp + 0x20]
            //   8b54241c             | mov                 edx, dword ptr [esp + 0x1c]
            //   8b442414             | mov                 eax, dword ptr [esp + 0x14]
            //   51                   | push                ecx
            //   52                   | push                edx

        $sequence_7 = { b024 a2???????? eb3b b025 a2???????? }
            // n = 5, score = 100
            //   b024                 | mov                 al, 0x24
            //   a2????????           |                     
            //   eb3b                 | jmp                 0x3d
            //   b025                 | mov                 al, 0x25
            //   a2????????           |                     

        $sequence_8 = { 7d04 0480 eb35 0470 eb31 }
            // n = 5, score = 100
            //   7d04                 | jge                 6
            //   0480                 | add                 al, 0x80
            //   eb35                 | jmp                 0x37
            //   0470                 | add                 al, 0x70
            //   eb31                 | jmp                 0x33

        $sequence_9 = { 8b400c 89410c e8???????? 83c410 56 e8???????? }
            // n = 6, score = 100
            //   8b400c               | mov                 eax, dword ptr [eax + 0xc]
            //   89410c               | mov                 dword ptr [ecx + 0xc], eax
            //   e8????????           |                     
            //   83c410               | add                 esp, 0x10
            //   56                   | push                esi
            //   e8????????           |                     

    condition:
        7 of them and filesize < 25648
}