rule win_unidentified_104_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.unidentified_104."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.unidentified_104"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 488b7910 488bd9 488bcf 4c8bf2 e8???????? ba20000000 498bce }
            // n = 7, score = 100
            //   488b7910             | dec                 eax
            //   488bd9               | mov                 ecx, dword ptr [ecx - 8]
            //   488bcf               | dec                 eax
            //   4c8bf2               | sub                 eax, ecx
            //   e8????????           |                     
            //   ba20000000           | dec                 eax
            //   498bce               | add                 eax, -8

        $sequence_1 = { 488bf9 498bd8 488d4c2420 e8???????? 41b804000000 488d4c2450 488bd3 }
            // n = 7, score = 100
            //   488bf9               | add                 eax, ecx
            //   498bd8               | dec                 esp
            //   488d4c2420           | add                 eax, eax
            //   e8????????           |                     
            //   41b804000000         | dec                 eax
            //   488d4c2450           | mov                 ecx, ebp
            //   488bd3               | dec                 eax

        $sequence_2 = { 48897e10 48897e18 0f1000 0f1106 0f104810 0f114e10 48897810 }
            // n = 7, score = 100
            //   48897e10             | mov                 dword ptr [esp + 0x20], ebx
            //   48897e18             | inc                 esp
            //   0f1000               | lea                 eax, [edx + 0x40]
            //   0f1106               | dec                 eax
            //   0f104810             | mov                 edx, dword ptr [esp + 0xd0]
            //   0f114e10             | dec                 esp
            //   48897810             | lea                 ecx, [esp + 0x30]

        $sequence_3 = { 8bda e8???????? 4885c0 750d e8???????? 33c0 4883c420 }
            // n = 7, score = 100
            //   8bda                 | mov                 esi, dword ptr [ebx + 0x28]
            //   e8????????           |                     
            //   4885c0               | dec                 ecx
            //   750d                 | mov                 edi, dword ptr [ebx + 0x30]
            //   e8????????           |                     
            //   33c0                 | dec                 ebp
            //   4883c420             | mov                 esp, dword ptr [ebx + 0x38]

        $sequence_4 = { 4c8bb42490000000 498b86a0000000 4803c1 4c03d8 4933d3 4c895c2408 4c8bda }
            // n = 7, score = 100
            //   4c8bb42490000000     | dec                 eax
            //   498b86a0000000       | mov                 edi, edx
            //   4803c1               | dec                 eax
            //   4c03d8               | shr                 edx, 0x10
            //   4933d3               | dec                 eax
            //   4c895c2408           | shl                 edi, 0x30
            //   4c8bda               | dec                 eax

        $sequence_5 = { 4933ca 4c8b942490000000 498b82a8000000 4803c1 4c03c0 4933d0 }
            // n = 6, score = 100
            //   4933ca               | mov                 eax, dword ptr [edi + 0xa0]
            //   4c8b942490000000     | dec                 eax
            //   498b82a8000000       | shl                 ecx, 0x28
            //   4803c1               | dec                 eax
            //   4c03c0               | xor                 ecx, edi
            //   4933d0               | dec                 eax

        $sequence_6 = { cc e8???????? 4d8d4601 488bd6 498bcf e8???????? 48891e }
            // n = 7, score = 100
            //   cc                   | movups              xmmword ptr [ebx + 0x10], xmm0
            //   e8????????           |                     
            //   4d8d4601             | mov                 dword ptr [esp], eax
            //   488bd6               | mov                 eax, dword ptr [edx + 0x1c]
            //   498bcf               | mov                 dword ptr [esp + 8], eax
            //   e8????????           |                     
            //   48891e               | mov                 eax, dword ptr [edx + 0x30]

        $sequence_7 = { 41c1ea19 4433d0 4403742408 4503e2 8b442404 4133dc }
            // n = 6, score = 100
            //   41c1ea19             | mov                 eax, dword ptr [esp + 0x30]
            //   4433d0               | dec                 esp
            //   4403742408           | sub                 eax, ebx
            //   4503e2               | mov                 edx, dword ptr [ebp + 0x400]
            //   8b442404             | dec                 eax
            //   4133dc               | mov                 ecx, ebx

        $sequence_8 = { e8???????? 4439b59c000000 7413 e9???????? ff15???????? cc 4489b59c000000 }
            // n = 7, score = 100
            //   e8????????           |                     
            //   4439b59c000000       | lea                 eax, [ebp + 0x1e0]
            //   7413                 | mov                 dword ptr [ebp + 0x40], edi
            //   e9????????           |                     
            //   ff15????????         |                     
            //   cc                   | inc                 ebp
            //   4489b59c000000       | mov                 esp, esi

        $sequence_9 = { 49c1e820 4c33c2 488b542420 4903d0 4c33ca 498bc9 }
            // n = 6, score = 100
            //   49c1e820             | xor                 esi, ebx
            //   4c33c2               | dec                 eax
            //   488b542420           | mov                 edx, esi
            //   4903d0               | dec                 ecx
            //   4c33ca               | mov                 eax, dword ptr [esp + 0x20]
            //   498bc9               | dec                 ebp

    condition:
        7 of them and filesize < 263168
}