rule win_unidentified_106_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.unidentified_106."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.unidentified_106"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { ff5040 89442440 85c0 780a c783f000000001000000 8b442440 4883c420 }
            // n = 7, score = 100
            //   ff5040               | dec                 eax
            //   89442440             | mov                 ecx, eax
            //   85c0                 | push                eax
            //   780a                 | neg                 ebx
            //   c783f000000001000000     | xor    eax, eax
            //   8b442440             | inc                 ebp
            //   4883c420             | mov                 ecx, esp

        $sequence_1 = { ba64000c00 488bcf 4c8be8 ff96c0000000 4885c0 750d bfeaffffff }
            // n = 7, score = 100
            //   ba64000c00           | dec                 eax
            //   488bcf               | lea                 edx, [0x5a20e]
            //   4c8be8               | mov                 eax, 3
            //   ff96c0000000         | dec                 eax
            //   4885c0               | lea                 edx, [0x5a20d]
            //   750d                 | mov                 eax, 3
            //   bfeaffffff           | mov                 eax, 3

        $sequence_2 = { 83e27f 8d0432 413bc4 0f87e0fbffff 83fa04 0f87d7fbffff 85d2 }
            // n = 7, score = 100
            //   83e27f               | inc                 ecx
            //   8d0432               | mov                 al, 0xf
            //   413bc4               | inc                 ecx
            //   0f87e0fbffff         | add                 edx, ebp
            //   83fa04               | dec                 eax
            //   0f87d7fbffff         | mov                 ecx, edi
            //   85d2                 | dec                 eax

        $sequence_3 = { ffc0 4883c110 413bc5 72f0 33c9 e8???????? 488b4c2448 }
            // n = 7, score = 100
            //   ffc0                 | test                edi, edi
            //   4883c110             | call                dword ptr [ebp + 0x30]
            //   413bc5               | dec                 eax
            //   72f0                 | mov                 ecx, edi
            //   33c9                 | dec                 ebp
            //   e8????????           |                     
            //   488b4c2448           | test                esp, esp

        $sequence_4 = { e8???????? 488d9424f0000000 498bce e8???????? 488d4c2420 e8???????? 41b820000000 }
            // n = 7, score = 100
            //   e8????????           |                     
            //   488d9424f0000000     | test                ecx, ecx
            //   498bce               | je                  0x392
            //   e8????????           |                     
            //   488d4c2420           | dec                 eax
            //   e8????????           |                     
            //   41b820000000         | mov                 dword ptr [edi], esi

        $sequence_5 = { 8bea 448b895c010000 448be2 412bf1 488bd9 2bee 85f6 }
            // n = 7, score = 100
            //   8bea                 | jb                  0x1ec
            //   448b895c010000       | mov                 eax, edx
            //   448be2               | dec                 ebp
            //   412bf1               | test                edi, edi
            //   488bd9               | je                  0x1ec
            //   2bee                 | mov                 eax, edx
            //   85f6                 | cmp                 edx, 0xa

        $sequence_6 = { c7470801000000 0f57c0 4889442470 0f57c9 48896c2440 41b00b 48896c2448 }
            // n = 7, score = 100
            //   c7470801000000       | xor                 eax, eax
            //   0f57c0               | dec                 eax
            //   4889442470           | mov                 dword ptr [ecx + 0x48], eax
            //   0f57c9               | dec                 eax
            //   48896c2440           | mov                 dword ptr [ecx], eax
            //   41b00b               | dec                 eax
            //   48896c2448           | mov                 eax, 0xf3bcc908

        $sequence_7 = { 85c0 7531 0fb7833c040000 6683e030 6683f810 7509 c683470400000a }
            // n = 7, score = 100
            //   85c0                 | mov                 edx, 1
            //   7531                 | test                eax, eax
            //   0fb7833c040000       | je                  0x2ea
            //   6683e030             | inc                 ecx
            //   6683f810             | lea                 eax, [ebp - 1]
            //   7509                 | cmp                 al, 1
            //   c683470400000a       | jbe                 0x2ea

        $sequence_8 = { 8b4a04 394c2460 7507 beffffffff eb62 ba07000300 48896c2478 }
            // n = 7, score = 100
            //   8b4a04               | cmp                 esi, esp
            //   394c2460             | jae                 0x338
            //   7507                 | jmp                 0x2e4
            //   beffffffff           | mov                 dword ptr [ebp - 0x29], ebx
            //   eb62                 | mov                 edx, eax
            //   ba07000300           | dec                 eax
            //   48896c2478           | lea                 ecx, [0x1bb267]

        $sequence_9 = { 7519 488d0598730800 c7450403000000 48898590000000 32c0 eb1f 488b5308 }
            // n = 7, score = 100
            //   7519                 | test                dx, dx
            //   488d0598730800       | je                  0xd5a
            //   c7450403000000       | jne                 0xde2
            //   48898590000000       | mov                 dword ptr [esp + 0x48], eax
            //   32c0                 | jmp                 0xdf0
            //   eb1f                 | mov                 eax, dword ptr [ebx + 0x1c0]
            //   488b5308             | mov                 dword ptr [esp + 0x48], eax

    condition:
        7 of them and filesize < 27402240
}