rule win_unidentified_107_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.unidentified_107."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.unidentified_107"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 7582 4989d8 31d2 4c89e9 e8???????? 4989d8 }
            // n = 6, score = 300
            //   7582                 | mov                 byte ptr [ebp - 0x19], 0xc3
            //   4989d8               | mov                 dword ptr [ebp - 0xc], 0x12
            //   31d2                 | mov                 edx, dword ptr [ebp - 0xc]
            //   4c89e9               | dec                 eax
            //   e8????????           |                     
            //   4989d8               | mov                 eax, dword ptr [ebp + 0x10]

        $sequence_1 = { 0f1f00 8b0b ffd7 4989c4 }
            // n = 4, score = 300
            //   0f1f00               | cmp                 eax, 0x6c642e6c
            //   8b0b                 | je                  0x58
            //   ffd7                 | jmp                 0x3a
            //   4989c4               | or                  eax, 0x20202020

        $sequence_2 = { 4989c7 48c7c13b43f72a e8???????? 4883c464 488b4c2408 488b542410 4c8b442418 }
            // n = 7, score = 300
            //   4989c7               | dec                 eax
            //   48c7c13b43f72a       | mov                 ecx, eax
            //   e8????????           |                     
            //   4883c464             | dec                 eax
            //   488b4c2408           | mov                 ecx, eax
            //   488b542410           | dec                 eax
            //   4c8b442418           | mov                 edx, eax

        $sequence_3 = { 4883f807 7e96 8b13 4883f80b 0f8f33010000 8b03 85c0 }
            // n = 7, score = 300
            //   4883f807             | dec                 eax
            //   7e96                 | add                 eax, ecx
            //   8b13                 | mov                 ecx, edx
            //   4883f80b             | xor                 edx, edx
            //   0f8f33010000         | inc                 esp
            //   8b03                 | sub                 ecx, eax
            //   85c0                 | dec                 eax

        $sequence_4 = { 4989cc 85db 0f8e16010000 488b05???????? 4531c9 4883c018 }
            // n = 6, score = 300
            //   4989cc               | mov                 edx, eax
            //   85db                 | dec                 eax
            //   0f8e16010000         | lea                 eax, [ebp + 0xe2]
            //   488b05????????       |                     
            //   4531c9               | dec                 eax
            //   4883c018             | mov                 ecx, eax

        $sequence_5 = { 48b9ca0e99c700000000 e8???????? 4989c7 48b9ca0e99c700000000 e8???????? }
            // n = 5, score = 300
            //   48b9ca0e99c700000000     | dec    eax
            //   e8????????           |                     
            //   4989c7               | mov                 edx, eax
            //   48b9ca0e99c700000000     | dec    eax
            //   e8????????           |                     

        $sequence_6 = { 8b5208 4901d0 4d39c4 0f828a000000 4183c101 4883c028 4139d9 }
            // n = 7, score = 300
            //   8b5208               | movzx               edx, byte ptr [ecx - 1]
            //   4901d0               | test                dl, dl
            //   4d39c4               | jne                 0x893
            //   0f828a000000         | mov                 eax, ebx
            //   4183c101             | mov                 ecx, 2
            //   4883c028             | xor                 edx, edx
            //   4139d9               | mov                 byte ptr [esi + eax], 0xa

        $sequence_7 = { e8???????? 8b05???????? 85c0 0f8e57ffffff 83e801 488b1d???????? 31ff }
            // n = 7, score = 300
            //   e8????????           |                     
            //   8b05????????         |                     
            //   85c0                 | mov                 ecx, eax
            //   0f8e57ffffff         | dec                 eax
            //   83e801               | mov                 edx, dword ptr [ebp - 8]
            //   488b1d????????       |                     
            //   31ff                 | dec                 eax

        $sequence_8 = { 85db 0f8e16010000 488b05???????? 4531c9 4883c018 0f1f840000000000 }
            // n = 6, score = 300
            //   85db                 | jbe                 0x75
            //   0f8e16010000         | jle                 0xffffffe7
            //   488b05????????       |                     
            //   4531c9               | mov                 edx, dword ptr [ebx]
            //   4883c018             | dec                 eax
            //   0f1f840000000000     | cmp                 eax, 0xb

        $sequence_9 = { 8b560c 41b830000000 488d0c10 488b05???????? }
            // n = 4, score = 300
            //   8b560c               | mov                 ecx, edi
            //   41b830000000         | cmp                 eax, 1
            //   488d0c10             | jbe                 0x92c
            //   488b05????????       |                     

    condition:
        7 of them and filesize < 254976
}