rule win_unidentified_110_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.unidentified_110."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.unidentified_110"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 753e 4c89f1 89da 4189e8 e8???????? 8a08 488b5040 }
            // n = 7, score = 100
            //   753e                 | lea                 edx, [esp + 0x30]
            //   4c89f1               | jne                 0x350
            //   89da                 | dec                 eax
            //   4189e8               | lea                 ecx, [esp + 0x138]
            //   e8????????           |                     
            //   8a08                 | test                al, al
            //   488b5040             | je                  0x34b

        $sequence_1 = { 4c89e0 48f7e1 4989c7 0f91c0 0f8050010000 88c3 48c1e306 }
            // n = 7, score = 100
            //   4c89e0               | dec                 esp
            //   48f7e1               | mov                 eax, ecx
            //   4989c7               | dec                 eax
            //   0f91c0               | mov                 ebx, ecx
            //   0f8050010000         | dec                 eax
            //   88c3                 | mov                 ecx, dword ptr [esp + 0x70]
            //   48c1e306             | dec                 eax

        $sequence_2 = { f0480fc11d???????? 8b05???????? 65488b0c2558000000 488b04c1 80b82001000000 7505 e8???????? }
            // n = 7, score = 100
            //   f0480fc11d????????     |     
            //   8b05????????         |                     
            //   65488b0c2558000000     | ret    
            //   488b04c1             | mov                 ecx, 7
            //   80b82001000000       | dec                 eax
            //   7505                 | mov                 ecx, dword ptr [0x58]
            //   e8????????           |                     

        $sequence_3 = { 48ffc8 4883f802 0f83ab000000 488bb42430010000 488d4e18 498b1424 e8???????? }
            // n = 7, score = 100
            //   48ffc8               | dec                 eax
            //   4883f802             | sub                 esi, eax
            //   0f83ab000000         | jb                  0x78a
            //   488bb42430010000     | inc                 ecx
            //   488d4e18             | cmp                 ebp, edx
            //   498b1424             | jae                 0x71d
            //   e8????????           |                     

        $sequence_4 = { e8???????? 0f1006 0f104e10 0f105620 0f119390000000 0f118b80000000 0f114370 }
            // n = 7, score = 100
            //   e8????????           |                     
            //   0f1006               | ud2                 
            //   0f104e10             | dec                 esp
            //   0f105620             | mov                 ecx, edx
            //   0f119390000000       | ud2                 
            //   0f118b80000000       | dec                 eax
            //   0f114370             | lea                 ecx, [0x14e35e]

        $sequence_5 = { 4c89c1 e8???????? 4889c7 83ff01 7543 4889d9 ba2f000000 }
            // n = 7, score = 100
            //   4c89c1               | lea                 eax, [esp + 0x80]
            //   e8????????           |                     
            //   4889c7               | movups              xmmword ptr [eax - 0x28], xmm6
            //   83ff01               | dec                 esp
            //   7543                 | mov                 edi, dword ptr [esp + 0x100]
            //   4889d9               | dec                 ecx
            //   ba2f000000           | lea                 eax, [edi - 0x30]

        $sequence_6 = { 4c8d642448 49c7c6ffffffff 4c89e9 e8???????? 6683f801 0f85b6000000 89d5 }
            // n = 7, score = 100
            //   4c8d642448           | dec                 esp
            //   49c7c6ffffffff       | lea                 ecx, [0xe154e]
            //   4c89e9               | dec                 ecx
            //   e8????????           |                     
            //   6683f801             | mov                 esi, 0x4d4771da
            //   0f85b6000000         | sbb                 al, 0x2b
            //   89d5                 | pop                 ecx

        $sequence_7 = { 4c8d0557060800 ba25000000 e8???????? 0f0b 56 4883ec20 488b31 }
            // n = 7, score = 100
            //   4c8d0557060800       | mov                 edx, 2
            //   ba25000000           | dec                 esp
            //   e8????????           |                     
            //   0f0b                 | lea                 eax, [0xaf314]
            //   56                   | mov                 ecx, 3
            //   4883ec20             | mov                 edx, 3
            //   488b31               | dec                 esp

        $sequence_8 = { 4869cf48010000 4801c1 4883c108 48c741f801000000 41b840010000 4c89f2 e8???????? }
            // n = 7, score = 100
            //   4869cf48010000       | mov                 eax, dword ptr [ecx + eax*8]
            //   4801c1               | dec                 eax
            //   4883c108             | cmp                 ecx, dword ptr [ebx + 0xa8]
            //   48c741f801000000     | jbe                 0x8e
            //   41b840010000         | cmp                 byte ptr [ebx + 0x14c], 0
            //   4c89f2               | je                  0x3dd
            //   e8????????           |                     

        $sequence_9 = { 65488b0c2558000000 488b2cc1 0fb7b578010000 66c785780100000180 4889f9 4c89f2 e8???????? }
            // n = 7, score = 100
            //   65488b0c2558000000     | dec    eax
            //   488b2cc1             | mov                 ecx, dword ptr [0x58]
            //   0fb7b578010000       | dec                 eax
            //   66c785780100000180     | mov    eax, dword ptr [ecx + eax*8]
            //   4889f9               | dec                 eax
            //   4c89f2               | mov                 ecx, dword ptr [0x58]
            //   e8????????           |                     

    condition:
        7 of them and filesize < 3217408
}