rule win_unidentified_118_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.unidentified_118."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.unidentified_118"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 0f57c0 c60300 41b820000000 0f1101 4883611000 488bd6 4883611800 }
            // n = 7, score = 300
            //   0f57c0               | lea                 ecx, [edx + 0x100]
            //   c60300               | dec                 eax
            //   41b820000000         | lea                 ecx, [edx + 0x78]
            //   0f1101               | dec                 eax
            //   4883611000           | lea                 ecx, [edx + 0x50]
            //   488bd6               | dec                 eax
            //   4883611800           | mov                 ecx, dword ptr [edx + 0x28]

        $sequence_1 = { e8???????? 84c0 7409 488933 c6430800 eb79 48b8e1e1e1e1e1e1e101 }
            // n = 7, score = 300
            //   e8????????           |                     
            //   84c0                 | sub                 esp, 0x20
            //   7409                 | dec                 eax
            //   488933               | mov                 esi, dword ptr [edx + 8]
            //   c6430800             | dec                 eax
            //   eb79                 | mov                 ebx, ecx
            //   48b8e1e1e1e1e1e1e101     | ret    

        $sequence_2 = { 84c0 740c 817c243000400000 7502 }
            // n = 4, score = 300
            //   84c0                 | jae                 0x95
            //   740c                 | ja                  0xa2
            //   817c243000400000     | mov                 eax, ebx
            //   7502                 | jmp                 0x7d

        $sequence_3 = { 488bc3 488b4d07 4833cc e8???????? 4881c4b8000000 415f 415e }
            // n = 7, score = 300
            //   488bc3               | dec                 eax
            //   488b4d07             | cmp                 edx, 0xf
            //   4833cc               | jbe                 0x982
            //   e8????????           |                     
            //   4881c4b8000000       | dec                 eax
            //   415f                 | inc                 edx
            //   415e                 | dec                 eax

        $sequence_4 = { 488b49f8 482bc1 4883c0f8 4883f81f 7721 e8???????? 8bc3 }
            // n = 7, score = 300
            //   488b49f8             | xor                 eax, eax
            //   482bc1               | mov                 edx, 0x4d830f50
            //   4883c0f8             | dec                 eax
            //   4883f81f             | mov                 ecx, eax
            //   7721                 | xor                 edx, edx
            //   e8????????           |                     
            //   8bc3                 | dec                 eax

        $sequence_5 = { 7747 e8???????? 660f6f05???????? f30f7f4527 c6451700 807de700 7409 }
            // n = 7, score = 300
            //   7747                 | jne                 0x950
            //   e8????????           |                     
            //   660f6f05????????     |                     
            //   f30f7f4527           | mov                 eax, 0x20b
            //   c6451700             | jne                 0x976
            //   807de700             | cmp                 eax, 0x57
            //   7409                 | jne                 0x92a

        $sequence_6 = { 0f45fd 488bce e8???????? 488b4c2430 e8???????? }
            // n = 5, score = 300
            //   0f45fd               | lea                 eax, [0x1c620]
            //   488bce               | dec                 eax
            //   e8????????           |                     
            //   488b4c2430           | mov                 dword ptr [ebx], eax
            //   e8????????           |                     

        $sequence_7 = { 488d4c2460 ffd2 90 e9???????? 0f57c0 0f1145f0 0f57c9 }
            // n = 7, score = 300
            //   488d4c2460           | inc                 esp
            //   ffd2                 | lea                 ecx, [ebx + 4]
            //   90                   | dec                 eax
            //   e9????????           |                     
            //   0f57c0               | mov                 dword ptr [esp + 0x20], eax
            //   0f1145f0             | dec                 esp
            //   0f57c9               | lea                 eax, [esp + 0x40]

        $sequence_8 = { e8???????? 4c8b4c2450 4c8bc3 488bd7 488bce }
            // n = 5, score = 300
            //   e8????????           |                     
            //   4c8b4c2450           | mov                 ecx, edi
            //   4c8bc3               | mov                 ebx, 8
            //   488bd7               | dec                 eax
            //   488bce               | lea                 ecx, [ebp - 0x49]

        $sequence_9 = { 488b49f8 482bc1 4883c0f8 4883f81f 0f87d8000000 e8???????? 483bfe }
            // n = 7, score = 300
            //   488b49f8             | dec                 eax
            //   482bc1               | cmp                 edx, 0xf
            //   4883c0f8             | jbe                 0x5b2
            //   4883f81f             | dec                 eax
            //   0f87d8000000         | inc                 edx
            //   e8????????           |                     
            //   483bfe               | dec                 eax

    condition:
        7 of them and filesize < 413696
}