rule win_unidentified_121_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.unidentified_121."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.unidentified_121"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 8b55fc 8b421c 2540040000 750c }
            // n = 4, score = 100
            //   8b55fc               | mov                 ecx, dword ptr [ebp - 4]
            //   8b421c               | mov                 dword ptr [ecx + 0x1c], eax
            //   2540040000           | mov                 edx, dword ptr [ebp + 0x14]
            //   750c                 | mov                 edx, dword ptr [ebp - 4]

        $sequence_1 = { 8b55fc 8b4218 8945f0 8b4d08 83792800 7405 }
            // n = 6, score = 100
            //   8b55fc               | mov                 eax, dword ptr [esi + 0x100]
            //   8b4218               | dec                 eax
            //   8945f0               | mov                 dword ptr [esi + 0x128], ebp
            //   8b4d08               | je                  0xcb
            //   83792800             | dec                 eax
            //   7405                 | lea                 edx, [eax + 1]

        $sequence_2 = { 8b55fc 8b421c 50 68???????? 8b4d08 }
            // n = 5, score = 100
            //   8b55fc               | jne                 0x4a
            //   8b421c               | mov                 ecx, dword ptr [ebp + 0x14]
            //   50                   | push                ecx
            //   68????????           |                     
            //   8b4d08               | mov                 edx, dword ptr [ebp - 4]

        $sequence_3 = { ff15???????? 4c8d4c2438 488b0d???????? 41b804000000 488d1584810100 89c3 e8???????? }
            // n = 7, score = 100
            //   ff15????????         |                     
            //   4c8d4c2438           | jne                 0x84
            //   488b0d????????       |                     
            //   41b804000000         | dec                 ebp
            //   488d1584810100       | test                ebp, ebp
            //   89c3                 | mov                 edx, 1
            //   e8????????           |                     

        $sequence_4 = { 0f8499000000 41b806000000 ba01000000 b902000000 ffd5 488b5320 }
            // n = 6, score = 100
            //   0f8499000000         | dec                 ecx
            //   41b806000000         | mov                 eax, ebp
            //   ba01000000           | je                  0x9f
            //   b902000000           | inc                 ecx
            //   ffd5                 | mov                 eax, 6
            //   488b5320             | mov                 edx, 1

        $sequence_5 = { 8b55fc 8b421c 2580000000 740c }
            // n = 4, score = 100
            //   8b55fc               | mov                 dword ptr [ecx + 0x1c], eax
            //   8b421c               | mov                 edx, dword ptr [ebp - 4]
            //   2580000000           | push                edx
            //   740c                 | mov                 edx, dword ptr [ebp - 4]

        $sequence_6 = { 4889d9 48c744245800000000 48c744246000000000 e8???????? 4889d9 ff15???????? }
            // n = 6, score = 100
            //   4889d9               | jne                 0x3f
            //   48c744245800000000     | dec    esp
            //   48c744246000000000     | lea    ecx, [esp + 0x38]
            //   e8????????           |                     
            //   4889d9               | inc                 ecx
            //   ff15????????         |                     

        $sequence_7 = { 8944244c 0f85a1000000 83430801 4d89e1 4989e8 }
            // n = 5, score = 100
            //   8944244c             | mov                 dword ptr [esp + 0x4c], eax
            //   0f85a1000000         | jne                 0xa7
            //   83430801             | add                 dword ptr [ebx + 8], 1
            //   4d89e1               | dec                 ebp
            //   4989e8               | mov                 ecx, esp

        $sequence_8 = { 3c54 0f857e000000 e8???????? 4d85ed ba01000000 752f }
            // n = 6, score = 100
            //   3c54                 | mov                 ecx, 2
            //   0f857e000000         | call                ebp
            //   e8????????           |                     
            //   4d85ed               | dec                 eax
            //   ba01000000           | mov                 edx, dword ptr [ebx + 0x20]
            //   752f                 | cmp                 al, 0x54

        $sequence_9 = { 8b55fc 8b4218 99 8bc8 }
            // n = 4, score = 100
            //   8b55fc               | dec                 eax
            //   8b4218               | sub                 edx, 1
            //   99                   | dec                 eax
            //   8bc8                 | cmp                 edx, -3

        $sequence_10 = { 85db 0f8589000000 488b5028 4883ea01 4883fafd 777b 4885ed }
            // n = 7, score = 100
            //   85db                 | jne                 0x13
            //   0f8589000000         | mov                 esi, dword ptr [eax + 4]
            //   488b5028             | test                esi, esi
            //   4883ea01             | jne                 0x40
            //   4883fafd             | dec                 eax
            //   777b                 | mov                 dword ptr [edi], eax
            //   4885ed               | dec                 eax

        $sequence_11 = { 7511 8b7004 85f6 7539 488907 48c70300000000 }
            // n = 6, score = 100
            //   7511                 | mov                 eax, 4
            //   8b7004               | dec                 eax
            //   85f6                 | lea                 edx, [0x18184]
            //   7539                 | mov                 ebx, eax
            //   488907               | dec                 eax
            //   48c70300000000       | mov                 ecx, ebx

        $sequence_12 = { e8???????? 41f6c404 488b8600010000 4889ae28010000 0f84b7000000 488d5001 483dff000000 }
            // n = 7, score = 100
            //   e8????????           |                     
            //   41f6c404             | dec                 eax
            //   488b8600010000       | mov                 dword ptr [esp + 0x58], 0
            //   4889ae28010000       | dec                 eax
            //   0f84b7000000         | mov                 dword ptr [esp + 0x60], 0
            //   488d5001             | dec                 eax
            //   483dff000000         | mov                 ecx, ebx

        $sequence_13 = { 8b55fc 8b421c 2580020000 8b4df8 }
            // n = 4, score = 100
            //   8b55fc               | je                  0x16
            //   8b421c               | mov                 dword ptr [ebp - 0x9c], 1
            //   2580020000           | jmp                 0x20
            //   8b4df8               | mov                 dword ptr [ebp - 0x9c], 0

        $sequence_14 = { 8b55fc 8b421c 0d80020000 8b4dfc }
            // n = 4, score = 100
            //   8b55fc               | mov                 esi, edx
            //   8b421c               | mov                 edx, dword ptr [ebp - 4]
            //   0d80020000           | mov                 eax, dword ptr [edx + 0x18]
            //   8b4dfc               | cdq                 

        $sequence_15 = { 8b55fc 8b421c 0d00080000 8b4dfc 89411c e9???????? }
            // n = 6, score = 100
            //   8b55fc               | mov                 ecx, dword ptr [ebp + 8]
            //   8b421c               | cmp                 dword ptr [ecx + 0x28], 0
            //   0d00080000           | je                  0x11
            //   8b4dfc               | mov                 edx, dword ptr [ebp - 4]
            //   89411c               | mov                 eax, dword ptr [edx + 0x18]
            //   e9????????           |                     

    condition:
        7 of them and filesize < 2419712
}