rule win_upas_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.upas."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.upas"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 7816 8b45f8 8b08 57 ff7508 }
            // n = 5, score = 400
            //   7816                 | js                  0x18
            //   8b45f8               | mov                 eax, dword ptr [ebp - 8]
            //   8b08                 | mov                 ecx, dword ptr [eax]
            //   57                   | push                edi
            //   ff7508               | push                dword ptr [ebp + 8]

        $sequence_1 = { 0bcf eb10 85f6 7507 83fa05 }
            // n = 5, score = 400
            //   0bcf                 | or                  ecx, edi
            //   eb10                 | jmp                 0x12
            //   85f6                 | test                esi, esi
            //   7507                 | jne                 9
            //   83fa05               | cmp                 edx, 5

        $sequence_2 = { c3 55 8bec 81ec8c0b0000 53 56 }
            // n = 6, score = 400
            //   c3                   | ret                 
            //   55                   | push                ebp
            //   8bec                 | mov                 ebp, esp
            //   81ec8c0b0000         | sub                 esp, 0xb8c
            //   53                   | push                ebx
            //   56                   | push                esi

        $sequence_3 = { ff35???????? ffd6 85c0 75e7 50 e8???????? 59 }
            // n = 7, score = 400
            //   ff35????????         |                     
            //   ffd6                 | call                esi
            //   85c0                 | test                eax, eax
            //   75e7                 | jne                 0xffffffe9
            //   50                   | push                eax
            //   e8????????           |                     
            //   59                   | pop                 ecx

        $sequence_4 = { ff15???????? 53 ff15???????? 6800400000 ff75f8 ff75f4 ff15???????? }
            // n = 7, score = 400
            //   ff15????????         |                     
            //   53                   | push                ebx
            //   ff15????????         |                     
            //   6800400000           | push                0x4000
            //   ff75f8               | push                dword ptr [ebp - 8]
            //   ff75f4               | push                dword ptr [ebp - 0xc]
            //   ff15????????         |                     

        $sequence_5 = { 8d4438eb 8945dd 33c0 3945f8 7517 ff75f0 }
            // n = 6, score = 400
            //   8d4438eb             | lea                 eax, [eax + edi - 0x15]
            //   8945dd               | mov                 dword ptr [ebp - 0x23], eax
            //   33c0                 | xor                 eax, eax
            //   3945f8               | cmp                 dword ptr [ebp - 8], eax
            //   7517                 | jne                 0x19
            //   ff75f0               | push                dword ptr [ebp - 0x10]

        $sequence_6 = { 7410 49 740d 83e909 7410 83e919 }
            // n = 6, score = 400
            //   7410                 | je                  0x12
            //   49                   | dec                 ecx
            //   740d                 | je                  0xf
            //   83e909               | sub                 ecx, 9
            //   7410                 | je                  0x12
            //   83e919               | sub                 ecx, 0x19

        $sequence_7 = { c9 c3 56 57 8d8550faffff 50 }
            // n = 6, score = 400
            //   c9                   | leave               
            //   c3                   | ret                 
            //   56                   | push                esi
            //   57                   | push                edi
            //   8d8550faffff         | lea                 eax, [ebp - 0x5b0]
            //   50                   | push                eax

        $sequence_8 = { 6a08 ff750c e8???????? 33c0 }
            // n = 4, score = 400
            //   6a08                 | push                8
            //   ff750c               | push                dword ptr [ebp + 0xc]
            //   e8????????           |                     
            //   33c0                 | xor                 eax, eax

        $sequence_9 = { 8dbd20ffffff f3a5 0fb74814 8d5c0118 }
            // n = 4, score = 400
            //   8dbd20ffffff         | lea                 edi, [ebp - 0xe0]
            //   f3a5                 | rep movsd           dword ptr es:[edi], dword ptr [esi]
            //   0fb74814             | movzx               ecx, word ptr [eax + 0x14]
            //   8d5c0118             | lea                 ebx, [ecx + eax + 0x18]

    condition:
        7 of them and filesize < 114688
}