rule win_upatre_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.upatre."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.upatre"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { b02f 66ab 8b45a8 ff5504 33c9 8ac8 ff5508 }
            // n = 7, score = 200
            //   b02f                 | mov                 al, 0x2f
            //   66ab                 | stosw               word ptr es:[edi], ax
            //   8b45a8               | mov                 eax, dword ptr [ebp - 0x58]
            //   ff5504               | call                dword ptr [ebp + 4]
            //   33c9                 | xor                 ecx, ecx
            //   8ac8                 | mov                 cl, al
            //   ff5508               | call                dword ptr [ebp + 8]

        $sequence_1 = { b400 66ab b02f 66ab ff7590 33c0 }
            // n = 6, score = 200
            //   b400                 | mov                 ah, 0
            //   66ab                 | stosw               word ptr es:[edi], ax
            //   b02f                 | mov                 al, 0x2f
            //   66ab                 | stosw               word ptr es:[edi], ax
            //   ff7590               | push                dword ptr [ebp - 0x70]
            //   33c0                 | xor                 eax, eax

        $sequence_2 = { 81c60e010000 ac 3c01 740c b053 66ab }
            // n = 6, score = 200
            //   81c60e010000         | add                 esi, 0x10e
            //   ac                   | lodsb               al, byte ptr [esi]
            //   3c01                 | cmp                 al, 1
            //   740c                 | je                  0xe
            //   b053                 | mov                 al, 0x53
            //   66ab                 | stosw               word ptr es:[edi], ax

        $sequence_3 = { 6a00 8d4dc0 51 ff75e0 ff75bc ff75ec }
            // n = 6, score = 200
            //   6a00                 | push                0
            //   8d4dc0               | lea                 ecx, [ebp - 0x40]
            //   51                   | push                ecx
            //   ff75e0               | push                dword ptr [ebp - 0x20]
            //   ff75bc               | push                dword ptr [ebp - 0x44]
            //   ff75ec               | push                dword ptr [ebp - 0x14]

        $sequence_4 = { 58 6a00 8d4de0 51 50 }
            // n = 5, score = 200
            //   58                   | pop                 eax
            //   6a00                 | push                0
            //   8d4de0               | lea                 ecx, [ebp - 0x20]
            //   51                   | push                ecx
            //   50                   | push                eax

        $sequence_5 = { 33c0 b404 57 03f8 8bf7 }
            // n = 5, score = 200
            //   33c0                 | xor                 eax, eax
            //   b404                 | mov                 ah, 4
            //   57                   | push                edi
            //   03f8                 | add                 edi, eax
            //   8bf7                 | mov                 esi, edi

        $sequence_6 = { b404 895d98 8bfb 03d8 b91c010000 }
            // n = 5, score = 200
            //   b404                 | mov                 ah, 4
            //   895d98               | mov                 dword ptr [ebp - 0x68], ebx
            //   8bfb                 | mov                 edi, ebx
            //   03d8                 | add                 ebx, eax
            //   b91c010000           | mov                 ecx, 0x11c

        $sequence_7 = { 33c0 66ab bbff0f0000 8b75f0 56 53 }
            // n = 6, score = 200
            //   33c0                 | xor                 eax, eax
            //   66ab                 | stosw               word ptr es:[edi], ax
            //   bbff0f0000           | mov                 ebx, 0xfff
            //   8b75f0               | mov                 esi, dword ptr [ebp - 0x10]
            //   56                   | push                esi
            //   53                   | push                ebx

        $sequence_8 = { 68d770a437 8b4dd4 51 e8???????? 8945e8 }
            // n = 5, score = 100
            //   68d770a437           | push                0x37a470d7
            //   8b4dd4               | mov                 ecx, dword ptr [ebp - 0x2c]
            //   51                   | push                ecx
            //   e8????????           |                     
            //   8945e8               | mov                 dword ptr [ebp - 0x18], eax

        $sequence_9 = { 83c404 0fb7c0 3b4510 7411 8b4de0 51 }
            // n = 6, score = 100
            //   83c404               | add                 esp, 4
            //   0fb7c0               | movzx               eax, ax
            //   3b4510               | cmp                 eax, dword ptr [ebp + 0x10]
            //   7411                 | je                  0x13
            //   8b4de0               | mov                 ecx, dword ptr [ebp - 0x20]
            //   51                   | push                ecx

        $sequence_10 = { 83c410 eb58 8b4df4 8b510c 52 e8???????? }
            // n = 6, score = 100
            //   83c410               | add                 esp, 0x10
            //   eb58                 | jmp                 0x5a
            //   8b4df4               | mov                 ecx, dword ptr [ebp - 0xc]
            //   8b510c               | mov                 edx, dword ptr [ecx + 0xc]
            //   52                   | push                edx
            //   e8????????           |                     

        $sequence_11 = { 1f c011a0 6b20bd 80978041a0e3b2 34c0 8fc0 81205b606d00 }
            // n = 7, score = 100
            //   1f                   | pop                 ds
            //   c011a0               | rcl                 byte ptr [ecx], 0xa0
            //   6b20bd               | imul                esp, dword ptr [eax], -0x43
            //   80978041a0e3b2       | adc                 byte ptr [edi - 0x1c5fbe80], 0xb2
            //   34c0                 | xor                 al, 0xc0
            //   8fc0                 | pop                 eax
            //   81205b606d00         | and                 dword ptr [eax], 0x6d605b

        $sequence_12 = { 83c108 894dfc 8b55fc 8b02 50 e8???????? }
            // n = 6, score = 100
            //   83c108               | add                 ecx, 8
            //   894dfc               | mov                 dword ptr [ebp - 4], ecx
            //   8b55fc               | mov                 edx, dword ptr [ebp - 4]
            //   8b02                 | mov                 eax, dword ptr [edx]
            //   50                   | push                eax
            //   e8????????           |                     

        $sequence_13 = { 0fb745f8 0fb74df4 99 f7f9 }
            // n = 4, score = 100
            //   0fb745f8             | movzx               eax, word ptr [ebp - 8]
            //   0fb74df4             | movzx               ecx, word ptr [ebp - 0xc]
            //   99                   | cdq                 
            //   f7f9                 | idiv                ecx

        $sequence_14 = { 0f8416010000 8b55f4 8b420c 50 e8???????? }
            // n = 5, score = 100
            //   0f8416010000         | je                  0x11c
            //   8b55f4               | mov                 edx, dword ptr [ebp - 0xc]
            //   8b420c               | mov                 eax, dword ptr [edx + 0xc]
            //   50                   | push                eax
            //   e8????????           |                     

        $sequence_15 = { 7529 8b4df4 8b5110 81c200100000 8955f0 8d45f0 }
            // n = 6, score = 100
            //   7529                 | jne                 0x2b
            //   8b4df4               | mov                 ecx, dword ptr [ebp - 0xc]
            //   8b5110               | mov                 edx, dword ptr [ecx + 0x10]
            //   81c200100000         | add                 edx, 0x1000
            //   8955f0               | mov                 dword ptr [ebp - 0x10], edx
            //   8d45f0               | lea                 eax, [ebp - 0x10]

    condition:
        7 of them and filesize < 294912
}