rule win_urlzone_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.urlzone."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.urlzone"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 55 8bec 81c4e8fbffff 53 56 57 8b4514 }
            // n = 7, score = 100
            //   55                   | push                ebp
            //   8bec                 | mov                 ebp, esp
            //   81c4e8fbffff         | add                 esp, 0xfffffbe8
            //   53                   | push                ebx
            //   56                   | push                esi
            //   57                   | push                edi
            //   8b4514               | mov                 eax, dword ptr [ebp + 0x14]

        $sequence_1 = { 8910 33c0 8943e4 c745fcffffffff eb1f 46 83c340 }
            // n = 7, score = 100
            //   8910                 | mov                 dword ptr [eax], edx
            //   33c0                 | xor                 eax, eax
            //   8943e4               | mov                 dword ptr [ebx - 0x1c], eax
            //   c745fcffffffff       | mov                 dword ptr [ebp - 4], 0xffffffff
            //   eb1f                 | jmp                 0x21
            //   46                   | inc                 esi
            //   83c340               | add                 ebx, 0x40

        $sequence_2 = { 83fbff 0f8420070000 6a00 53 e8???????? 8945f8 }
            // n = 6, score = 100
            //   83fbff               | cmp                 ebx, -1
            //   0f8420070000         | je                  0x726
            //   6a00                 | push                0
            //   53                   | push                ebx
            //   e8????????           |                     
            //   8945f8               | mov                 dword ptr [ebp - 8], eax

        $sequence_3 = { 50 e8???????? 6a00 6a00 2df1000000 50 8b06 }
            // n = 7, score = 100
            //   50                   | push                eax
            //   e8????????           |                     
            //   6a00                 | push                0
            //   6a00                 | push                0
            //   2df1000000           | sub                 eax, 0xf1
            //   50                   | push                eax
            //   8b06                 | mov                 eax, dword ptr [esi]

        $sequence_4 = { 6a00 56 6a00 6802000001 6a00 53 }
            // n = 6, score = 100
            //   6a00                 | push                0
            //   56                   | push                esi
            //   6a00                 | push                0
            //   6802000001           | push                0x1000002
            //   6a00                 | push                0
            //   53                   | push                ebx

        $sequence_5 = { 85c0 7c04 85d2 7d02 33c9 8bc1 c3 }
            // n = 7, score = 100
            //   85c0                 | test                eax, eax
            //   7c04                 | jl                  6
            //   85d2                 | test                edx, edx
            //   7d02                 | jge                 4
            //   33c9                 | xor                 ecx, ecx
            //   8bc1                 | mov                 eax, ecx
            //   c3                   | ret                 

        $sequence_6 = { 50 e8???????? b001 e8???????? 68???????? 68???????? e8???????? }
            // n = 7, score = 100
            //   50                   | push                eax
            //   e8????????           |                     
            //   b001                 | mov                 al, 1
            //   e8????????           |                     
            //   68????????           |                     
            //   68????????           |                     
            //   e8????????           |                     

        $sequence_7 = { c6041000 bf01000000 8db36cfeffff 8b06 85c0 7438 }
            // n = 6, score = 100
            //   c6041000             | mov                 byte ptr [eax + edx], 0
            //   bf01000000           | mov                 edi, 1
            //   8db36cfeffff         | lea                 esi, [ebx - 0x194]
            //   8b06                 | mov                 eax, dword ptr [esi]
            //   85c0                 | test                eax, eax
            //   7438                 | je                  0x3a

        $sequence_8 = { bb???????? 8b45f8 50 8d8577ffffff 50 }
            // n = 5, score = 100
            //   bb????????           |                     
            //   8b45f8               | mov                 eax, dword ptr [ebp - 8]
            //   50                   | push                eax
            //   8d8577ffffff         | lea                 eax, [ebp - 0x89]
            //   50                   | push                eax

        $sequence_9 = { 7435 e9???????? 56 8d85effdffff }
            // n = 4, score = 100
            //   7435                 | je                  0x37
            //   e9????????           |                     
            //   56                   | push                esi
            //   8d85effdffff         | lea                 eax, [ebp - 0x211]

    condition:
        7 of them and filesize < 155648
}