rule win_uroburos_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2024-10-31"
        version = "1"
        description = "Detects win.uroburos."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.uroburos"
        malpedia_rule_date = "20241030"
        malpedia_hash = "26e26953c49c8efafbf72a38076855d578e0a2e4"
        malpedia_version = "20241030"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 7526 85d2 7411 8b493c 8bc2 }
            // n = 5, score = 400
            //   7526                 | jne                 0x28
            //   85d2                 | test                edx, edx
            //   7411                 | je                  0x13
            //   8b493c               | mov                 ecx, dword ptr [ecx + 0x3c]
            //   8bc2                 | mov                 eax, edx

        $sequence_1 = { 83f819 7704 4183c120 440fb612 }
            // n = 4, score = 300
            //   83f819               | cmp                 eax, ecx
            //   7704                 | mov                 ecx, dword ptr [ecx + 0x3c]
            //   4183c120             | mov                 eax, edx
            //   440fb612             | dec                 eax

        $sequence_2 = { 83f819 7704 4183c220 4585c9 740a 453bca }
            // n = 6, score = 300
            //   83f819               | cmp                 eax, 0x19
            //   7704                 | ja                  6
            //   4183c220             | inc                 ecx
            //   4585c9               | add                 edx, 0x20
            //   740a                 | inc                 ebp
            //   453bca               | test                ecx, ecx

        $sequence_3 = { 8b493c 8bc2 4881c108010000 483bc1 }
            // n = 4, score = 300
            //   8b493c               | dec                 ecx
            //   8bc2                 | mov                 edx, edi
            //   4881c108010000       | mov                 eax, 0x21590067
            //   483bc1               | dec                 ecx

        $sequence_4 = { b980000000 e8???????? 09c0 a3???????? 7504 }
            // n = 5, score = 300
            //   b980000000           | mov                 ecx, 0x80
            //   e8????????           |                     
            //   09c0                 | or                  eax, eax
            //   a3????????           |                     
            //   7504                 | jne                 6

        $sequence_5 = { 09f6 57 8b7d10 7509 }
            // n = 4, score = 300
            //   09f6                 | or                  esi, esi
            //   57                   | push                edi
            //   8b7d10               | mov                 edi, dword ptr [ebp + 0x10]
            //   7509                 | jne                 0xb

        $sequence_6 = { 7503 21450c 837d0c00 7411 a1???????? 09c0 }
            // n = 6, score = 300
            //   7503                 | jne                 5
            //   21450c               | and                 dword ptr [ebp + 0xc], eax
            //   837d0c00             | cmp                 dword ptr [ebp + 0xc], 0
            //   7411                 | je                  0x13
            //   a1????????           |                     
            //   09c0                 | or                  eax, eax

        $sequence_7 = { c20c00 55 54 5d 53 8b5d08 }
            // n = 6, score = 300
            //   c20c00               | ret                 0xc
            //   55                   | push                ebp
            //   54                   | push                esp
            //   5d                   | pop                 ebp
            //   53                   | push                ebx
            //   8b5d08               | mov                 ebx, dword ptr [ebp + 8]

        $sequence_8 = { 8bc1 f7f5 85d2 7406 }
            // n = 4, score = 300
            //   8bc1                 | mov                 eax, edx
            //   f7f5                 | dec                 eax
            //   85d2                 | add                 ecx, 0x108
            //   7406                 | dec                 eax

        $sequence_9 = { a1???????? 09c0 7408 57 }
            // n = 4, score = 300
            //   a1????????           |                     
            //   09c0                 | or                  eax, eax
            //   7408                 | je                  0xa
            //   57                   | push                edi

        $sequence_10 = { 09f6 7405 83fe03 7526 }
            // n = 4, score = 300
            //   09f6                 | or                  esi, esi
            //   7405                 | je                  7
            //   83fe03               | cmp                 esi, 3
            //   7526                 | jne                 0x28

        $sequence_11 = { 09c0 750e 3905???????? 7e2c }
            // n = 4, score = 300
            //   09c0                 | or                  eax, eax
            //   750e                 | jne                 0x10
            //   3905????????         |                     
            //   7e2c                 | jle                 0x2e

        $sequence_12 = { 85c0 7405 e9???????? 448bc7 }
            // n = 4, score = 300
            //   85c0                 | dec                 ecx
            //   7405                 | arpl                word ptr [eax + 0x3c], ax
            //   e9????????           |                     
            //   448bc7               | inc                 edx

        $sequence_13 = { 50 5f 09ff 59 }
            // n = 4, score = 300
            //   50                   | push                eax
            //   5f                   | pop                 edi
            //   09ff                 | or                  edi, edi
            //   59                   | pop                 ecx

        $sequence_14 = { 7503 4c8b3e 488b0e 498bd7 e8???????? }
            // n = 5, score = 300
            //   7503                 | mov                 eax, 0x21590067
            //   4c8b3e               | dec                 ecx
            //   488b0e               | mov                 dword ptr [eax], esi
            //   498bd7               | inc                 esp
            //   e8????????           |                     

        $sequence_15 = { 750a b867005921 e9???????? 498930 448bc1 }
            // n = 5, score = 300
            //   750a                 | je                  0xc
            //   b867005921           | inc                 ebp
            //   e9????????           |                     
            //   498930               | cmp                 ecx, edx
            //   448bc1               | jne                 0xc

        $sequence_16 = { 7505 e8???????? 48 895c2458 48 }
            // n = 5, score = 200
            //   7505                 | jne                 7
            //   e8????????           |                     
            //   48                   | dec                 eax
            //   895c2458             | mov                 dword ptr [esp + 0x58], ebx
            //   48                   | dec                 eax

        $sequence_17 = { 7508 8d4811 e8???????? 48 8b0cdf 48 8b7c2448 }
            // n = 7, score = 200
            //   7508                 | jne                 0xa
            //   8d4811               | lea                 ecx, [eax + 0x11]
            //   e8????????           |                     
            //   48                   | dec                 eax
            //   8b0cdf               | mov                 ecx, dword ptr [edi + ebx*8]
            //   48                   | dec                 eax
            //   8b7c2448             | mov                 edi, dword ptr [esp + 0x48]

        $sequence_18 = { 7507 33c0 e9???????? 3bc6 4d 8bc6 0f845c010000 }
            // n = 7, score = 200
            //   7507                 | jne                 9
            //   33c0                 | xor                 eax, eax
            //   e9????????           |                     
            //   3bc6                 | cmp                 eax, esi
            //   4d                   | dec                 ebp
            //   8bc6                 | mov                 eax, esi
            //   0f845c010000         | je                  0x162

        $sequence_19 = { 7505 e9???????? 33c0 c3 48 }
            // n = 5, score = 200
            //   7505                 | jne                 7
            //   e9????????           |                     
            //   33c0                 | xor                 eax, eax
            //   c3                   | ret                 
            //   48                   | dec                 eax

        $sequence_20 = { 7507 33c9 e8???????? b801000000 48 8b5c2468 }
            // n = 6, score = 200
            //   7507                 | jne                 9
            //   33c9                 | xor                 ecx, ecx
            //   e8????????           |                     
            //   b801000000           | mov                 eax, 1
            //   48                   | dec                 eax
            //   8b5c2468             | mov                 ebx, dword ptr [esp + 0x68]

        $sequence_21 = { 750a 8d43ff e9???????? 33db }
            // n = 4, score = 200
            //   750a                 | jne                 0xc
            //   8d43ff               | lea                 eax, [ebx - 1]
            //   e9????????           |                     
            //   33db                 | xor                 ebx, ebx

        $sequence_22 = { 7508 e8???????? 48 8bf8 8b8bc8000000 }
            // n = 5, score = 200
            //   7508                 | jne                 0xa
            //   e8????????           |                     
            //   48                   | dec                 eax
            //   8bf8                 | mov                 edi, eax
            //   8b8bc8000000         | mov                 ecx, dword ptr [ebx + 0xc8]

        $sequence_23 = { 03c5 893d???????? 8905???????? e8???????? }
            // n = 4, score = 200
            //   03c5                 | add                 eax, ebp
            //   893d????????         |                     
            //   8905????????         |                     
            //   e8????????           |                     

    condition:
        7 of them and filesize < 1136640
}