rule win_usbferry_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.usbferry."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.usbferry"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 3c4c 750c 0fbec0 42 89442428 }
            // n = 5, score = 200
            //   3c4c                 | cmp                 al, 0x4c
            //   750c                 | jne                 0xe
            //   0fbec0               | movsx               eax, al
            //   42                   | inc                 edx
            //   89442428             | mov                 dword ptr [esp + 0x28], eax

        $sequence_1 = { 83c40c c785b0f7ffff44000000 c785dcf7ffff01000000 33d2 }
            // n = 4, score = 200
            //   83c40c               | add                 esp, 0xc
            //   c785b0f7ffff44000000     | mov    dword ptr [ebp - 0x850], 0x44
            //   c785dcf7ffff01000000     | mov    dword ptr [ebp - 0x824], 1
            //   33d2                 | xor                 edx, edx

        $sequence_2 = { ff5018 8bf0 83feff 7504 }
            // n = 4, score = 200
            //   ff5018               | call                dword ptr [eax + 0x18]
            //   8bf0                 | mov                 esi, eax
            //   83feff               | cmp                 esi, -1
            //   7504                 | jne                 6

        $sequence_3 = { 33c5 8945fc c645f463 c645f56d }
            // n = 4, score = 200
            //   33c5                 | xor                 eax, ebp
            //   8945fc               | mov                 dword ptr [ebp - 4], eax
            //   c645f463             | mov                 byte ptr [ebp - 0xc], 0x63
            //   c645f56d             | mov                 byte ptr [ebp - 0xb], 0x6d

        $sequence_4 = { 8b15???????? 8bcb ff7210 898214010000 }
            // n = 4, score = 200
            //   8b15????????         |                     
            //   8bcb                 | mov                 ecx, ebx
            //   ff7210               | push                dword ptr [edx + 0x10]
            //   898214010000         | mov                 dword ptr [edx + 0x114], eax

        $sequence_5 = { 88441de0 8a0439 88441de1 83c302 }
            // n = 4, score = 200
            //   88441de0             | mov                 byte ptr [ebp + ebx - 0x20], al
            //   8a0439               | mov                 al, byte ptr [ecx + edi]
            //   88441de1             | mov                 byte ptr [ebp + ebx - 0x1f], al
            //   83c302               | add                 ebx, 2

        $sequence_6 = { 83c40c 8d85c4e9ffff 50 a1???????? ff90a4000000 }
            // n = 5, score = 200
            //   83c40c               | add                 esp, 0xc
            //   8d85c4e9ffff         | lea                 eax, [ebp - 0x163c]
            //   50                   | push                eax
            //   a1????????           |                     
            //   ff90a4000000         | call                dword ptr [eax + 0xa4]

        $sequence_7 = { e8???????? 8b459c 807b0c67 750c 85c0 }
            // n = 5, score = 200
            //   e8????????           |                     
            //   8b459c               | mov                 eax, dword ptr [ebp - 0x64]
            //   807b0c67             | cmp                 byte ptr [ebx + 0xc], 0x67
            //   750c                 | jne                 0xe
            //   85c0                 | test                eax, eax

        $sequence_8 = { 8981c8000000 8b09 e8???????? 8b0d???????? }
            // n = 4, score = 200
            //   8981c8000000         | mov                 dword ptr [ecx + 0xc8], eax
            //   8b09                 | mov                 ecx, dword ptr [ecx]
            //   e8????????           |                     
            //   8b0d????????         |                     

        $sequence_9 = { 8b45cc e9???????? 8b55e0 52 ff15???????? 837d1401 0f8583000000 }
            // n = 7, score = 200
            //   8b45cc               | mov                 eax, dword ptr [ebp - 0x34]
            //   e9????????           |                     
            //   8b55e0               | mov                 edx, dword ptr [ebp - 0x20]
            //   52                   | push                edx
            //   ff15????????         |                     
            //   837d1401             | cmp                 dword ptr [ebp + 0x14], 1
            //   0f8583000000         | jne                 0x89

        $sequence_10 = { 50 e8???????? 83c40c 8b4d08 51 8d55f4 }
            // n = 6, score = 200
            //   50                   | push                eax
            //   e8????????           |                     
            //   83c40c               | add                 esp, 0xc
            //   8b4d08               | mov                 ecx, dword ptr [ebp + 8]
            //   51                   | push                ecx
            //   8d55f4               | lea                 edx, [ebp - 0xc]

        $sequence_11 = { 7547 6a04 8d4d1c 51 8b5514 52 }
            // n = 6, score = 200
            //   7547                 | jne                 0x49
            //   6a04                 | push                4
            //   8d4d1c               | lea                 ecx, [ebp + 0x1c]
            //   51                   | push                ecx
            //   8b5514               | mov                 edx, dword ptr [ebp + 0x14]
            //   52                   | push                edx

        $sequence_12 = { 50 8d8db0f7ffff 51 6a00 6a00 6800000008 6a00 }
            // n = 7, score = 200
            //   50                   | push                eax
            //   8d8db0f7ffff         | lea                 ecx, [ebp - 0x850]
            //   51                   | push                ecx
            //   6a00                 | push                0
            //   6a00                 | push                0
            //   6800000008           | push                0x8000000
            //   6a00                 | push                0

        $sequence_13 = { c645b45c c645b54d c645b669 c645b763 }
            // n = 4, score = 200
            //   c645b45c             | mov                 byte ptr [ebp - 0x4c], 0x5c
            //   c645b54d             | mov                 byte ptr [ebp - 0x4b], 0x4d
            //   c645b669             | mov                 byte ptr [ebp - 0x4a], 0x69
            //   c645b763             | mov                 byte ptr [ebp - 0x49], 0x63

        $sequence_14 = { 83c009 eb4d 84db 0f94c0 83c00b eb43 }
            // n = 6, score = 200
            //   83c009               | add                 eax, 9
            //   eb4d                 | jmp                 0x4f
            //   84db                 | test                bl, bl
            //   0f94c0               | sete                al
            //   83c00b               | add                 eax, 0xb
            //   eb43                 | jmp                 0x45

        $sequence_15 = { c3 3b0d???????? f27502 f2c3 f2e960030000 55 }
            // n = 6, score = 200
            //   c3                   | ret                 
            //   3b0d????????         |                     
            //   f27502               | bnd jne             5
            //   f2c3                 | bnd ret             
            //   f2e960030000         | bnd jmp             0x366
            //   55                   | push                ebp

    condition:
        7 of them and filesize < 638976
}