rule win_vanhelsing_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.vanhelsing."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.vanhelsing"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 5d c3 55 8bec 81ec9c000000 8b450c 53 }
            // n = 7, score = 100
            //   5d                   | pop                 ebp
            //   c3                   | ret                 
            //   55                   | push                ebp
            //   8bec                 | mov                 ebp, esp
            //   81ec9c000000         | sub                 esp, 0x9c
            //   8b450c               | mov                 eax, dword ptr [ebp + 0xc]
            //   53                   | push                ebx

        $sequence_1 = { 8b4518 0f1000 0f1145cc 0f104010 8b01 8b4904 8945ec }
            // n = 7, score = 100
            //   8b4518               | mov                 eax, dword ptr [ebp + 0x18]
            //   0f1000               | movups              xmm0, xmmword ptr [eax]
            //   0f1145cc             | movups              xmmword ptr [ebp - 0x34], xmm0
            //   0f104010             | movups              xmm0, xmmword ptr [eax + 0x10]
            //   8b01                 | mov                 eax, dword ptr [ecx]
            //   8b4904               | mov                 ecx, dword ptr [ecx + 4]
            //   8945ec               | mov                 dword ptr [ebp - 0x14], eax

        $sequence_2 = { 660f380035???????? 0f57c8 660f38000d???????? 0f29b520ffffff 0f294df0 0f28c6 660fd4c3 }
            // n = 7, score = 100
            //   660f380035????????     |     
            //   0f57c8               | xorps               xmm1, xmm0
            //   660f38000d????????     |     
            //   0f29b520ffffff       | movaps              xmmword ptr [ebp - 0xe0], xmm6
            //   0f294df0             | movaps              xmmword ptr [ebp - 0x10], xmm1
            //   0f28c6               | movaps              xmm0, xmm6
            //   660fd4c3             | paddq               xmm0, xmm3

        $sequence_3 = { 8b45e4 8b048598485600 8b4de0 f644082801 7515 e8???????? c70009000000 }
            // n = 7, score = 100
            //   8b45e4               | mov                 eax, dword ptr [ebp - 0x1c]
            //   8b048598485600       | mov                 eax, dword ptr [eax*4 + 0x564898]
            //   8b4de0               | mov                 ecx, dword ptr [ebp - 0x20]
            //   f644082801           | test                byte ptr [eax + ecx + 0x28], 1
            //   7515                 | jne                 0x17
            //   e8????????           |                     
            //   c70009000000         | mov                 dword ptr [eax], 9

        $sequence_4 = { 85c9 7410 8a80b4d44800 8806 46 41 897590 }
            // n = 7, score = 100
            //   85c9                 | test                ecx, ecx
            //   7410                 | je                  0x12
            //   8a80b4d44800         | mov                 al, byte ptr [eax + 0x48d4b4]
            //   8806                 | mov                 byte ptr [esi], al
            //   46                   | inc                 esi
            //   41                   | inc                 ecx
            //   897590               | mov                 dword ptr [ebp - 0x70], esi

        $sequence_5 = { 6a00 6a00 6800000008 ff15???????? 6a03 6a00 6a00 }
            // n = 7, score = 100
            //   6a00                 | push                0
            //   6a00                 | push                0
            //   6800000008           | push                0x8000000
            //   ff15????????         |                     
            //   6a03                 | push                3
            //   6a00                 | push                0
            //   6a00                 | push                0

        $sequence_6 = { 888570fbffff 240f 884580 8a06 888571fbffff 240f 884581 }
            // n = 7, score = 100
            //   888570fbffff         | mov                 byte ptr [ebp - 0x490], al
            //   240f                 | and                 al, 0xf
            //   884580               | mov                 byte ptr [ebp - 0x80], al
            //   8a06                 | mov                 al, byte ptr [esi]
            //   888571fbffff         | mov                 byte ptr [ebp - 0x48f], al
            //   240f                 | and                 al, 0xf
            //   884581               | mov                 byte ptr [ebp - 0x7f], al

        $sequence_7 = { 039d48ffffff 8b4dc8 138de8feffff 039df0feffff 898530ffffff 8bc3 138ddcfeffff }
            // n = 7, score = 100
            //   039d48ffffff         | add                 ebx, dword ptr [ebp - 0xb8]
            //   8b4dc8               | mov                 ecx, dword ptr [ebp - 0x38]
            //   138de8feffff         | adc                 ecx, dword ptr [ebp - 0x118]
            //   039df0feffff         | add                 ebx, dword ptr [ebp - 0x110]
            //   898530ffffff         | mov                 dword ptr [ebp - 0xd0], eax
            //   8bc3                 | mov                 eax, ebx
            //   138ddcfeffff         | adc                 ecx, dword ptr [ebp - 0x124]

        $sequence_8 = { 7f4f 8d4608 50 8d85d8fbffff 68???????? 50 e8???????? }
            // n = 7, score = 100
            //   7f4f                 | jg                  0x51
            //   8d4608               | lea                 eax, [esi + 8]
            //   50                   | push                eax
            //   8d85d8fbffff         | lea                 eax, [ebp - 0x428]
            //   68????????           |                     
            //   50                   | push                eax
            //   e8????????           |                     

        $sequence_9 = { 0fb6cb c1e803 83e107 0fb67405dc 8d8514ffffff d3ee 83e601 }
            // n = 7, score = 100
            //   0fb6cb               | movzx               ecx, bl
            //   c1e803               | shr                 eax, 3
            //   83e107               | and                 ecx, 7
            //   0fb67405dc           | movzx               esi, byte ptr [ebp + eax - 0x24]
            //   8d8514ffffff         | lea                 eax, [ebp - 0xec]
            //   d3ee                 | shr                 esi, cl
            //   83e601               | and                 esi, 1

    condition:
        7 of them and filesize < 2981888
}