rule win_vawtrak_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.vawtrak."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.vawtrak"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 6a01 ff35???????? 6a04 6a01 }
            // n = 4, score = 2700
            //   6a01                 | push                1
            //   ff35????????         |                     
            //   6a04                 | push                4
            //   6a01                 | push                1

        $sequence_1 = { 6a04 6a01 50 ff15???????? 85c0 }
            // n = 5, score = 2700
            //   6a04                 | push                4
            //   6a01                 | push                1
            //   50                   | push                eax
            //   ff15????????         |                     
            //   85c0                 | test                eax, eax

        $sequence_2 = { 6a00 6a00 e8???????? 50 ff15???????? }
            // n = 5, score = 2600
            //   6a00                 | mov                 dword ptr [edi], eax
            //   6a00                 | push                4
            //   e8????????           |                     
            //   50                   | push                1
            //   ff15????????         |                     

        $sequence_3 = { 85c0 7415 ff15???????? 50 ff15???????? 6aff }
            // n = 6, score = 2400
            //   85c0                 | push                eax
            //   7415                 | test                eax, eax
            //   ff15????????         |                     
            //   50                   | push                4
            //   ff15????????         |                     
            //   6aff                 | push                1

        $sequence_4 = { ba00ff0000 8bc1 23c2 3bc2 }
            // n = 4, score = 2400
            //   ba00ff0000           | push                1
            //   8bc1                 | push                eax
            //   23c2                 | test                eax, eax
            //   3bc2                 | push                4

        $sequence_5 = { 69d26d4ec641 81c239300000 2ac2 8801 }
            // n = 4, score = 2200
            //   69d26d4ec641         | push                eax
            //   81c239300000         | push                1
            //   2ac2                 | push                4
            //   8801                 | push                1

        $sequence_6 = { e8???????? eb09 a804 7405 e8???????? 803d????????00 }
            // n = 6, score = 2200
            //   e8????????           |                     
            //   eb09                 | push                1
            //   a804                 | push                4
            //   7405                 | push                1
            //   e8????????           |                     
            //   803d????????00       |                     

        $sequence_7 = { 6a08 68???????? 56 ffd7 85c0 }
            // n = 5, score = 2100
            //   6a08                 | push                8
            //   68????????           |                     
            //   56                   | push                esi
            //   ffd7                 | call                edi
            //   85c0                 | test                eax, eax

        $sequence_8 = { ff15???????? a3???????? 85c0 74e7 }
            // n = 4, score = 2100
            //   ff15????????         |                     
            //   a3????????           |                     
            //   85c0                 | test                eax, eax
            //   74e7                 | je                  0xffffffe9

        $sequence_9 = { 7528 68???????? ff15???????? 85c0 7504 33c0 }
            // n = 6, score = 2100
            //   7528                 | jne                 0x2a
            //   68????????           |                     
            //   ff15????????         |                     
            //   85c0                 | test                eax, eax
            //   7504                 | jne                 6
            //   33c0                 | xor                 eax, eax

        $sequence_10 = { 59 57 8bf0 ff15???????? 8bc6 }
            // n = 5, score = 2000
            //   59                   | pop                 ecx
            //   57                   | push                edi
            //   8bf0                 | mov                 esi, eax
            //   ff15????????         |                     
            //   8bc6                 | mov                 eax, esi

        $sequence_11 = { e8???????? 33d2 b9ff3f0000 f7f1 }
            // n = 4, score = 2000
            //   e8????????           |                     
            //   33d2                 | xor                 edx, edx
            //   b9ff3f0000           | mov                 ecx, 0x3fff
            //   f7f1                 | div                 ecx

        $sequence_12 = { 8bc6 8703 3bc6 74f8 }
            // n = 4, score = 1900
            //   8bc6                 | mov                 eax, esi
            //   8703                 | xchg                dword ptr [ebx], eax
            //   3bc6                 | cmp                 eax, esi
            //   74f8                 | je                  0xfffffffa

        $sequence_13 = { 8d429f 3c0f 7705 80ea61 eb0a 8d42bf 3c0f }
            // n = 7, score = 1700
            //   8d429f               | push                1
            //   3c0f                 | push                eax
            //   7705                 | push                1
            //   80ea61               | push                4
            //   eb0a                 | push                1
            //   8d42bf               | push                eax
            //   3c0f                 | push                4

        $sequence_14 = { ff7510 ff750c ff7508 e8???????? 83c40c 8d45fc 50 }
            // n = 7, score = 1600
            //   ff7510               | push                dword ptr [ebp + 0x10]
            //   ff750c               | push                dword ptr [ebp + 0xc]
            //   ff7508               | push                dword ptr [ebp + 8]
            //   e8????????           |                     
            //   83c40c               | add                 esp, 0xc
            //   8d45fc               | lea                 eax, [ebp - 4]
            //   50                   | push                eax

        $sequence_15 = { c1e910 e9???????? 8ac1 c1e904 c0e004 }
            // n = 5, score = 1200
            //   c1e910               | shr                 ecx, 0x10
            //   e9????????           |                     
            //   8ac1                 | mov                 al, cl
            //   c1e904               | shr                 ecx, 4
            //   c0e004               | shl                 al, 4

        $sequence_16 = { 8ac8 240f 80e1f0 80c110 }
            // n = 4, score = 900
            //   8ac8                 | mov                 cl, al
            //   240f                 | and                 al, 0xf
            //   80e1f0               | and                 cl, 0xf0
            //   80c110               | add                 cl, 0x10

        $sequence_17 = { 3c41 7c11 3c46 7f0d }
            // n = 4, score = 800
            //   3c41                 | cmp                 al, 0x41
            //   7c11                 | jl                  0x13
            //   3c46                 | cmp                 al, 0x46
            //   7f0d                 | jg                  0xf

        $sequence_18 = { 03ea 03ff 03db 4883fe1e }
            // n = 4, score = 700
            //   03ea                 | mov                 edx, esi
            //   03ff                 | dec                 eax
            //   03db                 | mov                 ecx, ebp
            //   4883fe1e             | dec                 eax

        $sequence_19 = { 4533c0 488bd6 488bcd 48897c2428 4889442420 ff15???????? }
            // n = 6, score = 700
            //   4533c0               | dec                 esp
            //   488bd6               | lea                 eax, [esp + 0x30]
            //   488bcd               | inc                 ebp
            //   48897c2428           | xor                 ecx, ecx
            //   4889442420           | xor                 edx, edx
            //   ff15????????         |                     

        $sequence_20 = { 400f95c7 4533c9 4533c0 ff15???????? }
            // n = 4, score = 700
            //   400f95c7             | mov                 dword ptr [esp + 0x28], edi
            //   4533c9               | dec                 eax
            //   4533c0               | mov                 dword ptr [esp + 0x20], eax
            //   ff15????????         |                     

        $sequence_21 = { 488364242000 4c8d442430 4533c9 33d2 }
            // n = 4, score = 700
            //   488364242000         | dec                 eax
            //   4c8d442430           | and                 dword ptr [esp + 0x20], 0
            //   4533c9               | dec                 esp
            //   33d2                 | lea                 eax, [esp + 0x30]

    condition:
        7 of them and filesize < 1027072
}