rule win_veiledsignal_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.veiledsignal."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.veiledsignal"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { c5f92f25???????? 0f82b1000000 48c1e82c c5e9eb15???????? c5f1eb0d???????? 4c8d0d66850000 }
            // n = 6, score = 100
            //   c5f92f25????????     |                     
            //   0f82b1000000         | dec                 eax
            //   48c1e82c             | lea                 edx, [0x48be5]
            //   c5e9eb15????????     |                     
            //   c5f1eb0d????????     |                     
            //   4c8d0d66850000       | inc                 ebp

        $sequence_1 = { e9???????? e8???????? e9???????? 488d0514380400 }
            // n = 4, score = 100
            //   e9????????           |                     
            //   e8????????           |                     
            //   e9????????           |                     
            //   488d0514380400       | ret                 

        $sequence_2 = { 0fb6552f 4c8d4d2f 4533c0 418d4814 ffd0 }
            // n = 5, score = 100
            //   0fb6552f             | dec                 eax
            //   4c8d4d2f             | lea                 edx, [0x6ce2]
            //   4533c0               | dec                 esp
            //   418d4814             | lea                 ecx, [0x82fd]
            //   ffd0                 | dec                 eax

        $sequence_3 = { 488d0db99a0400 e8???????? 488d0dc59a0400 e8???????? }
            // n = 4, score = 100
            //   488d0db99a0400       | dec                 esp
            //   e8????????           |                     
            //   488d0dc59a0400       | lea                 ecx, [ebp - 0x11]
            //   e8????????           |                     

        $sequence_4 = { 7ec4 83c8ff eb0b 4803f6 418b84f7a8140100 85c0 }
            // n = 6, score = 100
            //   7ec4                 | sub                 esp, 0x20
            //   83c8ff               | mov                 edi, ecx
            //   eb0b                 | dec                 esp
            //   4803f6               | lea                 edi, [0xffffcc63]
            //   418b84f7a8140100     | dec                 ebp
            //   85c0                 | mov                 esp, ecx

        $sequence_5 = { e8???????? 4881c458010000 c3 8d8146b8ffff 83f801 }
            // n = 5, score = 100
            //   e8????????           |                     
            //   4881c458010000       | lea                 eax, [0x439c7]
            //   c3                   | dec                 edx
            //   8d8146b8ffff         | mov                 eax, dword ptr [eax + ebp*8]
            //   83f801               | dec                 eax

        $sequence_6 = { e8???????? 488b8890000000 48399938010000 7516 488d05c7390400 4a8b04e8 }
            // n = 6, score = 100
            //   e8????????           |                     
            //   488b8890000000       | dec                 eax
            //   48399938010000       | lea                 ecx, [ebx + ebx*4]
            //   7516                 | dec                 eax
            //   488d05c7390400       | sub                 esp, 0x20
            //   4a8b04e8             | mov                 ebx, ecx

        $sequence_7 = { ff15???????? e9???????? 8b7c2428 488bcb ff15???????? 85ff 0f844bffffff }
            // n = 7, score = 100
            //   ff15????????         |                     
            //   e9????????           |                     
            //   8b7c2428             | jmp                 0x296
            //   488bcb               | dec                 ecx
            //   ff15????????         |                     
            //   85ff                 | mov                 ebx, dword ptr [esi + esi*8 + 0x4e550]
            //   0f844bffffff         | dec                 eax

        $sequence_8 = { 83f8ff 7425 488d1586b10400 8bc8 e8???????? 85c0 740e }
            // n = 7, score = 100
            //   83f8ff               | mov                 eax, dword ptr [esp + 0x28]
            //   7425                 | cmp                 eax, 3
            //   488d1586b10400       | jne                 0x666
            //   8bc8                 | dec                 eax
            //   e8????????           |                     
            //   85c0                 | add                 esp, 0x158
            //   740e                 | ret                 

        $sequence_9 = { 428844f13e 4b8b84e010e70400 42804cf03d04 38558f e9???????? ff15???????? 894597 }
            // n = 7, score = 100
            //   428844f13e           | inc                 ebx
            //   4b8b84e010e70400     | dec                 eax
            //   42804cf03d04         | sub                 ebp, 1
            //   38558f               | dec                 eax
            //   e9????????           |                     
            //   ff15????????         |                     
            //   894597               | lea                 edi, [0x48fe0]

    condition:
        7 of them and filesize < 667648
}