rule win_veletrix_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.veletrix."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.veletrix"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 7408 488bc2 e9???????? 4d3bc4 0f84d9000000 8b7500 498b9cf6c0920100 }
            // n = 7, score = 100
            //   7408                 | dec                 eax
            //   488bc2               | test                esi, esi
            //   e9????????           |                     
            //   4d3bc4               | jle                 0x12a1
            //   0f84d9000000         | dec                 ebx
            //   8b7500               | mov                 eax, dword ptr [edi + 0x19700]
            //   498b9cf6c0920100     | dec                 esp

        $sequence_1 = { f20f59ee f20f5ce9 f2410f1004c1 488d1576860000 f20f1014c2 }
            // n = 5, score = 100
            //   f20f59ee             | lea                 edx, [0x902d]
            //   f20f5ce9             | dec                 eax
            //   f2410f1004c1         | mov                 ebx, edx
            //   488d1576860000       | dec                 esp
            //   f20f1014c2           | lea                 ecx, [0xaf7c]

        $sequence_2 = { 85c0 742a 488bc5 4c8d05f5250100 488bcd 48c1f906 83e03f }
            // n = 7, score = 100
            //   85c0                 | lea                 eax, [0x125f5]
            //   742a                 | dec                 eax
            //   488bc5               | mov                 ecx, ebp
            //   4c8d05f5250100       | dec                 eax
            //   488bcd               | cmp                 ecx, -3
            //   48c1f906             | ja                  0x69f
            //   83e03f               | dec                 eax

        $sequence_3 = { e8???????? 33db 8bf8 85c0 0f8453020000 4c8d2d461a0100 448bf3 }
            // n = 7, score = 100
            //   e8????????           |                     
            //   33db                 | dec                 eax
            //   8bf8                 | add                 esp, 0x20
            //   85c0                 | dec                 esp
            //   0f8453020000         | lea                 eax, [0x97cb]
            //   4c8d2d461a0100       | dec                 eax
            //   448bf3               | lea                 edx, [0x97cc]

        $sequence_4 = { 4c8d0d057c0000 c5f359c1 c5fb101d???????? c5fb102d???????? c4e2f1a91d???????? c4e2f1a92d???????? f20f10e0 }
            // n = 7, score = 100
            //   4c8d0d057c0000       | sub                 esp, 0x20
            //   c5f359c1             | dec                 eax
            //   c5fb101d????????     |                     
            //   c5fb102d????????     |                     
            //   c4e2f1a91d????????     |     
            //   c4e2f1a92d????????     |     
            //   f20f10e0             | lea                 ebx, [0x1492b]

        $sequence_5 = { c7459856697274 488bcb c7459c75616c50 4c8be0 c745a0726f7465 }
            // n = 5, score = 100
            //   c7459856697274       | dec                 eax
            //   488bcb               | mov                 eax, dword ptr [ecx + 0xf8]
            //   c7459c75616c50       | dec                 eax
            //   4c8be0               | mov                 ebx, ecx
            //   c745a0726f7465       | dec                 eax

        $sequence_6 = { e8???????? 488b8f90000000 483b0d???????? 7417 488d05243d0100 }
            // n = 5, score = 100
            //   e8????????           |                     
            //   488b8f90000000       | test                eax, eax
            //   483b0d????????       |                     
            //   7417                 | dec                 eax
            //   488d05243d0100       | mov                 ecx, eax

        $sequence_7 = { 4c8d4c2448 488b4f10 41b840000000 ff542430 8b4f04 ba00080000 }
            // n = 6, score = 100
            //   4c8d4c2448           | xor                 ebx, ebx
            //   488b4f10             | dec                 ecx
            //   41b840000000         | mov                 edx, ebx
            //   ff542430             | dec                 esp
            //   8b4f04               | lea                 eax, [0xffff673f]
            //   ba00080000           | dec                 ebx

        $sequence_8 = { 48894df7 488945ef 488d0d8668ffff 83e03f 458be9 4d03e8 4c8945df }
            // n = 7, score = 100
            //   48894df7             | mov                 dword ptr [esp + 0x38], eax
            //   488945ef             | rep stosd           dword ptr es:[edi], eax
            //   488d0d8668ffff       | dec                 eax
            //   83e03f               | lea                 edi, [0x11b4c]
            //   458be9               | dec                 eax
            //   4d03e8               | sub                 edi, esi
            //   4c8945df             | mov                 al, byte ptr [edi + ebx]

        $sequence_9 = { 4c896daf 49c1fc06 4c8d34c0 4a8b84e100970100 4a8b44f028 }
            // n = 5, score = 100
            //   4c896daf             | inc                 ecx
            //   49c1fc06             | mov                 eax, dword ptr [edi + esi*8 + 0x11288]
            //   4c8d34c0             | test                eax, eax
            //   4a8b84e100970100     | js                  0x60
            //   4a8b44f028           | cmp                 eax, 0xe4

    condition:
        7 of them and filesize < 234496
}