rule win_velso_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.velso."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.velso"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 83f8ff 0f9445a8 e8???????? 83f8ff 0f94c0 3845a8 7506 }
            // n = 7, score = 200
            //   83f8ff               | cmp                 eax, -1
            //   0f9445a8             | sete                byte ptr [ebp - 0x58]
            //   e8????????           |                     
            //   83f8ff               | cmp                 eax, -1
            //   0f94c0               | sete                al
            //   3845a8               | cmp                 byte ptr [ebp - 0x58], al
            //   7506                 | jne                 8

        $sequence_1 = { 0f84fb020000 8b4590 8945a0 8d45f3 c744240400000000 c7042400000000 89442408 }
            // n = 7, score = 200
            //   0f84fb020000         | je                  0x301
            //   8b4590               | mov                 eax, dword ptr [ebp - 0x70]
            //   8945a0               | mov                 dword ptr [ebp - 0x60], eax
            //   8d45f3               | lea                 eax, [ebp - 0xd]
            //   c744240400000000     | mov                 dword ptr [esp + 4], 0
            //   c7042400000000       | mov                 dword ptr [esp], 0
            //   89442408             | mov                 dword ptr [esp + 8], eax

        $sequence_2 = { 0f49c2 8944242c 8b842484000000 83c801 89442434 8b7c2430 8b470c }
            // n = 7, score = 200
            //   0f49c2               | cmovns              eax, edx
            //   8944242c             | mov                 dword ptr [esp + 0x2c], eax
            //   8b842484000000       | mov                 eax, dword ptr [esp + 0x84]
            //   83c801               | or                  eax, 1
            //   89442434             | mov                 dword ptr [esp + 0x34], eax
            //   8b7c2430             | mov                 edi, dword ptr [esp + 0x30]
            //   8b470c               | mov                 eax, dword ptr [edi + 0xc]

        $sequence_3 = { e8???????? a3???????? e9???????? c7042480000000 e8???????? 85c0 89c6 }
            // n = 7, score = 200
            //   e8????????           |                     
            //   a3????????           |                     
            //   e9????????           |                     
            //   c7042480000000       | mov                 dword ptr [esp], 0x80
            //   e8????????           |                     
            //   85c0                 | test                eax, eax
            //   89c6                 | mov                 esi, eax

        $sequence_4 = { c70424???????? c744242001000000 e8???????? a1???????? c7442404???????? c70424???????? 89442414 }
            // n = 7, score = 200
            //   c70424????????       |                     
            //   c744242001000000     | mov                 dword ptr [esp + 0x20], 1
            //   e8????????           |                     
            //   a1????????           |                     
            //   c7442404????????     |                     
            //   c70424????????       |                     
            //   89442414             | mov                 dword ptr [esp + 0x14], eax

        $sequence_5 = { e8???????? 83ec04 807de000 0f84f0010000 8b4508 8b7d08 8b00 }
            // n = 7, score = 200
            //   e8????????           |                     
            //   83ec04               | sub                 esp, 4
            //   807de000             | cmp                 byte ptr [ebp - 0x20], 0
            //   0f84f0010000         | je                  0x1f6
            //   8b4508               | mov                 eax, dword ptr [ebp + 8]
            //   8b7d08               | mov                 edi, dword ptr [ebp + 8]
            //   8b00                 | mov                 eax, dword ptr [eax]

        $sequence_6 = { 741e 83e801 742a 83e801 0f84c8000000 83e801 0f849e000000 }
            // n = 7, score = 200
            //   741e                 | je                  0x20
            //   83e801               | sub                 eax, 1
            //   742a                 | je                  0x2c
            //   83e801               | sub                 eax, 1
            //   0f84c8000000         | je                  0xce
            //   83e801               | sub                 eax, 1
            //   0f849e000000         | je                  0xa4

        $sequence_7 = { c3 85c0 743d 890424 e8???????? e9???????? e8???????? }
            // n = 7, score = 200
            //   c3                   | ret                 
            //   85c0                 | test                eax, eax
            //   743d                 | je                  0x3f
            //   890424               | mov                 dword ptr [esp], eax
            //   e8????????           |                     
            //   e9????????           |                     
            //   e8????????           |                     

        $sequence_8 = { 8b957cffffff 89542408 8b9d78ffffff 890424 895c2404 e8???????? 8945ac }
            // n = 7, score = 200
            //   8b957cffffff         | mov                 edx, dword ptr [ebp - 0x84]
            //   89542408             | mov                 dword ptr [esp + 8], edx
            //   8b9d78ffffff         | mov                 ebx, dword ptr [ebp - 0x88]
            //   890424               | mov                 dword ptr [esp], eax
            //   895c2404             | mov                 dword ptr [esp + 4], ebx
            //   e8????????           |                     
            //   8945ac               | mov                 dword ptr [ebp - 0x54], eax

        $sequence_9 = { 0f8487020000 66837dd4ff c745e400000000 0f94c0 31ff 31f6 38d0 }
            // n = 7, score = 200
            //   0f8487020000         | je                  0x28d
            //   66837dd4ff           | cmp                 word ptr [ebp - 0x2c], -1
            //   c745e400000000       | mov                 dword ptr [ebp - 0x1c], 0
            //   0f94c0               | sete                al
            //   31ff                 | xor                 edi, edi
            //   31f6                 | xor                 esi, esi
            //   38d0                 | cmp                 al, dl

    condition:
        7 of them and filesize < 1736704
}