rule win_venomloader_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.venomloader."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.venomloader"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 48894d10 895518 4c894520 837d1803 7758 837d1802 }
            // n = 6, score = 100
            //   48894d10             | dec                 eax
            //   895518               | sub                 esp, 0x20
            //   4c894520             | dec                 eax
            //   837d1803             | lea                 eax, [0x560d4]
            //   7758                 | dec                 eax
            //   837d1802             | mov                 dword ptr [ecx], eax

        $sequence_1 = { 488d1503ad0a00 c70105000000 48895108 c3 488d15f1ac0a00 c7010b000000 48895108 }
            // n = 7, score = 100
            //   488d1503ad0a00       | mov                 ecx, ebx
            //   c70105000000         | dec                 eax
            //   48895108             | add                 esp, 0x20
            //   c3                   | dec                 eax
            //   488d15f1ac0a00       | lea                 eax, [0x41ab4]
            //   c7010b000000         | dec                 eax
            //   48895108             | mov                 dword ptr [ecx], eax

        $sequence_2 = { 53 4883ec20 4889cb 488d0d91b90000 e8???????? 4889c2 488b03 }
            // n = 7, score = 100
            //   53                   | dec                 eax
            //   4883ec20             | lea                 ecx, [0x86745]
            //   4889cb               | dec                 ebp
            //   488d0d91b90000       | mov                 edi, esp
            //   e8????????           |                     
            //   4889c2               | dec                 eax
            //   488b03               | mov                 dword ptr [esp + 0x40], edi

        $sequence_3 = { 4883e918 4c89e2 e8???????? eb88 488d0d07f10400 e8???????? 4889c3 }
            // n = 7, score = 100
            //   4883e918             | dec                 eax
            //   4c89e2               | add                 esp, 0x348
            //   e8????????           |                     
            //   eb88                 | pop                 ebx
            //   488d0d07f10400       | pop                 ebp
            //   e8????????           |                     
            //   4889c3               | ret                 

        $sequence_4 = { 4889742468 0f11742450 e8???????? 488b442470 488b542478 488b9c2488000000 4889542478 }
            // n = 7, score = 100
            //   4889742468           | cmp                 byte ptr [esi], 0x43
            //   0f11742450           | jne                 0x3b6
            //   e8????????           |                     
            //   488b442470           | cmp                 byte ptr [esi + 1], 0
            //   488b542478           | dec                 eax
            //   488b9c2488000000     | mov                 dword ptr [ecx], eax
            //   4889542478           | dec                 eax

        $sequence_5 = { 48c1ea20 83e201 4c39d9 72df 4983eb01 4d29eb 4983e3fc }
            // n = 7, score = 100
            //   48c1ea20             | dec                 eax
            //   83e201               | cmp                 eax, edx
            //   4c39d9               | jne                 0x1bc6
            //   72df                 | dec                 eax
            //   4983eb01             | mov                 eax, dword ptr [esi + 0x10]
            //   4d29eb               | movzx               eax, word ptr [eax + 0x4a]
            //   4983e3fc             | mov                 word ptr [ebx + 0x4a], ax

        $sequence_6 = { 84d2 0f84b8000000 384549 7452 384548 744d 38c1 }
            // n = 7, score = 100
            //   84d2                 | jne                 0xfae
            //   0f84b8000000         | inc                 ecx
            //   384549               | mov                 dword ptr [esp], 1
            //   7452                 | mov                 eax, 5
            //   384548               | dec                 eax
            //   744d                 | add                 esp, 0x48
            //   38c1                 | pop                 ebx

        $sequence_7 = { 4989d0 488d1540910c00 4889c1 e8???????? 488d85d0040000 488d95f0040000 4c8d05d3910c00 }
            // n = 7, score = 100
            //   4989d0               | dec                 eax
            //   488d1540910c00       | mov                 dword ptr [ecx], eax
            //   4889c1               | dec                 eax
            //   e8????????           |                     
            //   488d85d0040000       | lea                 ecx, [ecx + 0x18]
            //   488d95f0040000       | dec                 eax
            //   4c8d05d3910c00       | mov                 dword ptr [ecx + 0xc8], eax

        $sequence_8 = { 4c89e2 4889e9 66897c2468 e8???????? 89c7 84c0 0f85fd050000 }
            // n = 7, score = 100
            //   4c89e2               | lea                 eax, [0x2cc7a]
            //   4889e9               | mov                 dword ptr [ebx + 0x40], 0x18
            //   66897c2468           | dec                 eax
            //   e8????????           |                     
            //   89c7                 | mov                 dword ptr [ebx], eax
            //   84c0                 | dec                 eax
            //   0f85fd050000         | mov                 dword ptr [ecx - 0x18], 0

        $sequence_9 = { 48895e18 8b08 85c9 0f853e010000 83430801 488d05e02d0b00 48897e20 }
            // n = 7, score = 100
            //   48895e18             | lea                 eax, [0x2b375]
            //   8b08                 | dec                 eax
            //   85c9                 | mov                 dword ptr [ebx], eax
            //   0f853e010000         | cmp                 byte ptr [esi], 0x43
            //   83430801             | jne                 0x271
            //   488d05e02d0b00       | cmp                 byte ptr [esi + 1], 0
            //   48897e20             | dec                 eax

    condition:
        7 of them and filesize < 2592768
}