rule win_vhd_ransomware_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.vhd_ransomware."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.vhd_ransomware"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { f3ab 8b8530030000 8902 33c0 89a54cf3ffff 398530030000 7e1b }
            // n = 7, score = 100
            //   f3ab                 | rep stosd           dword ptr es:[edi], eax
            //   8b8530030000         | mov                 eax, dword ptr [ebp + 0x330]
            //   8902                 | mov                 dword ptr [edx], eax
            //   33c0                 | xor                 eax, eax
            //   89a54cf3ffff         | mov                 dword ptr [ebp - 0xcb4], esp
            //   398530030000         | cmp                 dword ptr [ebp + 0x330], eax
            //   7e1b                 | jle                 0x1d

        $sequence_1 = { e8???????? 81c44c060000 80bd7ff6ffff00 7424 8bb574f6ffff 8d8dd0fcffff }
            // n = 6, score = 100
            //   e8????????           |                     
            //   81c44c060000         | add                 esp, 0x64c
            //   80bd7ff6ffff00       | cmp                 byte ptr [ebp - 0x981], 0
            //   7424                 | je                  0x26
            //   8bb574f6ffff         | mov                 esi, dword ptr [ebp - 0x98c]
            //   8d8dd0fcffff         | lea                 ecx, [ebp - 0x330]

        $sequence_2 = { 33d3 8b5df4 0fb69b98744100 0fb61c9d9b854100 33d3 8b5df8 }
            // n = 6, score = 100
            //   33d3                 | xor                 edx, ebx
            //   8b5df4               | mov                 ebx, dword ptr [ebp - 0xc]
            //   0fb69b98744100       | movzx               ebx, byte ptr [ebx + 0x417498]
            //   0fb61c9d9b854100     | movzx               ebx, byte ptr [ebx*4 + 0x41859b]
            //   33d3                 | xor                 edx, ebx
            //   8b5df8               | mov                 ebx, dword ptr [ebp - 8]

        $sequence_3 = { 785b 8d74ba04 8b4e04 33c0 33db 0306 13cb }
            // n = 7, score = 100
            //   785b                 | js                  0x5d
            //   8d74ba04             | lea                 esi, [edx + edi*4 + 4]
            //   8b4e04               | mov                 ecx, dword ptr [esi + 4]
            //   33c0                 | xor                 eax, eax
            //   33db                 | xor                 ebx, ebx
            //   0306                 | add                 eax, dword ptr [esi]
            //   13cb                 | adc                 ecx, ebx

        $sequence_4 = { 83c8ff 5d c3 6a08 68???????? e8???????? e8???????? }
            // n = 7, score = 100
            //   83c8ff               | or                  eax, 0xffffffff
            //   5d                   | pop                 ebp
            //   c3                   | ret                 
            //   6a08                 | push                8
            //   68????????           |                     
            //   e8????????           |                     
            //   e8????????           |                     

        $sequence_5 = { 33c0 b9c8000000 8d7a04 f3ab 8b8dd0fcffff 890a 85c9 }
            // n = 7, score = 100
            //   33c0                 | xor                 eax, eax
            //   b9c8000000           | mov                 ecx, 0xc8
            //   8d7a04               | lea                 edi, [edx + 4]
            //   f3ab                 | rep stosd           dword ptr es:[edi], eax
            //   8b8dd0fcffff         | mov                 ecx, dword ptr [ebp - 0x330]
            //   890a                 | mov                 dword ptr [edx], ecx
            //   85c9                 | test                ecx, ecx

        $sequence_6 = { 8945cc bf40000000 b8???????? 8d75e0 895dc8 c745f40f000000 c745f000000000 }
            // n = 7, score = 100
            //   8945cc               | mov                 dword ptr [ebp - 0x34], eax
            //   bf40000000           | mov                 edi, 0x40
            //   b8????????           |                     
            //   8d75e0               | lea                 esi, [ebp - 0x20]
            //   895dc8               | mov                 dword ptr [ebp - 0x38], ebx
            //   c745f40f000000       | mov                 dword ptr [ebp - 0xc], 0xf
            //   c745f000000000       | mov                 dword ptr [ebp - 0x10], 0

        $sequence_7 = { 8bd8 899d28b4ffff 83fbff 0f8430010000 8b4510 8b4d0c 50 }
            // n = 7, score = 100
            //   8bd8                 | mov                 ebx, eax
            //   899d28b4ffff         | mov                 dword ptr [ebp - 0x4bd8], ebx
            //   83fbff               | cmp                 ebx, -1
            //   0f8430010000         | je                  0x136
            //   8b4510               | mov                 eax, dword ptr [ebp + 0x10]
            //   8b4d0c               | mov                 ecx, dword ptr [ebp + 0xc]
            //   50                   | push                eax

        $sequence_8 = { 398530030000 7e14 8d4a04 8bb48534030000 8931 40 83c104 }
            // n = 7, score = 100
            //   398530030000         | cmp                 dword ptr [ebp + 0x330], eax
            //   7e14                 | jle                 0x16
            //   8d4a04               | lea                 ecx, [edx + 4]
            //   8bb48534030000       | mov                 esi, dword ptr [ebp + eax*4 + 0x334]
            //   8931                 | mov                 dword ptr [ecx], esi
            //   40                   | inc                 eax
            //   83c104               | add                 ecx, 4

        $sequence_9 = { 03c2 13ce 33d2 52 8b95f4efffff 52 51 }
            // n = 7, score = 100
            //   03c2                 | add                 eax, edx
            //   13ce                 | adc                 ecx, esi
            //   33d2                 | xor                 edx, edx
            //   52                   | push                edx
            //   8b95f4efffff         | mov                 edx, dword ptr [ebp - 0x100c]
            //   52                   | push                edx
            //   51                   | push                ecx

    condition:
        7 of them and filesize < 275456
}