rule win_victorygate_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.victorygate."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.victorygate"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { e8???????? 8bd0 c645fc08 8d8d68ffffff e8???????? c645fc07 }
            // n = 6, score = 100
            //   e8????????           |                     
            //   8bd0                 | mov                 edx, eax
            //   c645fc08             | mov                 byte ptr [ebp - 4], 8
            //   8d8d68ffffff         | lea                 ecx, [ebp - 0x98]
            //   e8????????           |                     
            //   c645fc07             | mov                 byte ptr [ebp - 4], 7

        $sequence_1 = { ff75f8 8d8684010000 6a45 50 ff15???????? 85c0 }
            // n = 6, score = 100
            //   ff75f8               | push                dword ptr [ebp - 8]
            //   8d8684010000         | lea                 eax, [esi + 0x184]
            //   6a45                 | push                0x45
            //   50                   | push                eax
            //   ff15????????         |                     
            //   85c0                 | test                eax, eax

        $sequence_2 = { c645dc00 33d2 660fd645e4 8d4ddc e8???????? 68???????? 8d4dc4 }
            // n = 7, score = 100
            //   c645dc00             | mov                 byte ptr [ebp - 0x24], 0
            //   33d2                 | xor                 edx, edx
            //   660fd645e4           | movq                qword ptr [ebp - 0x1c], xmm0
            //   8d4ddc               | lea                 ecx, [ebp - 0x24]
            //   e8????????           |                     
            //   68????????           |                     
            //   8d4dc4               | lea                 ecx, [ebp - 0x3c]

        $sequence_3 = { ff36 8bcf 50 e8???????? 8b4e08 83c334 83c634 }
            // n = 7, score = 100
            //   ff36                 | push                dword ptr [esi]
            //   8bcf                 | mov                 ecx, edi
            //   50                   | push                eax
            //   e8????????           |                     
            //   8b4e08               | mov                 ecx, dword ptr [esi + 8]
            //   83c334               | add                 ebx, 0x34
            //   83c634               | add                 esi, 0x34

        $sequence_4 = { 8d4dc4 c645fc10 e8???????? 0fb64ddc 8bf8 8b45e4 8a17 }
            // n = 7, score = 100
            //   8d4dc4               | lea                 ecx, [ebp - 0x3c]
            //   c645fc10             | mov                 byte ptr [ebp - 4], 0x10
            //   e8????????           |                     
            //   0fb64ddc             | movzx               ecx, byte ptr [ebp - 0x24]
            //   8bf8                 | mov                 edi, eax
            //   8b45e4               | mov                 eax, dword ptr [ebp - 0x1c]
            //   8a17                 | mov                 dl, byte ptr [edi]

        $sequence_5 = { 56 682a2b0000 ffd0 85c0 7419 50 e8???????? }
            // n = 7, score = 100
            //   56                   | push                esi
            //   682a2b0000           | push                0x2b2a
            //   ffd0                 | call                eax
            //   85c0                 | test                eax, eax
            //   7419                 | je                  0x1b
            //   50                   | push                eax
            //   e8????????           |                     

        $sequence_6 = { 50 ff7120 ff7128 e8???????? 83c410 85c0 7415 }
            // n = 7, score = 100
            //   50                   | push                eax
            //   ff7120               | push                dword ptr [ecx + 0x20]
            //   ff7128               | push                dword ptr [ecx + 0x28]
            //   e8????????           |                     
            //   83c410               | add                 esp, 0x10
            //   85c0                 | test                eax, eax
            //   7415                 | je                  0x17

        $sequence_7 = { 8b45f0 8d0c90 8b01 85c0 740d 395804 7408 }
            // n = 7, score = 100
            //   8b45f0               | mov                 eax, dword ptr [ebp - 0x10]
            //   8d0c90               | lea                 ecx, [eax + edx*4]
            //   8b01                 | mov                 eax, dword ptr [ecx]
            //   85c0                 | test                eax, eax
            //   740d                 | je                  0xf
            //   395804               | cmp                 dword ptr [eax + 4], ebx
            //   7408                 | je                  0xa

        $sequence_8 = { e8???????? 68???????? 8d4dc4 c645fc07 e8???????? 0fb64ddc 8bf8 }
            // n = 7, score = 100
            //   e8????????           |                     
            //   68????????           |                     
            //   8d4dc4               | lea                 ecx, [ebp - 0x3c]
            //   c645fc07             | mov                 byte ptr [ebp - 4], 7
            //   e8????????           |                     
            //   0fb64ddc             | movzx               ecx, byte ptr [ebp - 0x24]
            //   8bf8                 | mov                 edi, eax

        $sequence_9 = { 668908 8bcf c7401000000000 c7401407000000 8d45b0 50 660fd645c0 }
            // n = 7, score = 100
            //   668908               | mov                 word ptr [eax], cx
            //   8bcf                 | mov                 ecx, edi
            //   c7401000000000       | mov                 dword ptr [eax + 0x10], 0
            //   c7401407000000       | mov                 dword ptr [eax + 0x14], 7
            //   8d45b0               | lea                 eax, [ebp - 0x50]
            //   50                   | push                eax
            //   660fd645c0           | movq                qword ptr [ebp - 0x40], xmm0

    condition:
        7 of them and filesize < 1209344
}