rule win_virdetdoor_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.virdetdoor."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.virdetdoor"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 83c40c 83feff 7502 33f6 }
            // n = 4, score = 100
            //   83c40c               | add                 esp, 0xc
            //   83feff               | cmp                 esi, -1
            //   7502                 | jne                 4
            //   33f6                 | xor                 esi, esi

        $sequence_1 = { 0fb74714 50 ff15???????? 0fb7c0 50 }
            // n = 5, score = 100
            //   0fb74714             | movzx               eax, word ptr [edi + 0x14]
            //   50                   | push                eax
            //   ff15????????         |                     
            //   0fb7c0               | movzx               eax, ax
            //   50                   | push                eax

        $sequence_2 = { 59 3945fc 7e4e 397dfc 7e49 8b35???????? 68???????? }
            // n = 7, score = 100
            //   59                   | pop                 ecx
            //   3945fc               | cmp                 dword ptr [ebp - 4], eax
            //   7e4e                 | jle                 0x50
            //   397dfc               | cmp                 dword ptr [ebp - 4], edi
            //   7e49                 | jle                 0x4b
            //   8b35????????         |                     
            //   68????????           |                     

        $sequence_3 = { 53 56 57 8bf9 c745f810270000 33db 33c9 }
            // n = 7, score = 100
            //   53                   | push                ebx
            //   56                   | push                esi
            //   57                   | push                edi
            //   8bf9                 | mov                 edi, ecx
            //   c745f810270000       | mov                 dword ptr [ebp - 8], 0x2710
            //   33db                 | xor                 ebx, ebx
            //   33c9                 | xor                 ecx, ecx

        $sequence_4 = { 6a0c 50 52 51 ff15???????? }
            // n = 5, score = 100
            //   6a0c                 | push                0xc
            //   50                   | push                eax
            //   52                   | push                edx
            //   51                   | push                ecx
            //   ff15????????         |                     

        $sequence_5 = { 8b7d10 57 7434 8b35???????? ffd6 50 8d45cc }
            // n = 7, score = 100
            //   8b7d10               | mov                 edi, dword ptr [ebp + 0x10]
            //   57                   | push                edi
            //   7434                 | je                  0x36
            //   8b35????????         |                     
            //   ffd6                 | call                esi
            //   50                   | push                eax
            //   8d45cc               | lea                 eax, [ebp - 0x34]

        $sequence_6 = { c6010b e9???????? c6010c e9???????? c6010d e9???????? }
            // n = 6, score = 100
            //   c6010b               | mov                 byte ptr [ecx], 0xb
            //   e9????????           |                     
            //   c6010c               | mov                 byte ptr [ecx], 0xc
            //   e9????????           |                     
            //   c6010d               | mov                 byte ptr [ecx], 0xd
            //   e9????????           |                     

        $sequence_7 = { 83c40c 83c01c 50 6a08 ff15???????? }
            // n = 5, score = 100
            //   83c40c               | add                 esp, 0xc
            //   83c01c               | add                 eax, 0x1c
            //   50                   | push                eax
            //   6a08                 | push                8
            //   ff15????????         |                     

        $sequence_8 = { 3bc1 75ec 3903 74d2 ebe6 85ff 75cc }
            // n = 7, score = 100
            //   3bc1                 | cmp                 eax, ecx
            //   75ec                 | jne                 0xffffffee
            //   3903                 | cmp                 dword ptr [ebx], eax
            //   74d2                 | je                  0xffffffd4
            //   ebe6                 | jmp                 0xffffffe8
            //   85ff                 | test                edi, edi
            //   75cc                 | jne                 0xffffffce

        $sequence_9 = { ff35???????? ff15???????? 8bc8 85c9 7450 6a5c }
            // n = 6, score = 100
            //   ff35????????         |                     
            //   ff15????????         |                     
            //   8bc8                 | mov                 ecx, eax
            //   85c9                 | test                ecx, ecx
            //   7450                 | je                  0x52
            //   6a5c                 | push                0x5c

    condition:
        7 of them and filesize < 106496
}