rule win_virut_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.virut."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.virut"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 83c40c ab ab 8d442430 50 }
            // n = 5, score = 200
            //   83c40c               | add                 esp, 0xc
            //   ab                   | stosd               dword ptr es:[edi], eax
            //   ab                   | stosd               dword ptr es:[edi], eax
            //   8d442430             | lea                 eax, [esp + 0x30]
            //   50                   | push                eax

        $sequence_1 = { e9???????? 8dbec8000000 0fb74e1e 8d74311f 6804010000 57 }
            // n = 6, score = 200
            //   e9????????           |                     
            //   8dbec8000000         | lea                 edi, [esi + 0xc8]
            //   0fb74e1e             | movzx               ecx, word ptr [esi + 0x1e]
            //   8d74311f             | lea                 esi, [ecx + esi + 0x1f]
            //   6804010000           | push                0x104
            //   57                   | push                edi

        $sequence_2 = { 3bf1 7ce5 8b442414 6a03 }
            // n = 4, score = 200
            //   3bf1                 | cmp                 esi, ecx
            //   7ce5                 | jl                  0xffffffe7
            //   8b442414             | mov                 eax, dword ptr [esp + 0x14]
            //   6a03                 | push                3

        $sequence_3 = { 6804010000 ff15???????? 8d8424c8000000 50 }
            // n = 4, score = 200
            //   6804010000           | push                0x104
            //   ff15????????         |                     
            //   8d8424c8000000       | lea                 eax, [esp + 0xc8]
            //   50                   | push                eax

        $sequence_4 = { 53 6a05 8bcc 50 }
            // n = 4, score = 200
            //   53                   | push                ebx
            //   6a05                 | push                5
            //   8bcc                 | mov                 ecx, esp
            //   50                   | push                eax

        $sequence_5 = { 50 ff15???????? 3bc3 0f8484020000 8b400c }
            // n = 5, score = 200
            //   50                   | push                eax
            //   ff15????????         |                     
            //   3bc3                 | cmp                 eax, ebx
            //   0f8484020000         | je                  0x28a
            //   8b400c               | mov                 eax, dword ptr [eax + 0xc]

        $sequence_6 = { 03f9 57 52 6a18 }
            // n = 4, score = 200
            //   03f9                 | add                 edi, ecx
            //   57                   | push                edi
            //   52                   | push                edx
            //   6a18                 | push                0x18

        $sequence_7 = { 54 51 50 52 51 51 }
            // n = 6, score = 200
            //   54                   | push                esp
            //   51                   | push                ecx
            //   50                   | push                eax
            //   52                   | push                edx
            //   51                   | push                ecx
            //   51                   | push                ecx

        $sequence_8 = { 85c0 7416 e314 50 8bd4 6a00 }
            // n = 6, score = 200
            //   85c0                 | test                eax, eax
            //   7416                 | je                  0x18
            //   e314                 | jecxz               0x16
            //   50                   | push                eax
            //   8bd4                 | mov                 edx, esp
            //   6a00                 | push                0

        $sequence_9 = { 85c0 7d04 33c0 eb63 ff750c }
            // n = 5, score = 200
            //   85c0                 | test                eax, eax
            //   7d04                 | jge                 6
            //   33c0                 | xor                 eax, eax
            //   eb63                 | jmp                 0x65
            //   ff750c               | push                dword ptr [ebp + 0xc]

        $sequence_10 = { 8d8424dc020000 50 33db 53 ff15???????? 8b35???????? 53 }
            // n = 7, score = 200
            //   8d8424dc020000       | lea                 eax, [esp + 0x2dc]
            //   50                   | push                eax
            //   33db                 | xor                 ebx, ebx
            //   53                   | push                ebx
            //   ff15????????         |                     
            //   8b35????????         |                     
            //   53                   | push                ebx

        $sequence_11 = { 6a00 8bcc 6a40 6800001000 }
            // n = 4, score = 200
            //   6a00                 | push                0
            //   8bcc                 | mov                 ecx, esp
            //   6a40                 | push                0x40
            //   6800001000           | push                0x100000

        $sequence_12 = { 6a00 6800000008 6a40 51 52 6a0e 50 }
            // n = 7, score = 200
            //   6a00                 | push                0
            //   6800000008           | push                0x8000000
            //   6a40                 | push                0x40
            //   51                   | push                ecx
            //   52                   | push                edx
            //   6a0e                 | push                0xe
            //   50                   | push                eax

        $sequence_13 = { 83e003 40 50 8d442428 50 8d8424e0020000 }
            // n = 6, score = 200
            //   83e003               | and                 eax, 3
            //   40                   | inc                 eax
            //   50                   | push                eax
            //   8d442428             | lea                 eax, [esp + 0x28]
            //   50                   | push                eax
            //   8d8424e0020000       | lea                 eax, [esp + 0x2e0]

        $sequence_14 = { 3b44240c 8d8c1139300000 894c2414 7cdc 53 8d442410 }
            // n = 6, score = 200
            //   3b44240c             | cmp                 eax, dword ptr [esp + 0xc]
            //   8d8c1139300000       | lea                 ecx, [ecx + edx + 0x3039]
            //   894c2414             | mov                 dword ptr [esp + 0x14], ecx
            //   7cdc                 | jl                  0xffffffde
            //   53                   | push                ebx
            //   8d442410             | lea                 eax, [esp + 0x10]

        $sequence_15 = { 8bd4 50 54 6a40 51 52 }
            // n = 6, score = 200
            //   8bd4                 | mov                 edx, esp
            //   50                   | push                eax
            //   54                   | push                esp
            //   6a40                 | push                0x40
            //   51                   | push                ecx
            //   52                   | push                edx

    condition:
        7 of them and filesize < 98304
}