rule win_vohuk_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.vohuk."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.vohuk"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { c745a441003500 b81f6b193a 8bce f7ee c1fa05 8bc2 c1e81f }
            // n = 7, score = 100
            //   c745a441003500       | mov                 dword ptr [ebp - 0x5c], 0x350041
            //   b81f6b193a           | mov                 eax, 0x3a196b1f
            //   8bce                 | mov                 ecx, esi
            //   f7ee                 | imul                esi
            //   c1fa05               | sar                 edx, 5
            //   8bc2                 | mov                 eax, edx
            //   c1e81f               | shr                 eax, 0x1f

        $sequence_1 = { c7403c9e008200 c7404083008300 c74044ce00c200 c74048ce00d100 c7404cbb00b700 c74050ce00d500 }
            // n = 6, score = 100
            //   c7403c9e008200       | mov                 dword ptr [eax + 0x3c], 0x82009e
            //   c7404083008300       | mov                 dword ptr [eax + 0x40], 0x830083
            //   c74044ce00c200       | mov                 dword ptr [eax + 0x44], 0xc200ce
            //   c74048ce00d100       | mov                 dword ptr [eax + 0x48], 0xd100ce
            //   c7404cbb00b700       | mov                 dword ptr [eax + 0x4c], 0xb700bb
            //   c74050ce00d500       | mov                 dword ptr [eax + 0x50], 0xd500ce

        $sequence_2 = { e8???????? ff75ac 6a00 56 ffd0 8b7da0 e9???????? }
            // n = 7, score = 100
            //   e8????????           |                     
            //   ff75ac               | push                dword ptr [ebp - 0x54]
            //   6a00                 | push                0
            //   56                   | push                esi
            //   ffd0                 | call                eax
            //   8b7da0               | mov                 edi, dword ptr [ebp - 0x60]
            //   e9????????           |                     

        $sequence_3 = { c745ec00000000 50 ffd7 85c0 7474 8b0d???????? ba43c7bfd0 }
            // n = 7, score = 100
            //   c745ec00000000       | mov                 dword ptr [ebp - 0x14], 0
            //   50                   | push                eax
            //   ffd7                 | call                edi
            //   85c0                 | test                eax, eax
            //   7474                 | je                  0x76
            //   8b0d????????         |                     
            //   ba43c7bfd0           | mov                 edx, 0xd0bfc743

        $sequence_4 = { 83f804 7646 6a14 81ff00010000 0f8618010000 51 }
            // n = 6, score = 100
            //   83f804               | cmp                 eax, 4
            //   7646                 | jbe                 0x48
            //   6a14                 | push                0x14
            //   81ff00010000         | cmp                 edi, 0x100
            //   0f8618010000         | jbe                 0x11e
            //   51                   | push                ecx

        $sequence_5 = { 7586 c745fc2f000000 8d9dd8feffff 8b5334 8d4004 8b33 8d5b04 }
            // n = 7, score = 100
            //   7586                 | jne                 0xffffff88
            //   c745fc2f000000       | mov                 dword ptr [ebp - 4], 0x2f
            //   8d9dd8feffff         | lea                 ebx, [ebp - 0x128]
            //   8b5334               | mov                 edx, dword ptr [ebx + 0x34]
            //   8d4004               | lea                 eax, [eax + 4]
            //   8b33                 | mov                 esi, dword ptr [ebx]
            //   8d5b04               | lea                 ebx, [ebx + 4]

        $sequence_6 = { c645ff00 8b0d???????? ba05bc94bf 8b35???????? 6a15 e8???????? }
            // n = 6, score = 100
            //   c645ff00             | mov                 byte ptr [ebp - 1], 0
            //   8b0d????????         |                     
            //   ba05bc94bf           | mov                 edx, 0xbf94bc05
            //   8b35????????         |                     
            //   6a15                 | push                0x15
            //   e8????????           |                     

        $sequence_7 = { 7307 bee8030000 eb0d 81fe10270000 7605 be10270000 8b0d???????? }
            // n = 7, score = 100
            //   7307                 | jae                 9
            //   bee8030000           | mov                 esi, 0x3e8
            //   eb0d                 | jmp                 0xf
            //   81fe10270000         | cmp                 esi, 0x2710
            //   7605                 | jbe                 7
            //   be10270000           | mov                 esi, 0x2710
            //   8b0d????????         |                     

        $sequence_8 = { ffd0 8bd8 bf41000000 b81a000000 8945fc f6c301 0f858a000000 }
            // n = 7, score = 100
            //   ffd0                 | call                eax
            //   8bd8                 | mov                 ebx, eax
            //   bf41000000           | mov                 edi, 0x41
            //   b81a000000           | mov                 eax, 0x1a
            //   8945fc               | mov                 dword ptr [ebp - 4], eax
            //   f6c301               | test                bl, 1
            //   0f858a000000         | jne                 0x90

        $sequence_9 = { 51 6a38 8d8d60ffffff 51 6a0a 56 ffd0 }
            // n = 7, score = 100
            //   51                   | push                ecx
            //   6a38                 | push                0x38
            //   8d8d60ffffff         | lea                 ecx, [ebp - 0xa0]
            //   51                   | push                ecx
            //   6a0a                 | push                0xa
            //   56                   | push                esi
            //   ffd0                 | call                eax

    condition:
        7 of them and filesize < 260096
}