rule win_volgmer_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.volgmer."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.volgmer"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 4533c0 498bd5 33c9 c744242800000008 }
            // n = 4, score = 200
            //   4533c0               | inc                 ebp
            //   498bd5               | xor                 eax, eax
            //   33c9                 | dec                 ecx
            //   c744242800000008     | mov                 edx, ebp

        $sequence_1 = { 7454 33d2 488d4c2434 41b804040000 e8???????? 448d4606 }
            // n = 6, score = 200
            //   7454                 | inc                 esp
            //   33d2                 | mov                 ecx, esi
            //   488d4c2434           | dec                 eax
            //   41b804040000         | xor                 eax, esp
            //   e8????????           |                     
            //   448d4606             | dec                 eax

        $sequence_2 = { 7406 488bcf ff5588 4533c9 4533c0 33d2 }
            // n = 6, score = 200
            //   7406                 | lea                 ecx, [ebp + 0xd27]
            //   488bcf               | xor                 edx, edx
            //   ff5588               | inc                 ecx
            //   4533c9               | mov                 eax, 0x1c5
            //   4533c0               | movups              xmmword ptr [ebp + 0xce4], xmm0
            //   33d2                 | dec                 eax

        $sequence_3 = { 4889442420 4c8d442448 418d5108 41ffd4 4c8d8da0030000 498bce }
            // n = 6, score = 200
            //   4889442420           | dec                 eax
            //   4c8d442448           | lea                 ecx, [0xee71]
            //   418d5108             | dec                 eax
            //   41ffd4               | mov                 ebx, eax
            //   4c8d8da0030000       | mov                 byte ptr [ecx], al
            //   498bce               | dec                 eax

        $sequence_4 = { 4883c9ff 48ffc1 803c0800 75f7 66ffc1 488d8560030000 }
            // n = 6, score = 200
            //   4883c9ff             | lea                 ecx, [ecx + 1]
            //   48ffc1               | inc                 eax
            //   803c0800             | cmp                 eax, 0x100
            //   75f7                 | jl                  0xfffffffa
            //   66ffc1               | inc                 sp
            //   488d8560030000       | mov                 dword ptr [esi + 0x100], edx

        $sequence_5 = { 8801 488d4901 ffc0 3d00010000 7cf1 6644899600010000 }
            // n = 6, score = 200
            //   8801                 | dec                 eax
            //   488d4901             | lea                 ecx, [edi + 0x10]
            //   ffc0                 | dec                 esp
            //   3d00010000           | lea                 eax, [esp + 0x58]
            //   7cf1                 | dec                 eax
            //   6644899600010000     | lea                 edx, [esp + 0x58]

        $sequence_6 = { e8???????? e8???????? e8???????? c705????????04000000 }
            // n = 4, score = 200
            //   e8????????           |                     
            //   e8????????           |                     
            //   e8????????           |                     
            //   c705????????04000000     |     

        $sequence_7 = { 488d8d270d0000 0f280d???????? 33d2 0fb705???????? 41b8c5010000 0f1185e40c0000 }
            // n = 6, score = 200
            //   488d8d270d0000       | mov                 dword ptr [ebp + 0x37], eax
            //   0f280d????????       |                     
            //   33d2                 | xor                 eax, eax
            //   0fb705????????       |                     
            //   41b8c5010000         | mov                 dword ptr [ebp - 0x29], 0x67452301
            //   0f1185e40c0000       | mov                 dword ptr [ebp - 0x5d], eax

        $sequence_8 = { 488d8d20050000 ff542460 488bcb ff542468 8bc6 }
            // n = 5, score = 200
            //   488d8d20050000       | inc                 ecx
            //   ff542460             | mov                 eax, 0x404
            //   488bcb               | inc                 esp
            //   ff542468             | lea                 eax, [esi + 6]
            //   8bc6                 | dec                 eax

        $sequence_9 = { 488d8d400f0000 e8???????? 8bd6 c68435400f000000 488d8d400f0000 }
            // n = 5, score = 200
            //   488d8d400f0000       | je                  0x56
            //   e8????????           |                     
            //   8bd6                 | xor                 edx, edx
            //   c68435400f000000     | dec                 eax
            //   488d8d400f0000       | lea                 ecx, [esp + 0x34]

        $sequence_10 = { e8???????? 85c0 740c 418bdd e9???????? 4983cfff }
            // n = 6, score = 100
            //   e8????????           |                     
            //   85c0                 | xor                 ecx, ecx
            //   740c                 | mov                 dword ptr [esp + 0x28], 0x8000000
            //   418bdd               | test                eax, eax
            //   e9????????           |                     
            //   4983cfff             | je                  0x10

        $sequence_11 = { 33d2 41b808020000 6644896d80 e8???????? 488b3d???????? 33c0 }
            // n = 6, score = 100
            //   33d2                 | inc                 ecx
            //   41b808020000         | mov                 ebx, ebp
            //   6644896d80           | dec                 ecx
            //   e8????????           |                     
            //   488b3d????????       |                     
            //   33c0                 | or                  edi, 0xffffffff

        $sequence_12 = { 3bd7 89542410 750d 57 }
            // n = 4, score = 100
            //   3bd7                 | cmp                 edx, edi
            //   89542410             | mov                 dword ptr [esp + 0x10], edx
            //   750d                 | jne                 0xf
            //   57                   | push                edi

        $sequence_13 = { 89831c0c0000 eb15 8d4601 50 e8???????? 89831c0c0000 83c404 }
            // n = 7, score = 100
            //   89831c0c0000         | xor                 ebx, ebx
            //   eb15                 | dec                 eax
            //   8d4601               | lea                 edi, [ecx + 0x5af68]
            //   50                   | inc                 ecx
            //   e8????????           |                     
            //   89831c0c0000         | movzx               eax, bx
            //   83c404               | mov                 eax, dword ptr [eax*8 + 0x6e9820]

        $sequence_14 = { 4833c4 48894537 4c8b25???????? 33c0 c745d701234567 8945a3 }
            // n = 6, score = 100
            //   4833c4               | mov                 dword ptr [esp + 0x38], ebp
            //   48894537             | dec                 eax
            //   4c8b25????????       |                     
            //   33c0                 | lea                 esi, [0x1a576]
            //   c745d701234567       | dec                 esp
            //   8945a3               | lea                 eax, [0x1a56b]

        $sequence_15 = { 8bfe 83e03f c1ff06 6bd830 8b04bd80f17300 f644032801 }
            // n = 6, score = 100
            //   8bfe                 | test                ecx, ecx
            //   83e03f               | je                  0xf
            //   c1ff06               | sub                 eax, 9
            //   6bd830               | je                  0x45
            //   8b04bd80f17300       | sub                 eax, 1
            //   f644032801           | jne                 0x10c

        $sequence_16 = { c1f906 6bf630 8b0c8d80f16e00 80643128fd 5f 5e }
            // n = 6, score = 100
            //   c1f906               | xor                 ecx, ecx
            //   6bf630               | mov                 dword ptr [esp + 0x28], 0x8000000
            //   8b0c8d80f16e00       | inc                 esp
            //   80643128fd           | mov                 eax, edi
            //   5f                   | dec                 eax
            //   5e                   | add                 ecx, esi

        $sequence_17 = { 6a26 58 0fb60c8536976e00 0fb6348537976e00 8bf9 8985b4f8ffff c1e702 }
            // n = 7, score = 100
            //   6a26                 | mov                 ebx, eax
            //   58                   | cmp                 edi, dword ptr [ebx + 0x50054]
            //   0fb60c8536976e00     | inc                 ecx
            //   0fb6348537976e00     | mov                 eax, 0x8000
            //   8bf9                 | add                 dword ptr [ebx + 0x5004c], 0xffff8000
            //   8985b4f8ffff         | add                 dword ptr [ebx + 0x50044], 0xffff8000
            //   c1e702               | dec                 eax

        $sequence_18 = { 6bd030 895de4 8b049d80f17300 8945d4 }
            // n = 4, score = 100
            //   6bd030               | imul                esi, esi, 0x30
            //   895de4               | mov                 ecx, dword ptr [ecx*4 + 0x6ef180]
            //   8b049d80f17300       | and                 byte ptr [ecx + esi + 0x28], 0xfd
            //   8945d4               | pop                 edi

        $sequence_19 = { 89855cf5ffff 0f84df040000 8d8618030000 50 8d85f4fbffff }
            // n = 5, score = 100
            //   89855cf5ffff         | pop                 esi
            //   0f84df040000         | push                esi
            //   8d8618030000         | cmp                 eax, 0x15
            //   50                   | ja                  0x117
            //   8d85f4fbffff         | jmp                 dword ptr [eax*4 + 0x6d6b78]

        $sequence_20 = { 83e809 7443 83e801 0f8501010000 c745e0e4ba6e00 8b4508 8bcf }
            // n = 7, score = 100
            //   83e809               | xor                 edx, edx
            //   7443                 | dec                 eax
            //   83e801               | mov                 dword ptr [esp + 0x50], eax
            //   0f8501010000         | dec                 eax
            //   c745e0e4ba6e00       | lea                 ecx, [ebp + 0x580]
            //   8b4508               | mov                 edx, edi
            //   8bcf                 | mov                 byte ptr [ebp + edi + 0x580], 0

        $sequence_21 = { c645e316 ff15???????? 410fb7cd 668945e4 }
            // n = 4, score = 100
            //   c645e316             | xor                 eax, eax
            //   ff15????????         |                     
            //   410fb7cd             | pop                 ebp
            //   668945e4             | ret                 

        $sequence_22 = { 8b2d???????? 50 ffd5 8d942480000000 52 ff15???????? }
            // n = 6, score = 100
            //   8b2d????????         |                     
            //   50                   | push                eax
            //   ffd5                 | call                ebp
            //   8d942480000000       | lea                 edx, [esp + 0x80]
            //   52                   | push                edx
            //   ff15????????         |                     

        $sequence_23 = { 83f808 74ba 83f807 77c5 ff2485d1a86d00 8bce }
            // n = 6, score = 100
            //   83f808               | dec                 eax
            //   74ba                 | lea                 ecx, [ebp + 0x580]
            //   83f807               | inc                 ebp
            //   77c5                 | xor                 eax, eax
            //   ff2485d1a86d00       | dec                 ecx
            //   8bce                 | mov                 edx, ebp

        $sequence_24 = { f3ab 66ab 33c0 8d4c2404 89442409 51 }
            // n = 6, score = 100
            //   f3ab                 | rep stosd           dword ptr es:[edi], eax
            //   66ab                 | stosw               word ptr es:[edi], ax
            //   33c0                 | xor                 eax, eax
            //   8d4c2404             | lea                 ecx, [esp + 4]
            //   89442409             | mov                 dword ptr [esp + 9], eax
            //   51                   | push                ecx

        $sequence_25 = { 448bc7 4803ce e8???????? 8d7709 488b5310 }
            // n = 5, score = 100
            //   448bc7               | dec                 ecx
            //   4803ce               | mov                 ecx, esi
            //   e8????????           |                     
            //   8d7709               | dec                 eax
            //   488b5310             | or                  ecx, 0xffffffff

        $sequence_26 = { 4c89642440 4c896c2438 488d3576a50100 4c8d056ba50100 }
            // n = 4, score = 100
            //   4c89642440           | mov                 eax, 1
            //   4c896c2438           | jmp                 0xffffffcc
            //   488d3576a50100       | mov                 ecx, 0x1388
            //   4c8d056ba50100       | mov                 byte ptr [ebp - 0x1d], 0x16

        $sequence_27 = { 663944244d 0f8593010000 488d4f10 4c8d442458 488d542458 448bce }
            // n = 6, score = 100
            //   663944244d           | inc                 ecx
            //   0f8593010000         | movzx               ecx, bp
            //   488d4f10             | mov                 word ptr [ebp - 0x1c], ax
            //   4c8d442458           | dec                 esp
            //   488d542458           | mov                 dword ptr [esp + 0x40], esp
            //   448bce               | dec                 esp

        $sequence_28 = { 8d3c85c8f46e00 8b0f 85c9 740b }
            // n = 4, score = 100
            //   8d3c85c8f46e00       | inc                 ebp
            //   8b0f                 | xor                 ecx, ecx
            //   85c9                 | inc                 ebp
            //   740b                 | xor                 eax, eax

        $sequence_29 = { c6442412ed c644241396 c644241425 c644241528 c6442416fd }
            // n = 5, score = 100
            //   c6442412ed           | mov                 byte ptr [esp + 0x12], 0xed
            //   c644241396           | mov                 byte ptr [esp + 0x13], 0x96
            //   c644241425           | mov                 byte ptr [esp + 0x14], 0x25
            //   c644241528           | mov                 byte ptr [esp + 0x15], 0x28
            //   c6442416fd           | mov                 byte ptr [esp + 0x16], 0xfd

        $sequence_30 = { 8b04c520986e00 5d c3 33c0 }
            // n = 4, score = 100
            //   8b04c520986e00       | je                  8
            //   5d                   | dec                 eax
            //   c3                   | mov                 ecx, edi
            //   33c0                 | call                dword ptr [ebp - 0x78]

        $sequence_31 = { 56 83f815 0f8711010000 ff2485786b6d00 51 8d5106 }
            // n = 6, score = 100
            //   56                   | lea                 esi, [edi + 9]
            //   83f815               | dec                 eax
            //   0f8711010000         | mov                 edx, dword ptr [ebx + 0x10]
            //   ff2485786b6d00       | inc                 edx
            //   51                   | mov                 ecx, dword ptr [esp + eax*4 + 0x40]
            //   8d5106               | nop                 dword ptr [eax + eax]

        $sequence_32 = { e8???????? 83c40c c785e0f3ffff00040000 8d85e0f3ffff 50 }
            // n = 5, score = 100
            //   e8????????           |                     
            //   83c40c               | mov                 dword ptr [ebp - 0x20], 0x6ebae4
            //   c785e0f3ffff00040000     | mov    eax, dword ptr [ebp + 8]
            //   8d85e0f3ffff         | mov                 ecx, edi
            //   50                   | cmp                 eax, 8

        $sequence_33 = { 5d c3 b801000000 ebc5 b988130000 }
            // n = 5, score = 100
            //   5d                   | xor                 edx, edx
            //   c3                   | inc                 ecx
            //   b801000000           | mov                 eax, 0x208
            //   ebc5                 | inc                 sp
            //   b988130000           | mov                 dword ptr [ebp - 0x80], ebp

        $sequence_34 = { 55 6a00 6a00 8d442410 6a1a }
            // n = 5, score = 100
            //   55                   | push                ebp
            //   6a00                 | push                0
            //   6a00                 | push                0
            //   8d442410             | lea                 eax, [esp + 0x10]
            //   6a1a                 | push                0x1a

        $sequence_35 = { eb57 53 8b1c85d8886e00 56 6800080000 6a00 }
            // n = 6, score = 100
            //   eb57                 | cmp                 ecx, dword ptr [esp + eax*4 + 0x140]
            //   53                   | je                  0x22
            //   8b1c85d8886e00       | dec                 eax
            //   56                   | inc                 eax
            //   6800080000           | sub                 dword ptr [ebx + 0x50050], edi
            //   6a00                 | inc                 esp

        $sequence_36 = { e8???????? 29bb50000500 448bd8 3bbb54000500 }
            // n = 4, score = 100
            //   e8????????           |                     
            //   29bb50000500         | dec                 eax
            //   448bd8               | lea                 eax, [ebp + 0x360]
            //   3bbb54000500         | dec                 eax

        $sequence_37 = { 88442419 c644241a13 c644241b0e c644241c5d c644241d9f }
            // n = 5, score = 100
            //   88442419             | mov                 byte ptr [esp + 0x19], al
            //   c644241a13           | mov                 byte ptr [esp + 0x1a], 0x13
            //   c644241b0e           | mov                 byte ptr [esp + 0x1b], 0xe
            //   c644241c5d           | mov                 byte ptr [esp + 0x1c], 0x5d
            //   c644241d9f           | mov                 byte ptr [esp + 0x1d], 0x9f

        $sequence_38 = { 48f7d1 4c8d0409 488d4dc0 e8???????? 4c8d4c2440 }
            // n = 5, score = 100
            //   48f7d1               | dec                 eax
            //   4c8d0409             | lea                 ecx, [ebp + 0xf40]
            //   488d4dc0             | dec                 eax
            //   e8????????           |                     
            //   4c8d4c2440           | lea                 ecx, [ebp + 0x520]

        $sequence_39 = { 50 ff15???????? 837e0c00 8bf8 0f840a010000 8d8e18030000 51 }
            // n = 7, score = 100
            //   50                   | je                  0xffffffbc
            //   ff15????????         |                     
            //   837e0c00             | cmp                 eax, 7
            //   8bf8                 | ja                  0xffffffcc
            //   0f840a010000         | jmp                 dword ptr [eax*4 + 0x6da8d1]
            //   8d8e18030000         | mov                 ecx, esi
            //   51                   | sar                 ecx, 6

        $sequence_40 = { 428b4c8440 0f1f440000 3b8c8440010000 7419 48ffc0 }
            // n = 5, score = 100
            //   428b4c8440           | dec                 eax
            //   0f1f440000           | inc                 ecx
            //   3b8c8440010000       | cmp                 byte ptr [eax + ecx], 0
            //   7419                 | jne                 0xfffffffd
            //   48ffc0               | inc                 cx

        $sequence_41 = { 41b800800000 e8???????? 81834c0005000080ffff 8183440005000080ffff }
            // n = 4, score = 100
            //   41b800800000         | lea                 ecx, [ebp + 0xf40]
            //   e8????????           |                     
            //   81834c0005000080ffff     | mov    edx, esi
            //   8183440005000080ffff     | mov    byte ptr [ebp + esi + 0xf40], 0

        $sequence_42 = { 6800010000 8db318010000 6a00 56 e8???????? 6800010000 }
            // n = 6, score = 100
            //   6800010000           | pop                 ebp
            //   8db318010000         | ret                 
            //   6a00                 | xor                 eax, eax
            //   56                   | lea                 edi, [eax*4 + 0x6ef4c8]
            //   e8????????           |                     
            //   6800010000           | mov                 ecx, dword ptr [edi]

        $sequence_43 = { 8bf8 0f84df020000 8d8318030000 50 8d85bcf7ffff }
            // n = 5, score = 100
            //   8bf8                 | lea                 ecx, [esp + 0x40]
            //   0f84df020000         | mov                 edx, dword ptr [edx + 0x18]
            //   8d8318030000         | dec                 esp
            //   50                   | mov                 edx, ecx
            //   8d85bcf7ffff         | inc                 ebp

    condition:
        7 of them and filesize < 393216
}