rule win_vsingle_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.vsingle."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.vsingle"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 668985ccb6ffff 6800200000 6a00 8d8dceb6ffff 51 e8???????? }
            // n = 6, score = 700
            //   668985ccb6ffff       | mov                 word ptr [ebp - 0x4934], ax
            //   6800200000           | push                0x2000
            //   6a00                 | push                0
            //   8d8dceb6ffff         | lea                 ecx, [ebp - 0x4932]
            //   51                   | push                ecx
            //   e8????????           |                     

        $sequence_1 = { 50 6800010000 8b4508 50 }
            // n = 4, score = 700
            //   50                   | push                eax
            //   6800010000           | push                0x100
            //   8b4508               | mov                 eax, dword ptr [ebp + 8]
            //   50                   | push                eax

        $sequence_2 = { 50 51 b8b0490000 e8???????? }
            // n = 4, score = 700
            //   50                   | push                eax
            //   51                   | push                ecx
            //   b8b0490000           | mov                 eax, 0x49b0
            //   e8????????           |                     

        $sequence_3 = { 83c404 50 8d4dd0 51 e8???????? 83c40c }
            // n = 6, score = 700
            //   83c404               | add                 esp, 4
            //   50                   | push                eax
            //   8d4dd0               | lea                 ecx, [ebp - 0x30]
            //   51                   | push                ecx
            //   e8????????           |                     
            //   83c40c               | add                 esp, 0xc

        $sequence_4 = { 035508 b801000000 d1e0 8a4dff 880c02 ba04000000 }
            // n = 6, score = 700
            //   035508               | add                 edx, dword ptr [ebp + 8]
            //   b801000000           | mov                 eax, 1
            //   d1e0                 | shl                 eax, 1
            //   8a4dff               | mov                 cl, byte ptr [ebp - 1]
            //   880c02               | mov                 byte ptr [edx + eax], cl
            //   ba04000000           | mov                 edx, 4

        $sequence_5 = { 035508 be01000000 d1e6 8a0408 }
            // n = 4, score = 700
            //   035508               | add                 edx, dword ptr [ebp + 8]
            //   be01000000           | mov                 esi, 1
            //   d1e6                 | shl                 esi, 1
            //   8a0408               | mov                 al, byte ptr [eax + ecx]

        $sequence_6 = { 50 0fb78d10efffff 51 0fb79516efffff 52 0fb78512efffff 50 }
            // n = 7, score = 700
            //   50                   | push                eax
            //   0fb78d10efffff       | movzx               ecx, word ptr [ebp - 0x10f0]
            //   51                   | push                ecx
            //   0fb79516efffff       | movzx               edx, word ptr [ebp - 0x10ea]
            //   52                   | push                edx
            //   0fb78512efffff       | movzx               eax, word ptr [ebp - 0x10ee]
            //   50                   | push                eax

        $sequence_7 = { 668985d4f6ffff 68fe070000 6a00 8d8dd6f6ffff }
            // n = 4, score = 700
            //   668985d4f6ffff       | mov                 word ptr [ebp - 0x92c], ax
            //   68fe070000           | push                0x7fe
            //   6a00                 | push                0
            //   8d8dd6f6ffff         | lea                 ecx, [ebp - 0x92a]

        $sequence_8 = { 81c29733eaa8 81f2e97da1b5 81ea52e5b08e 81c2f77c29e2 81ea4b516cc2 89042a 5a }
            // n = 7, score = 100
            //   81c29733eaa8         | add                 edx, 0xa8ea3397
            //   81f2e97da1b5         | xor                 edx, 0xb5a17de9
            //   81ea52e5b08e         | sub                 edx, 0x8eb0e552
            //   81c2f77c29e2         | add                 edx, 0xe2297cf7
            //   81ea4b516cc2         | sub                 edx, 0xc26c514b
            //   89042a               | mov                 dword ptr [edx + ebp], eax
            //   5a                   | pop                 edx

        $sequence_9 = { 5f 51 57 51 b9cd968197 }
            // n = 5, score = 100
            //   5f                   | pop                 edi
            //   51                   | push                ecx
            //   57                   | push                edi
            //   51                   | push                ecx
            //   b9cd968197           | mov                 ecx, 0x978196cd

        $sequence_10 = { 51 b9b187ff90 81e95e49f864 81c17c65b866 81c10f9cc186 }
            // n = 5, score = 100
            //   51                   | push                ecx
            //   b9b187ff90           | mov                 ecx, 0x90ff87b1
            //   81e95e49f864         | sub                 ecx, 0x64f8495e
            //   81c17c65b866         | add                 ecx, 0x66b8657c
            //   81c10f9cc186         | add                 ecx, 0x86c19c0f

        $sequence_11 = { 81c2b953352c 81c26fe1dd9a 81eaf2033eb3 81f2866440c5 81f237c658eb 81c2a804b1a7 }
            // n = 6, score = 100
            //   81c2b953352c         | add                 edx, 0x2c3553b9
            //   81c26fe1dd9a         | add                 edx, 0x9adde16f
            //   81eaf2033eb3         | sub                 edx, 0xb33e03f2
            //   81f2866440c5         | xor                 edx, 0xc5406486
            //   81f237c658eb         | xor                 edx, 0xeb58c637
            //   81c2a804b1a7         | add                 edx, 0xa7b104a8

        $sequence_12 = { 5b 53 bb8fbc7c14 81c30cf1050f e9???????? 5e }
            // n = 6, score = 100
            //   5b                   | pop                 ebx
            //   53                   | push                ebx
            //   bb8fbc7c14           | mov                 ebx, 0x147cbc8f
            //   81c30cf1050f         | add                 ebx, 0xf05f10c
            //   e9????????           |                     
            //   5e                   | pop                 esi

        $sequence_13 = { 7505 e9???????? 50 b8e64d1443 81e8dc1e5dbe eb0a }
            // n = 6, score = 100
            //   7505                 | jne                 7
            //   e9????????           |                     
            //   50                   | push                eax
            //   b8e64d1443           | mov                 eax, 0x43144de6
            //   81e8dc1e5dbe         | sub                 eax, 0xbe5d1edc
            //   eb0a                 | jmp                 0xc

        $sequence_14 = { 89042e 5e 56 be76e3d36a 81ee46419e0d }
            // n = 5, score = 100
            //   89042e               | mov                 dword ptr [esi + ebp], eax
            //   5e                   | pop                 esi
            //   56                   | push                esi
            //   be76e3d36a           | mov                 esi, 0x6ad3e376
            //   81ee46419e0d         | sub                 esi, 0xd9e4146

        $sequence_15 = { 81f19d49dcd4 81e9c159bc74 890429 59 }
            // n = 4, score = 100
            //   81f19d49dcd4         | xor                 ecx, 0xd4dc499d
            //   81e9c159bc74         | sub                 ecx, 0x74bc59c1
            //   890429               | mov                 dword ptr [ecx + ebp], eax
            //   59                   | pop                 ecx

    condition:
        7 of them and filesize < 940032
}