rule win_vyveva_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.vyveva."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.vyveva"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 7404 ff7604 59 3b7108 7506 50 8f4108 }
            // n = 7, score = 100
            //   7404                 | je                  6
            //   ff7604               | push                dword ptr [esi + 4]
            //   59                   | pop                 ecx
            //   3b7108               | cmp                 esi, dword ptr [ecx + 8]
            //   7506                 | jne                 8
            //   50                   | push                eax
            //   8f4108               | pop                 dword ptr [ecx + 8]

        $sequence_1 = { 8b442428 3b4c2438 740c 3b4c2438 7406 33c9 034c2438 }
            // n = 7, score = 100
            //   8b442428             | mov                 eax, dword ptr [esp + 0x28]
            //   3b4c2438             | cmp                 ecx, dword ptr [esp + 0x38]
            //   740c                 | je                  0xe
            //   3b4c2438             | cmp                 ecx, dword ptr [esp + 0x38]
            //   7406                 | je                  8
            //   33c9                 | xor                 ecx, ecx
            //   034c2438             | add                 ecx, dword ptr [esp + 0x38]

        $sequence_2 = { 83ec04 33ed 8d6c2c74 83ed74 c74424fcffffffff 83ec04 68???????? }
            // n = 7, score = 100
            //   83ec04               | sub                 esp, 4
            //   33ed                 | xor                 ebp, ebp
            //   8d6c2c74             | lea                 ebp, [esp + ebp + 0x74]
            //   83ed74               | sub                 ebp, 0x74
            //   c74424fcffffffff     | mov                 dword ptr [esp - 4], 0xffffffff
            //   83ec04               | sub                 esp, 4
            //   68????????           |                     

        $sequence_3 = { e8???????? 8b4c242c 8b442428 8d54243c 894c2440 6a08 52 }
            // n = 7, score = 100
            //   e8????????           |                     
            //   8b4c242c             | mov                 ecx, dword ptr [esp + 0x2c]
            //   8b442428             | mov                 eax, dword ptr [esp + 0x28]
            //   8d54243c             | lea                 edx, [esp + 0x3c]
            //   894c2440             | mov                 dword ptr [esp + 0x40], ecx
            //   6a08                 | push                8
            //   52                   | push                edx

        $sequence_4 = { 037e3c 8d4c0f38 83e938 50 5f 51 52 }
            // n = 7, score = 100
            //   037e3c               | add                 edi, dword ptr [esi + 0x3c]
            //   8d4c0f38             | lea                 ecx, [edi + ecx + 0x38]
            //   83e938               | sub                 ecx, 0x38
            //   50                   | push                eax
            //   5f                   | pop                 edi
            //   51                   | push                ecx
            //   52                   | push                edx

        $sequence_5 = { 51 5d 59 55 59 6a01 }
            // n = 6, score = 100
            //   51                   | push                ecx
            //   5d                   | pop                 ebp
            //   59                   | pop                 ecx
            //   55                   | push                ebp
            //   59                   | pop                 ecx
            //   6a01                 | push                1

        $sequence_6 = { 8b8c2434020000 8d54240c 894c240c 6a04 52 56 59 }
            // n = 7, score = 100
            //   8b8c2434020000       | mov                 ecx, dword ptr [esp + 0x234]
            //   8d54240c             | lea                 edx, [esp + 0xc]
            //   894c240c             | mov                 dword ptr [esp + 0xc], ecx
            //   6a04                 | push                4
            //   52                   | push                edx
            //   56                   | push                esi
            //   59                   | pop                 ecx

        $sequence_7 = { 8365f000 8365f400 8365f800 8365fc00 c745f0900c0110 }
            // n = 5, score = 100
            //   8365f000             | and                 dword ptr [ebp - 0x10], 0
            //   8365f400             | and                 dword ptr [ebp - 0xc], 0
            //   8365f800             | and                 dword ptr [ebp - 8], 0
            //   8365fc00             | and                 dword ptr [ebp - 4], 0
            //   c745f0900c0110       | mov                 dword ptr [ebp - 0x10], 0x10010c90

        $sequence_8 = { 33c0 0306 395814 0f854b010000 8b4c2410 55 8f4614 }
            // n = 7, score = 100
            //   33c0                 | xor                 eax, eax
            //   0306                 | add                 eax, dword ptr [esi]
            //   395814               | cmp                 dword ptr [eax + 0x14], ebx
            //   0f854b010000         | jne                 0x151
            //   8b4c2410             | mov                 ecx, dword ptr [esp + 0x10]
            //   55                   | push                ebp
            //   8f4614               | pop                 dword ptr [esi + 0x14]

        $sequence_9 = { 741c 56 8b742414 ff36 59 41 51 }
            // n = 7, score = 100
            //   741c                 | je                  0x1e
            //   56                   | push                esi
            //   8b742414             | mov                 esi, dword ptr [esp + 0x14]
            //   ff36                 | push                dword ptr [esi]
            //   59                   | pop                 ecx
            //   41                   | inc                 ecx
            //   51                   | push                ecx

    condition:
        7 of them and filesize < 360448
}