rule win_warlock_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.warlock."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.warlock"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 8b95c0f6ffff f724ba 0385ccf6ffff 83d200 01841dc0f8ffff 8b9de0f6ffff 8b85bcf8ffff }
            // n = 7, score = 100
            //   8b95c0f6ffff         | mov                 edx, dword ptr [ebp - 0x940]
            //   f724ba               | mul                 dword ptr [edx + edi*4]
            //   0385ccf6ffff         | add                 eax, dword ptr [ebp - 0x934]
            //   83d200               | adc                 edx, 0
            //   01841dc0f8ffff       | add                 dword ptr [ebp + ebx - 0x740], eax
            //   8b9de0f6ffff         | mov                 ebx, dword ptr [ebp - 0x920]
            //   8b85bcf8ffff         | mov                 eax, dword ptr [ebp - 0x744]

        $sequence_1 = { 894c2420 c16c242008 331cc574e44900 0fb6c1 8b4c2410 0fb6c9 8b04c571e44900 }
            // n = 7, score = 100
            //   894c2420             | mov                 dword ptr [esp + 0x20], ecx
            //   c16c242008           | shr                 dword ptr [esp + 0x20], 8
            //   331cc574e44900       | xor                 ebx, dword ptr [eax*8 + 0x49e474]
            //   0fb6c1               | movzx               eax, cl
            //   8b4c2410             | mov                 ecx, dword ptr [esp + 0x10]
            //   0fb6c9               | movzx               ecx, cl
            //   8b04c571e44900       | mov                 eax, dword ptr [eax*8 + 0x49e471]

        $sequence_2 = { 03c2 8bd0 c1e81a 2b442448 81e2ffffff03 89542430 89542444 }
            // n = 7, score = 100
            //   03c2                 | add                 eax, edx
            //   8bd0                 | mov                 edx, eax
            //   c1e81a               | shr                 eax, 0x1a
            //   2b442448             | sub                 eax, dword ptr [esp + 0x48]
            //   81e2ffffff03         | and                 edx, 0x3ffffff
            //   89542430             | mov                 dword ptr [esp + 0x30], edx
            //   89542444             | mov                 dword ptr [esp + 0x44], edx

        $sequence_3 = { c70000000000 c7400800000000 c9 c20400 56 8bf1 8b8e80000000 }
            // n = 7, score = 100
            //   c70000000000         | mov                 dword ptr [eax], 0
            //   c7400800000000       | mov                 dword ptr [eax + 8], 0
            //   c9                   | leave               
            //   c20400               | ret                 4
            //   56                   | push                esi
            //   8bf1                 | mov                 esi, ecx
            //   8b8e80000000         | mov                 ecx, dword ptr [esi + 0x80]

        $sequence_4 = { 6a34 e8???????? 8945e8 59 85c0 740d 57 }
            // n = 7, score = 100
            //   6a34                 | push                0x34
            //   e8????????           |                     
            //   8945e8               | mov                 dword ptr [ebp - 0x18], eax
            //   59                   | pop                 ecx
            //   85c0                 | test                eax, eax
            //   740d                 | je                  0xf
            //   57                   | push                edi

        $sequence_5 = { 50 8d4de8 c745fc04000000 e8???????? eb0a 6a01 8d4de8 }
            // n = 7, score = 100
            //   50                   | push                eax
            //   8d4de8               | lea                 ecx, [ebp - 0x18]
            //   c745fc04000000       | mov                 dword ptr [ebp - 4], 4
            //   e8????????           |                     
            //   eb0a                 | jmp                 0xc
            //   6a01                 | push                1
            //   8d4de8               | lea                 ecx, [ebp - 0x18]

        $sequence_6 = { 80fb35 7e82 33c0 84db 0f95c0 05feff0000 e9???????? }
            // n = 7, score = 100
            //   80fb35               | cmp                 bl, 0x35
            //   7e82                 | jle                 0xffffff84
            //   33c0                 | xor                 eax, eax
            //   84db                 | test                bl, bl
            //   0f95c0               | setne               al
            //   05feff0000           | add                 eax, 0xfffe
            //   e9????????           |                     

        $sequence_7 = { 8b94249c000000 81c2feffff07 03c2 8bd0 c1e81a 81e2ffffff03 2b442458 }
            // n = 7, score = 100
            //   8b94249c000000       | mov                 edx, dword ptr [esp + 0x9c]
            //   81c2feffff07         | add                 edx, 0x7fffffe
            //   03c2                 | add                 eax, edx
            //   8bd0                 | mov                 edx, eax
            //   c1e81a               | shr                 eax, 0x1a
            //   81e2ffffff03         | and                 edx, 0x3ffffff
            //   2b442458             | sub                 eax, dword ptr [esp + 0x58]

        $sequence_8 = { 0f94c1 2500180000 2d00100000 f7d8 1bc0 40 f7c300800000 }
            // n = 7, score = 100
            //   0f94c1               | sete                cl
            //   2500180000           | and                 eax, 0x1800
            //   2d00100000           | sub                 eax, 0x1000
            //   f7d8                 | neg                 eax
            //   1bc0                 | sbb                 eax, eax
            //   40                   | inc                 eax
            //   f7c300800000         | test                ebx, 0x8000

        $sequence_9 = { 668b4306 663b45e4 7513 c6062d 8d7e01 8bcb 89bd70ffffff }
            // n = 7, score = 100
            //   668b4306             | mov                 ax, word ptr [ebx + 6]
            //   663b45e4             | cmp                 ax, word ptr [ebp - 0x1c]
            //   7513                 | jne                 0x15
            //   c6062d               | mov                 byte ptr [esi], 0x2d
            //   8d7e01               | lea                 edi, [esi + 1]
            //   8bcb                 | mov                 ecx, ebx
            //   89bd70ffffff         | mov                 dword ptr [ebp - 0x90], edi

    condition:
        7 of them and filesize < 1395712
}