rule win_warmcookie_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.warmcookie."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.warmcookie"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 41b900000000 41b807000000 ba00000080 4889c1 }
            // n = 4, score = 900
            //   41b900000000         | je                  0x1a1
            //   41b807000000         | inc                 ecx
            //   ba00000080           | mov                 eax, dword ptr [edx]
            //   4889c1               | test                eax, eax

        $sequence_1 = { 48c744243800000000 c744243000000000 c744242803000000 48c744242000000000 41b900000000 }
            // n = 5, score = 900
            //   48c744243800000000     | js    0x6c6
            //   c744243000000000     | lea                 eax, [eax + eax*4]
            //   c744242803000000     | lea                 eax, [ecx + eax*2 - 0x30]
            //   48c744242000000000     | inc    ecx
            //   41b900000000         | mov                 dword ptr [edx], eax

        $sequence_2 = { 41be01000000 4d85d2 0f8489010000 418b02 85c0 0f88c0060000 8d0480 }
            // n = 7, score = 900
            //   41be01000000         | dec                 eax
            //   4d85d2               | add                 esp, 0x58
            //   0f8489010000         | mov                 ecx, eax
            //   418b02               | dec                 ecx
            //   85c0                 | mov                 esp, eax
            //   0f88c0060000         | dec                 eax
            //   8d0480               | test                eax, eax

        $sequence_3 = { 4183fe03 0f87ff050000 4585f6 0f850a020000 41be01000000 4d85d2 }
            // n = 6, score = 900
            //   4183fe03             | pop                 edi
            //   0f87ff050000         | dec                 eax
            //   4585f6               | mov                 eax, dword ptr [ecx]
            //   0f850a020000         | call                dword ptr [eax + 0x10]
            //   41be01000000         | mov                 eax, esi
            //   4d85d2               | dec                 eax

        $sequence_4 = { 41b902000000 41b800000000 ba00000000 4889c1 }
            // n = 4, score = 900
            //   41b902000000         | dec                 eax
            //   41b800000000         | mov                 edx, eax
            //   ba00000000           | dec                 ecx
            //   4889c1               | mov                 ecx, ebx

        $sequence_5 = { 48896c2470 8944242c 48b8fffffffffdffffff 4889842480000000 31c0 6689842488000000 }
            // n = 6, score = 900
            //   48896c2470           | jne                 0x213
            //   8944242c             | inc                 ecx
            //   48b8fffffffffdffffff     | mov    esi, 1
            //   4889842480000000     | dec                 ebp
            //   31c0                 | test                edx, edx
            //   6689842488000000     | dec                 eax

        $sequence_6 = { 448b44244c 4989c4 4181f80080ffff 7470 }
            // n = 4, score = 900
            //   448b44244c           | inc                 ecx
            //   4989c4               | mov                 esi, 1
            //   4181f80080ffff       | dec                 ebp
            //   7470                 | test                edx, edx

        $sequence_7 = { 4883c468 5b 415c c3 55 }
            // n = 5, score = 900
            //   4883c468             | add                 esp, 0x58
            //   5b                   | pop                 ebx
            //   415c                 | pop                 esi
            //   c3                   | call                dword ptr [eax + 0x10]
            //   55                   | mov                 eax, esi

        $sequence_8 = { 4181f80080ffff 7470 8b4c2448 4889c2 4989d9 e8???????? }
            // n = 6, score = 900
            //   4181f80080ffff       | mov                 eax, dword ptr [edx]
            //   7470                 | test                eax, eax
            //   8b4c2448             | js                  0x6cb
            //   4889c2               | dec                 eax
            //   4989d9               | mov                 dword ptr [esp + 0x70], ebp
            //   e8????????           |                     

        $sequence_9 = { 8b530c 85d2 0f8e1bffffff 01d0 89430c e9???????? 4157 }
            // n = 7, score = 900
            //   8b530c               | je                  0x18f
            //   85d2                 | inc                 ecx
            //   0f8e1bffffff         | mov                 eax, dword ptr [edx]
            //   01d0                 | test                eax, eax
            //   89430c               | js                  0x6d1
            //   e9????????           |                     
            //   4157                 | lea                 eax, [eax + eax*4]

        $sequence_10 = { 4883ec28 e8???????? 3dff2f0000 0f97c0 }
            // n = 4, score = 700
            //   4883ec28             | dec                 eax
            //   e8????????           |                     
            //   3dff2f0000           | sub                 esp, 0x28
            //   0f97c0               | cmp                 eax, 0x2fff

        $sequence_11 = { ba19000000 488b4c2438 ff15???????? 85c0 }
            // n = 4, score = 700
            //   ba19000000           | seta                al
            //   488b4c2438           | movzx               eax, al
            //   ff15????????         |                     
            //   85c0                 | mov                 edx, 0x19

        $sequence_12 = { ba18000000 4889c1 ffd3 85c0 }
            // n = 4, score = 600
            //   ba18000000           | dec                 eax
            //   4889c1               | mov                 ecx, dword ptr [esp + 0x38]
            //   ffd3                 | test                eax, eax
            //   85c0                 | mov                 edx, 0x18

        $sequence_13 = { 85c0 7409 488b442428 48c1e814 }
            // n = 4, score = 600
            //   85c0                 | dec                 eax
            //   7409                 | mov                 ecx, eax
            //   488b442428           | call                ebx
            //   48c1e814             | test                eax, eax

        $sequence_14 = { 488b01 ff9080000000 85c0 7815 }
            // n = 4, score = 600
            //   488b01               | test                eax, eax
            //   ff9080000000         | je                  0xb
            //   85c0                 | dec                 eax
            //   7815                 | mov                 eax, dword ptr [esp + 0x28]

        $sequence_15 = { ff15???????? 25ff0f0000 8d88b80b0000 ff15???????? }
            // n = 4, score = 600
            //   ff15????????         |                     
            //   25ff0f0000           | dec                 eax
            //   8d88b80b0000         | shr                 eax, 0x14
            //   ff15????????         |                     

        $sequence_16 = { 488b01 ff5010 ff15???????? 89f0 4883c458 }
            // n = 5, score = 500
            //   488b01               | dec                 eax
            //   ff5010               | mov                 eax, dword ptr [ecx]
            //   ff15????????         |                     
            //   89f0                 | call                dword ptr [eax + 0x80]
            //   4883c458             | test                eax, eax

        $sequence_17 = { 8d8800040000 e8???????? 4889c3 4885c0 }
            // n = 4, score = 500
            //   8d8800040000         | js                  0x1f
            //   e8????????           |                     
            //   4889c3               | and                 eax, 0xfff
            //   4885c0               | lea                 ecx, [eax + 0xbb8]

        $sequence_18 = { 0fb6d1 488b0b ff15???????? 8b38 488bcb e8???????? 488b4c2448 }
            // n = 7, score = 300
            //   0fb6d1               | mov                 eax, 0xffffffff
            //   488b0b               | std                 
            //   ff15????????         |                     
            //   8b38                 | ja                  0x605
            //   488bcb               | inc                 ebp
            //   e8????????           |                     
            //   488b4c2448           | test                esi, esi

        $sequence_19 = { 85c0 7432 488d0c7d02000000 e8???????? 488bd8 4885c0 }
            // n = 6, score = 300
            //   85c0                 | inc                 ebp
            //   7432                 | test                esi, esi
            //   488d0c7d02000000     | cmp                 ax, 9
            //   e8????????           |                     
            //   488bd8               | ja                  0x613
            //   4885c0               | inc                 ecx

        $sequence_20 = { 48ffc7 66393478 75f7 4885ff 740d 488d4c2420 }
            // n = 6, score = 300
            //   48ffc7               | je                  0x1a1
            //   66393478             | movaps              xmmword ptr [esp + 0x30], xmm0
            //   75f7                 | inc                 esp
            //   4885ff               | mov                 eax, dword ptr [esp + 0x4c]
            //   740d                 | dec                 ecx
            //   488d4c2420           | mov                 esp, eax

        $sequence_21 = { 440fb64101 410fb6540902 410fb6440802 4188440902 4188540802 0fb601 }
            // n = 6, score = 300
            //   440fb64101           | sub                 eax, 0x30
            //   410fb6540902         | cmp                 ax, 9
            //   410fb6440802         | ja                  0x613
            //   4188440902           | inc                 ecx
            //   4188540802           | cmp                 esi, 3
            //   0fb601               | ja                  0x613

        $sequence_22 = { 488bce e8???????? 488b7c2468 8bc3 }
            // n = 4, score = 300
            //   488bce               | inc                 ecx
            //   e8????????           |                     
            //   488b7c2468           | cmp                 eax, 0xffff8000
            //   8bc3                 | je                  0x81

        $sequence_23 = { 4c8bc6 6683f822 744f 48ffc1 664289440420 }
            // n = 5, score = 300
            //   4c8bc6               | jne                 0x213
            //   6683f822             | inc                 ecx
            //   744f                 | mov                 esi, 1
            //   48ffc1               | dec                 ebp
            //   664289440420         | test                edx, edx

        $sequence_24 = { 488d542470 b901010000 ff15???????? 85c0 }
            // n = 4, score = 300
            //   488d542470           | mov                 dword ptr [esp + 0x70], ebp
            //   b901010000           | mov                 dword ptr [esp + 0x2c], eax
            //   ff15????????         |                     
            //   85c0                 | dec                 eax

    condition:
        7 of them and filesize < 331776
}