rule win_waterspout_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.waterspout."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.waterspout"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 68???????? 56 e8???????? 83c418 84c0 751e 6a01 }
            // n = 7, score = 200
            //   68????????           |                     
            //   56                   | push                esi
            //   e8????????           |                     
            //   83c418               | add                 esp, 0x18
            //   84c0                 | test                al, al
            //   751e                 | jne                 0x20
            //   6a01                 | push                1

        $sequence_1 = { 56 8d4c2420 8802 ff15???????? bf???????? 83c9ff }
            // n = 6, score = 200
            //   56                   | push                esi
            //   8d4c2420             | lea                 ecx, [esp + 0x20]
            //   8802                 | mov                 byte ptr [edx], al
            //   ff15????????         |                     
            //   bf????????           |                     
            //   83c9ff               | or                  ecx, 0xffffffff

        $sequence_2 = { 88442424 32c3 50 e8???????? 8a4c2420 8ad3 32d1 }
            // n = 7, score = 200
            //   88442424             | mov                 byte ptr [esp + 0x24], al
            //   32c3                 | xor                 al, bl
            //   50                   | push                eax
            //   e8????????           |                     
            //   8a4c2420             | mov                 cl, byte ptr [esp + 0x20]
            //   8ad3                 | mov                 dl, bl
            //   32d1                 | xor                 dl, cl

        $sequence_3 = { 83fe01 f3aa 8a842470200000 884500 }
            // n = 4, score = 200
            //   83fe01               | cmp                 esi, 1
            //   f3aa                 | rep stosb           byte ptr es:[edi], al
            //   8a842470200000       | mov                 al, byte ptr [esp + 0x2070]
            //   884500               | mov                 byte ptr [ebp], al

        $sequence_4 = { 57 57 50 ff15???????? 85c0 7540 8b0e }
            // n = 7, score = 200
            //   57                   | push                edi
            //   57                   | push                edi
            //   50                   | push                eax
            //   ff15????????         |                     
            //   85c0                 | test                eax, eax
            //   7540                 | jne                 0x42
            //   8b0e                 | mov                 ecx, dword ptr [esi]

        $sequence_5 = { 83c408 8d4c2414 c744241430750000 6a04 51 }
            // n = 5, score = 200
            //   83c408               | add                 esp, 8
            //   8d4c2414             | lea                 ecx, [esp + 0x14]
            //   c744241430750000     | mov                 dword ptr [esp + 0x14], 0x7530
            //   6a04                 | push                4
            //   51                   | push                ecx

        $sequence_6 = { c68424870000008f c684248800000092 c68424890000009d c684248a00000038 c684248b000000f5 c684248c000000bc c684248d000000b6 }
            // n = 7, score = 200
            //   c68424870000008f     | mov                 byte ptr [esp + 0x87], 0x8f
            //   c684248800000092     | mov                 byte ptr [esp + 0x88], 0x92
            //   c68424890000009d     | mov                 byte ptr [esp + 0x89], 0x9d
            //   c684248a00000038     | mov                 byte ptr [esp + 0x8a], 0x38
            //   c684248b000000f5     | mov                 byte ptr [esp + 0x8b], 0xf5
            //   c684248c000000bc     | mov                 byte ptr [esp + 0x8c], 0xbc
            //   c684248d000000b6     | mov                 byte ptr [esp + 0x8d], 0xb6

        $sequence_7 = { 8bb4240c200000 8d442410 6a00 50 6a00 6a00 6a00 }
            // n = 7, score = 200
            //   8bb4240c200000       | mov                 esi, dword ptr [esp + 0x200c]
            //   8d442410             | lea                 eax, [esp + 0x10]
            //   6a00                 | push                0
            //   50                   | push                eax
            //   6a00                 | push                0
            //   6a00                 | push                0
            //   6a00                 | push                0

        $sequence_8 = { 8dbc24ac030000 f3ab 8d442410 8d4c2418 50 8b842490630000 51 }
            // n = 7, score = 200
            //   8dbc24ac030000       | lea                 edi, [esp + 0x3ac]
            //   f3ab                 | rep stosd           dword ptr es:[edi], eax
            //   8d442410             | lea                 eax, [esp + 0x10]
            //   8d4c2418             | lea                 ecx, [esp + 0x18]
            //   50                   | push                eax
            //   8b842490630000       | mov                 eax, dword ptr [esp + 0x6390]
            //   51                   | push                ecx

        $sequence_9 = { 33ff 3bdf 897d00 7403 53 ffd6 }
            // n = 6, score = 200
            //   33ff                 | xor                 edi, edi
            //   3bdf                 | cmp                 ebx, edi
            //   897d00               | mov                 dword ptr [ebp], edi
            //   7403                 | je                  5
            //   53                   | push                ebx
            //   ffd6                 | call                esi

    condition:
        7 of them and filesize < 98304
}