rule win_webbytea_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.webbytea."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.webbytea"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 8901 488d542430 488b4c2420 ff15???????? }
            // n = 4, score = 300
            //   8901                 | mov                 word ptr [esp + 0x116], ax
            //   488d542430           | mov                 eax, 0x20
            //   488b4c2420           | mov                 word ptr [esp + 0x118], ax
            //   ff15????????         |                     

        $sequence_1 = { 8901 488d542430 488b4c2420 ff15???????? 85c0 }
            // n = 5, score = 300
            //   8901                 | mov                 eax, dword ptr [esp + 0xb8]
            //   488d542430           | cmp                 byte ptr [eax], 0
            //   488b4c2420           | jne                 0xd7d
            //   ff15????????         |                     
            //   85c0                 | dec                 eax

        $sequence_2 = { ff15???????? 85c0 7422 41b904000000 }
            // n = 4, score = 300
            //   ff15????????         |                     
            //   85c0                 | mov                 byte ptr [esp + 0x4d0], 0x47
            //   7422                 | mov                 byte ptr [esp + 0x4d1], 0x65
            //   41b904000000         | mov                 byte ptr [esp + 0x4d2], 0x74

        $sequence_3 = { ff15???????? 85c0 7444 41b904000000 }
            // n = 4, score = 300
            //   ff15????????         |                     
            //   85c0                 | mov                 byte ptr [esp + 0x1b0], 0x52
            //   7444                 | mov                 byte ptr [esp + 0x1b1], 0x65
            //   41b904000000         | mov                 byte ptr [esp + 0x2ae], 0x61

        $sequence_4 = { c68424f000000043 c68424f100000072 c68424f200000065 c68424f300000061 c68424f400000074 }
            // n = 5, score = 300
            //   c68424f000000043     | test                eax, eax
            //   c68424f100000072     | mov                 edx, dword ptr [esp + 0x48]
            //   c68424f200000065     | mov                 ecx, 0xffffffff
            //   c68424f300000061     | cmp                 eax, 1
            //   c68424f400000074     | jne                 0xe71

        $sequence_5 = { ffc0 488b8c2488020000 8901 488d542430 488b4c2420 ff15???????? 85c0 }
            // n = 7, score = 300
            //   ffc0                 | dec                 eax
            //   488b8c2488020000     | mov                 edi, eax
            //   8901                 | xor                 eax, eax
            //   488d542430           | mov                 ecx, 0x238
            //   488b4c2420           | rep stosb           byte ptr es:[edi], al
            //   ff15????????         |                     
            //   85c0                 | xor                 edx, edx

        $sequence_6 = { 4803c8 488bc1 48c744243000000000 c744242800000000 }
            // n = 4, score = 300
            //   4803c8               | inc                 ecx
            //   488bc1               | mov                 edi, 0x100
            //   48c744243000000000     | dec    esp
            //   c744242800000000     | lea                 esp, [0x9e18]

        $sequence_7 = { c68424f100000072 c68424f200000065 c68424f300000061 c68424f400000074 c68424f500000065 }
            // n = 5, score = 300
            //   c68424f100000072     | rep movsb           byte ptr es:[edi], byte ptr [esi]
            //   c68424f200000065     | mov                 eax, dword ptr [esp + 0x2978]
            //   c68424f300000061     | mov                 ecx, dword ptr [esp + 0x2f14]
            //   c68424f400000074     | add                 ecx, eax
            //   c68424f500000065     | mov                 ecx, eax

        $sequence_8 = { 8b00 ffc0 488b8c2488020000 8901 }
            // n = 4, score = 300
            //   8b00                 | mov                 eax, 0x6b
            //   ffc0                 | mov                 word ptr [esp + 0x98], ax
            //   488b8c2488020000     | mov                 eax, 0x6d
            //   8901                 | mov                 word ptr [esp + 0x9a], ax

        $sequence_9 = { c68424f100000072 c68424f200000065 c68424f300000061 c68424f400000074 }
            // n = 4, score = 300
            //   c68424f100000072     | mov                 byte ptr [esp + 0x59], 0
            //   c68424f200000065     | mov                 byte ptr [esp + 0x108], 0x43
            //   c68424f300000061     | mov                 byte ptr [esp + 0x109], 0x6c
            //   c68424f400000074     | mov                 byte ptr [esp + 0x59], 0

    condition:
        7 of them and filesize < 552960
}