rule win_webc2_ausov_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.webc2_ausov."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.webc2_ausov"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 83854cfaffff02 80bd46faffff00 75ae c78540faffff00000000 eb0b 1bc0 83d8ff }
            // n = 7, score = 100
            //   83854cfaffff02       | add                 dword ptr [ebp - 0x5b4], 2
            //   80bd46faffff00       | cmp                 byte ptr [ebp - 0x5ba], 0
            //   75ae                 | jne                 0xffffffb0
            //   c78540faffff00000000     | mov    dword ptr [ebp - 0x5c0], 0
            //   eb0b                 | jmp                 0xd
            //   1bc0                 | sbb                 eax, eax
            //   83d8ff               | sbb                 eax, -1

        $sequence_1 = { 0f8407000000 0f8501000000 f8 8b550c }
            // n = 4, score = 100
            //   0f8407000000         | je                  0xd
            //   0f8501000000         | jne                 7
            //   f8                   | clc                 
            //   8b550c               | mov                 edx, dword ptr [ebp + 0xc]

        $sequence_2 = { b941000000 33c0 8dbda9faffff f3ab }
            // n = 4, score = 100
            //   b941000000           | mov                 ecx, 0x41
            //   33c0                 | xor                 eax, eax
            //   8dbda9faffff         | lea                 edi, [ebp - 0x557]
            //   f3ab                 | rep stosd           dword ptr es:[edi], eax

        $sequence_3 = { 7546 80bd47faffff00 7431 8b8548faffff 8a4801 888d46faffff }
            // n = 6, score = 100
            //   7546                 | jne                 0x48
            //   80bd47faffff00       | cmp                 byte ptr [ebp - 0x5b9], 0
            //   7431                 | je                  0x33
            //   8b8548faffff         | mov                 eax, dword ptr [ebp - 0x5b8]
            //   8a4801               | mov                 cl, byte ptr [eax + 1]
            //   888d46faffff         | mov                 byte ptr [ebp - 0x5ba], cl

        $sequence_4 = { 0355f4 0fbe4201 3345f4 8945fc 0f8407000000 }
            // n = 5, score = 100
            //   0355f4               | add                 edx, dword ptr [ebp - 0xc]
            //   0fbe4201             | movsx               eax, byte ptr [edx + 1]
            //   3345f4               | xor                 eax, dword ptr [ebp - 0xc]
            //   8945fc               | mov                 dword ptr [ebp - 4], eax
            //   0f8407000000         | je                  0xd

        $sequence_5 = { 6a00 8d85a8faffff 50 8d8dbcfcffff }
            // n = 4, score = 100
            //   6a00                 | push                0
            //   8d85a8faffff         | lea                 eax, [ebp - 0x558]
            //   50                   | push                eax
            //   8d8dbcfcffff         | lea                 ecx, [ebp - 0x344]

        $sequence_6 = { 85c9 740d 85c0 7409 5f 5e }
            // n = 6, score = 100
            //   85c9                 | test                ecx, ecx
            //   740d                 | je                  0xf
            //   85c0                 | test                eax, eax
            //   7409                 | je                  0xb
            //   5f                   | pop                 edi
            //   5e                   | pop                 esi

        $sequence_7 = { 6a00 68???????? 8d85f8fbffff 50 e8???????? 83c408 50 }
            // n = 7, score = 100
            //   6a00                 | push                0
            //   68????????           |                     
            //   8d85f8fbffff         | lea                 eax, [ebp - 0x408]
            //   50                   | push                eax
            //   e8????????           |                     
            //   83c408               | add                 esp, 8
            //   50                   | push                eax

        $sequence_8 = { 0f8501000000 f8 68???????? 8d8dfcfbffff 51 e8???????? 83c408 }
            // n = 7, score = 100
            //   0f8501000000         | jne                 7
            //   f8                   | clc                 
            //   68????????           |                     
            //   8d8dfcfbffff         | lea                 ecx, [ebp - 0x404]
            //   51                   | push                ecx
            //   e8????????           |                     
            //   83c408               | add                 esp, 8

        $sequence_9 = { ffd3 8bf0 85f6 0f8487000000 8b3d???????? }
            // n = 5, score = 100
            //   ffd3                 | call                ebx
            //   8bf0                 | mov                 esi, eax
            //   85f6                 | test                esi, esi
            //   0f8487000000         | je                  0x8d
            //   8b3d????????         |                     

    condition:
        7 of them and filesize < 40960
}