rule win_webc2_bolid_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.webc2_bolid."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.webc2_bolid"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 7f31 8b8bc8000000 8b93c4000000 6a00 41 6a00 }
            // n = 6, score = 100
            //   7f31                 | jg                  0x33
            //   8b8bc8000000         | mov                 ecx, dword ptr [ebx + 0xc8]
            //   8b93c4000000         | mov                 edx, dword ptr [ebx + 0xc4]
            //   6a00                 | push                0
            //   41                   | inc                 ecx
            //   6a00                 | push                0

        $sequence_1 = { e8???????? 84c0 7427 8bcf 8b7b70 8d436c 8bd1 }
            // n = 7, score = 100
            //   e8????????           |                     
            //   84c0                 | test                al, al
            //   7427                 | je                  0x29
            //   8bcf                 | mov                 ecx, edi
            //   8b7b70               | mov                 edi, dword ptr [ebx + 0x70]
            //   8d436c               | lea                 eax, [ebx + 0x6c]
            //   8bd1                 | mov                 edx, ecx

        $sequence_2 = { 8b55ec 8d8d54ffffff 51 52 50 8d45a0 50 }
            // n = 7, score = 100
            //   8b55ec               | mov                 edx, dword ptr [ebp - 0x14]
            //   8d8d54ffffff         | lea                 ecx, [ebp - 0xac]
            //   51                   | push                ecx
            //   52                   | push                edx
            //   50                   | push                eax
            //   8d45a0               | lea                 eax, [ebp - 0x60]
            //   50                   | push                eax

        $sequence_3 = { e8???????? 8bd8 3bde 0f8e0c060000 8a451b 56 8d8d58ffffff }
            // n = 7, score = 100
            //   e8????????           |                     
            //   8bd8                 | mov                 ebx, eax
            //   3bde                 | cmp                 ebx, esi
            //   0f8e0c060000         | jle                 0x612
            //   8a451b               | mov                 al, byte ptr [ebp + 0x1b]
            //   56                   | push                esi
            //   8d8d58ffffff         | lea                 ecx, [ebp - 0xa8]

        $sequence_4 = { 83c40c 8b15???????? 8d4de4 52 }
            // n = 4, score = 100
            //   83c40c               | add                 esp, 0xc
            //   8b15????????         |                     
            //   8d4de4               | lea                 ecx, [ebp - 0x1c]
            //   52                   | push                edx

        $sequence_5 = { 8b4dec 8b75e4 03c1 894508 }
            // n = 4, score = 100
            //   8b4dec               | mov                 ecx, dword ptr [ebp - 0x14]
            //   8b75e4               | mov                 esi, dword ptr [ebp - 0x1c]
            //   03c1                 | add                 eax, ecx
            //   894508               | mov                 dword ptr [ebp + 8], eax

        $sequence_6 = { fec8 8801 eb09 51 e8???????? 83c404 8b7db8 }
            // n = 7, score = 100
            //   fec8                 | dec                 al
            //   8801                 | mov                 byte ptr [ecx], al
            //   eb09                 | jmp                 0xb
            //   51                   | push                ecx
            //   e8????????           |                     
            //   83c404               | add                 esp, 4
            //   8b7db8               | mov                 edi, dword ptr [ebp - 0x48]

        $sequence_7 = { 50 c3 6a02 e8???????? 59 c3 }
            // n = 6, score = 100
            //   50                   | push                eax
            //   c3                   | ret                 
            //   6a02                 | push                2
            //   e8????????           |                     
            //   59                   | pop                 ecx
            //   c3                   | ret                 

        $sequence_8 = { 8a01 4a 0fb6f0 f6860132410004 8807 7413 47 }
            // n = 7, score = 100
            //   8a01                 | mov                 al, byte ptr [ecx]
            //   4a                   | dec                 edx
            //   0fb6f0               | movzx               esi, al
            //   f6860132410004       | test                byte ptr [esi + 0x413201], 4
            //   8807                 | mov                 byte ptr [edi], al
            //   7413                 | je                  0x15
            //   47                   | inc                 edi

        $sequence_9 = { c68424240200000d e8???????? 83ec10 8d9424a0000000 8bcc 89a424c4000000 52 }
            // n = 7, score = 100
            //   c68424240200000d     | mov                 byte ptr [esp + 0x224], 0xd
            //   e8????????           |                     
            //   83ec10               | sub                 esp, 0x10
            //   8d9424a0000000       | lea                 edx, [esp + 0xa0]
            //   8bcc                 | mov                 ecx, esp
            //   89a424c4000000       | mov                 dword ptr [esp + 0xc4], esp
            //   52                   | push                edx

    condition:
        7 of them and filesize < 163840
}