rule win_webc2_cson_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.webc2_cson."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.webc2_cson"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 50 ff35???????? ff15???????? 33ff e9???????? }
            // n = 5, score = 100
            //   50                   | push                eax
            //   ff35????????         |                     
            //   ff15????????         |                     
            //   33ff                 | xor                 edi, edi
            //   e9????????           |                     

        $sequence_1 = { ff15???????? 395dfc 7463 8d8540fdffff 6800020000 50 }
            // n = 6, score = 100
            //   ff15????????         |                     
            //   395dfc               | cmp                 dword ptr [ebp - 4], ebx
            //   7463                 | je                  0x65
            //   8d8540fdffff         | lea                 eax, [ebp - 0x2c0]
            //   6800020000           | push                0x200
            //   50                   | push                eax

        $sequence_2 = { e8???????? 68???????? 56 e8???????? 8d85f0feffff }
            // n = 5, score = 100
            //   e8????????           |                     
            //   68????????           |                     
            //   56                   | push                esi
            //   e8????????           |                     
            //   8d85f0feffff         | lea                 eax, [ebp - 0x110]

        $sequence_3 = { 3bc3 8945f8 7513 68???????? ff15???????? 59 33c0 }
            // n = 7, score = 100
            //   3bc3                 | cmp                 eax, ebx
            //   8945f8               | mov                 dword ptr [ebp - 8], eax
            //   7513                 | jne                 0x15
            //   68????????           |                     
            //   ff15????????         |                     
            //   59                   | pop                 ecx
            //   33c0                 | xor                 eax, eax

        $sequence_4 = { 57 68???????? 6a50 68???????? }
            // n = 4, score = 100
            //   57                   | push                edi
            //   68????????           |                     
            //   6a50                 | push                0x50
            //   68????????           |                     

        $sequence_5 = { 3bf3 8975f8 0f8480010000 53 68???????? b8???????? 6a03 }
            // n = 7, score = 100
            //   3bf3                 | cmp                 esi, ebx
            //   8975f8               | mov                 dword ptr [ebp - 8], esi
            //   0f8480010000         | je                  0x186
            //   53                   | push                ebx
            //   68????????           |                     
            //   b8????????           |                     
            //   6a03                 | push                3

        $sequence_6 = { 83c420 6a01 58 eb02 33c0 5f 5e }
            // n = 7, score = 100
            //   83c420               | add                 esp, 0x20
            //   6a01                 | push                1
            //   58                   | pop                 eax
            //   eb02                 | jmp                 4
            //   33c0                 | xor                 eax, eax
            //   5f                   | pop                 edi
            //   5e                   | pop                 esi

        $sequence_7 = { 8d85ec6bfeff 50 e8???????? 59 68e8030000 }
            // n = 5, score = 100
            //   8d85ec6bfeff         | lea                 eax, [ebp - 0x19414]
            //   50                   | push                eax
            //   e8????????           |                     
            //   59                   | pop                 ecx
            //   68e8030000           | push                0x3e8

        $sequence_8 = { 7512 55 ffd6 57 ffd6 68???????? ff15???????? }
            // n = 7, score = 100
            //   7512                 | jne                 0x14
            //   55                   | push                ebp
            //   ffd6                 | call                esi
            //   57                   | push                edi
            //   ffd6                 | call                esi
            //   68????????           |                     
            //   ff15????????         |                     

        $sequence_9 = { 83c418 50 ff15???????? e9???????? 8d45c0 }
            // n = 5, score = 100
            //   83c418               | add                 esp, 0x18
            //   50                   | push                eax
            //   ff15????????         |                     
            //   e9????????           |                     
            //   8d45c0               | lea                 eax, [ebp - 0x40]

    condition:
        7 of them and filesize < 98304
}