rule win_webc2_greencat_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.webc2_greencat."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.webc2_greencat"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 59 0f85ab000000 bf28010000 8d85c0fdffff 57 53 }
            // n = 6, score = 100
            //   59                   | pop                 ecx
            //   0f85ab000000         | jne                 0xb1
            //   bf28010000           | mov                 edi, 0x128
            //   8d85c0fdffff         | lea                 eax, [ebp - 0x240]
            //   57                   | push                edi
            //   53                   | push                ebx

        $sequence_1 = { 50 e8???????? 53 50 894614 }
            // n = 5, score = 100
            //   50                   | push                eax
            //   e8????????           |                     
            //   53                   | push                ebx
            //   50                   | push                eax
            //   894614               | mov                 dword ptr [esi + 0x14], eax

        $sequence_2 = { 8d4dac ff750c e8???????? 85c0 7511 6830750000 }
            // n = 6, score = 100
            //   8d4dac               | lea                 ecx, [ebp - 0x54]
            //   ff750c               | push                dword ptr [ebp + 0xc]
            //   e8????????           |                     
            //   85c0                 | test                eax, eax
            //   7511                 | jne                 0x13
            //   6830750000           | push                0x7530

        $sequence_3 = { 53 ff15???????? 55 e8???????? 3bf3 59 7407 }
            // n = 7, score = 100
            //   53                   | push                ebx
            //   ff15????????         |                     
            //   55                   | push                ebp
            //   e8????????           |                     
            //   3bf3                 | cmp                 esi, ebx
            //   59                   | pop                 ecx
            //   7407                 | je                  9

        $sequence_4 = { e9???????? 8d45ac 50 ff750c e8???????? e9???????? 8b4508 }
            // n = 7, score = 100
            //   e9????????           |                     
            //   8d45ac               | lea                 eax, [ebp - 0x54]
            //   50                   | push                eax
            //   ff750c               | push                dword ptr [ebp + 0xc]
            //   e8????????           |                     
            //   e9????????           |                     
            //   8b4508               | mov                 eax, dword ptr [ebp + 8]

        $sequence_5 = { 58 e9???????? 56 be00010000 57 56 e8???????? }
            // n = 7, score = 100
            //   58                   | pop                 eax
            //   e9????????           |                     
            //   56                   | push                esi
            //   be00010000           | mov                 esi, 0x100
            //   57                   | push                edi
            //   56                   | push                esi
            //   e8????????           |                     

        $sequence_6 = { 5a 8b7508 668950f8 8950fc 668910 66895802 66895804 }
            // n = 7, score = 100
            //   5a                   | pop                 edx
            //   8b7508               | mov                 esi, dword ptr [ebp + 8]
            //   668950f8             | mov                 word ptr [eax - 8], dx
            //   8950fc               | mov                 dword ptr [eax - 4], edx
            //   668910               | mov                 word ptr [eax], dx
            //   66895802             | mov                 word ptr [eax + 2], bx
            //   66895804             | mov                 word ptr [eax + 4], bx

        $sequence_7 = { 8d0c30 03c6 2945ec 03d9 85f6 75ac 3975fc }
            // n = 7, score = 100
            //   8d0c30               | lea                 ecx, [eax + esi]
            //   03c6                 | add                 eax, esi
            //   2945ec               | sub                 dword ptr [ebp - 0x14], eax
            //   03d9                 | add                 ebx, ecx
            //   85f6                 | test                esi, esi
            //   75ac                 | jne                 0xffffffae
            //   3975fc               | cmp                 dword ptr [ebp - 4], esi

        $sequence_8 = { ff15???????? 83f8ff 8945ec 7411 ff15???????? 3db7000000 0f84de010000 }
            // n = 7, score = 100
            //   ff15????????         |                     
            //   83f8ff               | cmp                 eax, -1
            //   8945ec               | mov                 dword ptr [ebp - 0x14], eax
            //   7411                 | je                  0x13
            //   ff15????????         |                     
            //   3db7000000           | cmp                 eax, 0xb7
            //   0f84de010000         | je                  0x1e4

        $sequence_9 = { 50 ff15???????? 3bc7 59 7405 a3???????? 8a45ff }
            // n = 7, score = 100
            //   50                   | push                eax
            //   ff15????????         |                     
            //   3bc7                 | cmp                 eax, edi
            //   59                   | pop                 ecx
            //   7405                 | je                  7
            //   a3????????           |                     
            //   8a45ff               | mov                 al, byte ptr [ebp - 1]

    condition:
        7 of them and filesize < 57344
}