rule win_webc2_head_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.webc2_head."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.webc2_head"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { a4 8d049500000000 8d0c52 89442418 894c2438 8b44241c 8b00 }
            // n = 7, score = 100
            //   a4                   | movsb               byte ptr es:[edi], byte ptr [esi]
            //   8d049500000000       | lea                 eax, [edx*4]
            //   8d0c52               | lea                 ecx, [edx + edx*2]
            //   89442418             | mov                 dword ptr [esp + 0x18], eax
            //   894c2438             | mov                 dword ptr [esp + 0x38], ecx
            //   8b44241c             | mov                 eax, dword ptr [esp + 0x1c]
            //   8b00                 | mov                 eax, dword ptr [eax]

        $sequence_1 = { 735a 8bc8 83e01f c1f905 8b0c8d40cb4000 }
            // n = 5, score = 100
            //   735a                 | jae                 0x5c
            //   8bc8                 | mov                 ecx, eax
            //   83e01f               | and                 eax, 0x1f
            //   c1f905               | sar                 ecx, 5
            //   8b0c8d40cb4000       | mov                 ecx, dword ptr [ecx*4 + 0x40cb40]

        $sequence_2 = { 0f8550ffffff 8b542424 8b4c241c 3bd1 0f8dc9000000 2bca }
            // n = 6, score = 100
            //   0f8550ffffff         | jne                 0xffffff56
            //   8b542424             | mov                 edx, dword ptr [esp + 0x24]
            //   8b4c241c             | mov                 ecx, dword ptr [esp + 0x1c]
            //   3bd1                 | cmp                 edx, ecx
            //   0f8dc9000000         | jge                 0xcf
            //   2bca                 | sub                 ecx, edx

        $sequence_3 = { 83c40c f2ae f7d1 49 894c2414 7511 bf???????? }
            // n = 7, score = 100
            //   83c40c               | add                 esp, 0xc
            //   f2ae                 | repne scasb         al, byte ptr es:[edi]
            //   f7d1                 | not                 ecx
            //   49                   | dec                 ecx
            //   894c2414             | mov                 dword ptr [esp + 0x14], ecx
            //   7511                 | jne                 0x13
            //   bf????????           |                     

        $sequence_4 = { 0fb6fa 3bc7 7714 8b55fc 8a9220994000 }
            // n = 5, score = 100
            //   0fb6fa               | movzx               edi, dl
            //   3bc7                 | cmp                 eax, edi
            //   7714                 | ja                  0x16
            //   8b55fc               | mov                 edx, dword ptr [ebp - 4]
            //   8a9220994000         | mov                 dl, byte ptr [edx + 0x409920]

        $sequence_5 = { f2ae f7d1 49 51 68???????? 50 50 }
            // n = 7, score = 100
            //   f2ae                 | repne scasb         al, byte ptr es:[edi]
            //   f7d1                 | not                 ecx
            //   49                   | dec                 ecx
            //   51                   | push                ecx
            //   68????????           |                     
            //   50                   | push                eax
            //   50                   | push                eax

        $sequence_6 = { 8d9e38994000 803b00 8bcb 742c }
            // n = 4, score = 100
            //   8d9e38994000         | lea                 ebx, [esi + 0x409938]
            //   803b00               | cmp                 byte ptr [ebx], 0
            //   8bcb                 | mov                 ecx, ebx
            //   742c                 | je                  0x2e

        $sequence_7 = { f7d1 49 68???????? 68???????? 894c2438 e8???????? }
            // n = 6, score = 100
            //   f7d1                 | not                 ecx
            //   49                   | dec                 ecx
            //   68????????           |                     
            //   68????????           |                     
            //   894c2438             | mov                 dword ptr [esp + 0x38], ecx
            //   e8????????           |                     

        $sequence_8 = { f3ab 68???????? e8???????? 6a03 68???????? 68???????? }
            // n = 6, score = 100
            //   f3ab                 | rep stosd           dword ptr es:[edi], eax
            //   68????????           |                     
            //   e8????????           |                     
            //   6a03                 | push                3
            //   68????????           |                     
            //   68????????           |                     

        $sequence_9 = { 8b6c2424 884603 83c604 89742410 8bde }
            // n = 5, score = 100
            //   8b6c2424             | mov                 ebp, dword ptr [esp + 0x24]
            //   884603               | mov                 byte ptr [esi + 3], al
            //   83c604               | add                 esi, 4
            //   89742410             | mov                 dword ptr [esp + 0x10], esi
            //   8bde                 | mov                 ebx, esi

    condition:
        7 of them and filesize < 106496
}