rule win_webc2_kt3_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.webc2_kt3."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.webc2_kt3"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 83c1ff 51 8b4df4 51 8b15???????? 52 }
            // n = 6, score = 100
            //   83c1ff               | add                 ecx, -1
            //   51                   | push                ecx
            //   8b4df4               | mov                 ecx, dword ptr [ebp - 0xc]
            //   51                   | push                ecx
            //   8b15????????         |                     
            //   52                   | push                edx

        $sequence_1 = { 51 e8???????? 83c404 8985e0fbffff 8b85e0fbffff 8985ecfbffff }
            // n = 6, score = 100
            //   51                   | push                ecx
            //   e8????????           |                     
            //   83c404               | add                 esp, 4
            //   8985e0fbffff         | mov                 dword ptr [ebp - 0x420], eax
            //   8b85e0fbffff         | mov                 eax, dword ptr [ebp - 0x420]
            //   8985ecfbffff         | mov                 dword ptr [ebp - 0x414], eax

        $sequence_2 = { 8b4dfc 0fbe5103 83fa3e 750f }
            // n = 4, score = 100
            //   8b4dfc               | mov                 ecx, dword ptr [ebp - 4]
            //   0fbe5103             | movsx               edx, byte ptr [ecx + 3]
            //   83fa3e               | cmp                 edx, 0x3e
            //   750f                 | jne                 0x11

        $sequence_3 = { 0f8408000000 0f8502000000 ebe9 c745dc00000000 }
            // n = 4, score = 100
            //   0f8408000000         | je                  0xe
            //   0f8502000000         | jne                 8
            //   ebe9                 | jmp                 0xffffffeb
            //   c745dc00000000       | mov                 dword ptr [ebp - 0x24], 0

        $sequence_4 = { 8b55f8 2b55fc 8955f8 ebb7 8b4510 5f }
            // n = 6, score = 100
            //   8b55f8               | mov                 edx, dword ptr [ebp - 8]
            //   2b55fc               | sub                 edx, dword ptr [ebp - 4]
            //   8955f8               | mov                 dword ptr [ebp - 8], edx
            //   ebb7                 | jmp                 0xffffffb9
            //   8b4510               | mov                 eax, dword ptr [ebp + 0x10]
            //   5f                   | pop                 edi

        $sequence_5 = { 51 8b55f4 52 8d4de4 e8???????? 8b45e8 }
            // n = 6, score = 100
            //   51                   | push                ecx
            //   8b55f4               | mov                 edx, dword ptr [ebp - 0xc]
            //   52                   | push                edx
            //   8d4de4               | lea                 ecx, [ebp - 0x1c]
            //   e8????????           |                     
            //   8b45e8               | mov                 eax, dword ptr [ebp - 0x18]

        $sequence_6 = { 8b4dfc 83c10b 894df4 6a20 }
            // n = 4, score = 100
            //   8b4dfc               | mov                 ecx, dword ptr [ebp - 4]
            //   83c10b               | add                 ecx, 0xb
            //   894df4               | mov                 dword ptr [ebp - 0xc], ecx
            //   6a20                 | push                0x20

        $sequence_7 = { 8d41fc 8b4c2404 2bc1 c3 6800000300 }
            // n = 5, score = 100
            //   8d41fc               | lea                 eax, [ecx - 4]
            //   8b4c2404             | mov                 ecx, dword ptr [esp + 4]
            //   2bc1                 | sub                 eax, ecx
            //   c3                   | ret                 
            //   6800000300           | push                0x30000

        $sequence_8 = { 8dbdecfeffff 83c9ff 33c0 f2ae f7d1 83c1ff }
            // n = 6, score = 100
            //   8dbdecfeffff         | lea                 edi, [ebp - 0x114]
            //   83c9ff               | or                  ecx, 0xffffffff
            //   33c0                 | xor                 eax, eax
            //   f2ae                 | repne scasb         al, byte ptr es:[edi]
            //   f7d1                 | not                 ecx
            //   83c1ff               | add                 ecx, -1

        $sequence_9 = { 51 8b55f4 52 8d4de4 e8???????? }
            // n = 5, score = 100
            //   51                   | push                ecx
            //   8b55f4               | mov                 edx, dword ptr [ebp - 0xc]
            //   52                   | push                edx
            //   8d4de4               | lea                 ecx, [ebp - 0x1c]
            //   e8????????           |                     

    condition:
        7 of them and filesize < 114688
}