rule win_webc2_qbp_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.webc2_qbp."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.webc2_qbp"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 7f12 8b4508 0345fc 33c9 8a08 83e930 894df4 }
            // n = 7, score = 100
            //   7f12                 | jg                  0x14
            //   8b4508               | mov                 eax, dword ptr [ebp + 8]
            //   0345fc               | add                 eax, dword ptr [ebp - 4]
            //   33c9                 | xor                 ecx, ecx
            //   8a08                 | mov                 cl, byte ptr [eax]
            //   83e930               | sub                 ecx, 0x30
            //   894df4               | mov                 dword ptr [ebp - 0xc], ecx

        $sequence_1 = { 25ffff0000 2500800000 c1f80f 8be5 5d c3 55 }
            // n = 7, score = 100
            //   25ffff0000           | and                 eax, 0xffff
            //   2500800000           | and                 eax, 0x8000
            //   c1f80f               | sar                 eax, 0xf
            //   8be5                 | mov                 esp, ebp
            //   5d                   | pop                 ebp
            //   c3                   | ret                 
            //   55                   | push                ebp

        $sequence_2 = { 8b5508 52 ff15???????? 8d85f0feffff 50 }
            // n = 5, score = 100
            //   8b5508               | mov                 edx, dword ptr [ebp + 8]
            //   52                   | push                edx
            //   ff15????????         |                     
            //   8d85f0feffff         | lea                 eax, [ebp - 0x110]
            //   50                   | push                eax

        $sequence_3 = { 0fbf94414c520000 81fa00100000 7505 e9???????? 0fbf4508 8b4df8 }
            // n = 6, score = 100
            //   0fbf94414c520000     | movsx               edx, word ptr [ecx + eax*2 + 0x524c]
            //   81fa00100000         | cmp                 edx, 0x1000
            //   7505                 | jne                 7
            //   e9????????           |                     
            //   0fbf4508             | movsx               eax, word ptr [ebp + 8]
            //   8b4df8               | mov                 ecx, dword ptr [ebp - 8]

        $sequence_4 = { 81e1ff000000 51 8b4de4 e8???????? }
            // n = 4, score = 100
            //   81e1ff000000         | and                 ecx, 0xff
            //   51                   | push                ecx
            //   8b4de4               | mov                 ecx, dword ptr [ebp - 0x1c]
            //   e8????????           |                     

        $sequence_5 = { aa 837d0800 7564 6800010000 6a00 8d85ecfdffff 50 }
            // n = 7, score = 100
            //   aa                   | stosb               byte ptr es:[edi], al
            //   837d0800             | cmp                 dword ptr [ebp + 8], 0
            //   7564                 | jne                 0x66
            //   6800010000           | push                0x100
            //   6a00                 | push                0
            //   8d85ecfdffff         | lea                 eax, [ebp - 0x214]
            //   50                   | push                eax

        $sequence_6 = { 66898c5038770000 0fbf55f0 8b45ec 668b8c50907e0000 66894df8 }
            // n = 5, score = 100
            //   66898c5038770000     | mov                 word ptr [eax + edx*2 + 0x7738], cx
            //   0fbf55f0             | movsx               edx, word ptr [ebp - 0x10]
            //   8b45ec               | mov                 eax, dword ptr [ebp - 0x14]
            //   668b8c50907e0000     | mov                 cx, word ptr [eax + edx*2 + 0x7e90]
            //   66894df8             | mov                 word ptr [ebp - 8], cx

        $sequence_7 = { 668b9176830000 668955fc 8b45f8 668b8876830000 66d1e1 8b55f8 }
            // n = 6, score = 100
            //   668b9176830000       | mov                 dx, word ptr [ecx + 0x8376]
            //   668955fc             | mov                 word ptr [ebp - 4], dx
            //   8b45f8               | mov                 eax, dword ptr [ebp - 8]
            //   668b8876830000       | mov                 cx, word ptr [eax + 0x8376]
            //   66d1e1               | shl                 cx, 1
            //   8b55f8               | mov                 edx, dword ptr [ebp - 8]

        $sequence_8 = { 66050100 668945f4 e9???????? 66c745f80000 66c745f43a01 eb18 }
            // n = 6, score = 100
            //   66050100             | add                 ax, 1
            //   668945f4             | mov                 word ptr [ebp - 0xc], ax
            //   e9????????           |                     
            //   66c745f80000         | mov                 word ptr [ebp - 8], 0
            //   66c745f43a01         | mov                 word ptr [ebp - 0xc], 0x13a
            //   eb18                 | jmp                 0x1a

        $sequence_9 = { 0fbf5508 0fbf45fc 8b4df8 8b75f8 668b945648100000 6689944148100000 }
            // n = 6, score = 100
            //   0fbf5508             | movsx               edx, word ptr [ebp + 8]
            //   0fbf45fc             | movsx               eax, word ptr [ebp - 4]
            //   8b4df8               | mov                 ecx, dword ptr [ebp - 8]
            //   8b75f8               | mov                 esi, dword ptr [ebp - 8]
            //   668b945648100000     | mov                 dx, word ptr [esi + edx*2 + 0x1048]
            //   6689944148100000     | mov                 word ptr [ecx + eax*2 + 0x1048], dx

    condition:
        7 of them and filesize < 630784
}