rule win_webc2_ugx_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.webc2_ugx."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.webc2_ugx"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { ff969c060000 3bc3 89458c 0f8497030000 }
            // n = 4, score = 100
            //   ff969c060000         | call                dword ptr [esi + 0x69c]
            //   3bc3                 | cmp                 eax, ebx
            //   89458c               | mov                 dword ptr [ebp - 0x74], eax
            //   0f8497030000         | je                  0x39d

        $sequence_1 = { 57 ff969c060000 3bc3 8945d8 0f8487020000 }
            // n = 5, score = 100
            //   57                   | push                edi
            //   ff969c060000         | call                dword ptr [esi + 0x69c]
            //   3bc3                 | cmp                 eax, ebx
            //   8945d8               | mov                 dword ptr [ebp - 0x28], eax
            //   0f8487020000         | je                  0x28d

        $sequence_2 = { 50 ff7508 ff969c060000 3bc3 8945bc 0f84a2040000 8b7db4 }
            // n = 7, score = 100
            //   50                   | push                eax
            //   ff7508               | push                dword ptr [ebp + 8]
            //   ff969c060000         | call                dword ptr [esi + 0x69c]
            //   3bc3                 | cmp                 eax, ebx
            //   8945bc               | mov                 dword ptr [ebp - 0x44], eax
            //   0f84a2040000         | je                  0x4a8
            //   8b7db4               | mov                 edi, dword ptr [ebp - 0x4c]

        $sequence_3 = { ff55c0 57 ff55f8 ff55e8 }
            // n = 4, score = 100
            //   ff55c0               | call                dword ptr [ebp - 0x40]
            //   57                   | push                edi
            //   ff55f8               | call                dword ptr [ebp - 8]
            //   ff55e8               | call                dword ptr [ebp - 0x18]

        $sequence_4 = { 50 e8???????? 6a01 6a10 57 68420d0000 }
            // n = 6, score = 100
            //   50                   | push                eax
            //   e8????????           |                     
            //   6a01                 | push                1
            //   6a10                 | push                0x10
            //   57                   | push                edi
            //   68420d0000           | push                0xd42

        $sequence_5 = { aa 33c0 8d7d9d 885d9c c645d47a ab ab }
            // n = 7, score = 100
            //   aa                   | stosb               byte ptr es:[edi], al
            //   33c0                 | xor                 eax, eax
            //   8d7d9d               | lea                 edi, [ebp - 0x63]
            //   885d9c               | mov                 byte ptr [ebp - 0x64], bl
            //   c645d47a             | mov                 byte ptr [ebp - 0x2c], 0x7a
            //   ab                   | stosd               dword ptr es:[edi], eax
            //   ab                   | stosd               dword ptr es:[edi], eax

        $sequence_6 = { 50 ff15???????? 85c0 7455 8d85a8feffff }
            // n = 5, score = 100
            //   50                   | push                eax
            //   ff15????????         |                     
            //   85c0                 | test                eax, eax
            //   7455                 | je                  0x57
            //   8d85a8feffff         | lea                 eax, [ebp - 0x158]

        $sequence_7 = { 8d86a4080000 50 57 ff969c060000 3bc3 894594 0f84a7020000 }
            // n = 7, score = 100
            //   8d86a4080000         | lea                 eax, [esi + 0x8a4]
            //   50                   | push                eax
            //   57                   | push                edi
            //   ff969c060000         | call                dword ptr [esi + 0x69c]
            //   3bc3                 | cmp                 eax, ebx
            //   894594               | mov                 dword ptr [ebp - 0x6c], eax
            //   0f84a7020000         | je                  0x2ad

        $sequence_8 = { f3ab 66ab aa 33c0 8d7de9 885de8 8b7508 }
            // n = 7, score = 100
            //   f3ab                 | rep stosd           dword ptr es:[edi], eax
            //   66ab                 | stosw               word ptr es:[edi], ax
            //   aa                   | stosb               byte ptr es:[edi], al
            //   33c0                 | xor                 eax, eax
            //   8d7de9               | lea                 edi, [ebp - 0x17]
            //   885de8               | mov                 byte ptr [ebp - 0x18], bl
            //   8b7508               | mov                 esi, dword ptr [ebp + 8]

        $sequence_9 = { e9???????? 8d86ae090000 50 57 ff969c060000 3bc3 8945c0 }
            // n = 7, score = 100
            //   e9????????           |                     
            //   8d86ae090000         | lea                 eax, [esi + 0x9ae]
            //   50                   | push                eax
            //   57                   | push                edi
            //   ff969c060000         | call                dword ptr [esi + 0x69c]
            //   3bc3                 | cmp                 eax, ebx
            //   8945c0               | mov                 dword ptr [ebp - 0x40], eax

    condition:
        7 of them and filesize < 57344
}